
//=============================================================================
/**
 * @file   CameraTarget.cpp
 * @brief  J^[QbgǗNX
 * @author rc N
 * @date   2012.05.31
 */
//=============================================================================

#include "CameraTarget.h"
#include "../player/FieldPlayerGrid.h"

namespace field
{
  //-----------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------
  CCameraTarget::CCameraTarget() :
  m_pTarget(NULL) ,
  m_inWorldMat(gfl::math::MTX34_IDENTITY) ,
  m_inCenterPosi(gfl::math::VEC3_ZERO) ,
  m_inDir(gfl::math::VEC3_UNIT_Z) ,
  m_fYaw(0.0f) ,
  m_fPitch(0.0f)
  {
    return ;
  }

  //-----------------------------------------------------------------------------
  // t[
  //-----------------------------------------------------------------------------
  void CCameraTarget::Update(const PlayerGrid* pTarget)
  {
    m_pTarget = pTarget;

    pTarget->GetModel()->GetDirDispWay(&m_inDir);
    gfl::math::MTX33 inMat; CSpace::CreateMTX33ByFrontUpDirection(&inMat, m_inDir, gfl::math::VEC3_UNIT_Y);
    gfl::math::VEC3  inRootPosi; pTarget->GetPos(&inRootPosi);

    const float UP_OFST = CONVERT_TO_METER(0.9f);
    gfl::math::VEC3 inAxisY; gfl::math::MTX33GetAxisY(&inAxisY, inMat);
    m_inCenterPosi = inRootPosi + inAxisY*UP_OFST;

    gfl::math::MTX34SetMTX33VEC3(&m_inWorldMat, inMat, inRootPosi);

    CSpace::GetYawPitchByDirection(&m_fYaw, &m_fPitch, m_inDir);
  }

  //-----------------------------------------------------------------------------
  // fobO`
  //-----------------------------------------------------------------------------
  void CCameraTarget::DrawDebug()
  {
    CDebugPrim::DrawSpaceAxisByMTX34(m_inWorldMat, CONVERT_TO_METER(1.5f));
    CDebugPrim::DrawArrow(m_inCenterPosi, m_inDir, CONVERT_TO_METER(1.5f), VEC4_COLOR_PURPLE);
  }

} // namespace field

/*  EOF  */





