

#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CLostChildManager.cpp
 * @brief  [VlC~jQ[]qNXǗ
 \[X̊ǗsB
 * @author junya ikuta
 * @date   2012/05/23() 17:21
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// sys

// appSys
#include "resource\test_ikuta_game_resource_LostChild.h"

// app
#include "test_ikuta_game_CLostChildManager.h"
#include "test_ikuta_game_CLostChild.h"
#include "test_ikuta_game_CPlayer.h"


namespace test {
  namespace ikuta {
    namespace game {

      const u32 ARC_DATID_LOST_CHILD(GARC_ikuta_game_poppo_BCMDL_LZ);

      const u32 NUM_LOST_CHILD(5);


      // q̏
      const CLostChild::SETUP_PARAM A_LOST_CHILD_SETUP[ NUM_LOST_CHILD ] = {

        CLostChild::SETUP_PARAM
          (
           gfl::math::VEC3(0.0f, 0.0f, -500.0f),
           0.0f
          ),
        CLostChild::SETUP_PARAM
          (
           gfl::math::VEC3(0.0f, 50.0f, -700.0f),
           0.0f
          ),
        CLostChild::SETUP_PARAM
          (
           gfl::math::VEC3(50.0f, 0.0f, -850.0f),
           0.0f
          ),
        CLostChild::SETUP_PARAM
          (
           gfl::math::VEC3(50.0f, 50.0f, -1000.0f),
           0.0f
          ),
        CLostChild::SETUP_PARAM
          (
           gfl::math::VEC3(0.0f, 0.0f, -1200.0f),
           0.0f
          )
      };



      //------------------------------------------------------------------
      /**
       * @name      CLostChildManager[RXgN^]
       * @brief     ϐ̏s
       */
      //------------------------------------------------------------------
      CLostChildManager::CLostChildManager( void ) : 
        m_State( STATE_NULL ),
        m_pRentalPtrSet( NULL ),
        m_pLostChildArray( NULL ),
        m_ppLostChildField( NULL ),
        m_ppLostChildHold( NULL ),
        m_pLastHold( NULL ),
        m_NumHoldChild( 0 ),
        m_pModelRes( NULL ),
        m_pBuf( NULL ),
        m_pResAnimationArray( NULL ),
        m_ppBufAnimationArray( NULL ),
        m_ppAnimationArray( NULL )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name      ~CLostChildManager[fXgN^]
       * @brief     Finalize()ĂяoB
       */
      //------------------------------------------------------------------
      CLostChildManager::~CLostChildManager( void )
      {
        Finalize();
      }

      //------------------------------------------------------------------
      /**
       * @name      Initialize
       * @brief     A[hI܂ŊĂ܂B 
       * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
       * @pram      rSetUp      [const,default]
       * @return    true : [hԂɓ
       */
      //------------------------------------------------------------------
      bool CLostChildManager::Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp)
      {
        // `FbN
        //   GFL_ASSERT
        //  rRentalPtr.

        // ܂؂蕨[
        m_pRentalPtrSet = GFL_NEW( rRentalPtr.pHeap->pHeap )RENTAL_PTR_SET;
        *m_pRentalPtrSet = rRentalPtr;

        // f\[X̐(̎_ł̓[hĂȂ)
        //    m_pModelRes = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Resource();

        // 񓯊\[X̓ǂݍ
        m_pRentalPtrSet->pFileReadManager->AddReadRequest(
            &m_pBuf,
            NULL,
            m_pRentalPtrSet->pHeap->pDevHeap,
            128,
            rSetUp.arcId,
            ARC_DATID_LOST_CHILD,
            true
            );

        // Aj[V\[X̍쐬
        m_pResAnimationArray = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Resource[LOST_CHILD_ANIMATION_MAX];
        m_ppBufAnimationArray = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) void* [LOST_CHILD_ANIMATION_MAX];
        m_ppAnimationArray = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::ResAnim* [LOST_CHILD_ANIMATION_MAX];

        //        gfl::grp::g3d::Resource* pSelect( m_pResAnimationArray );
        for( u32 i = 0; i < LOST_CHILD_ANIMATION_MAX; i++)
        {
          m_ppAnimationArray[i] = NULL;

          m_pRentalPtrSet->pFileReadManager->AddReadRequest(
              &m_ppBufAnimationArray[i],
              NULL,
              m_pRentalPtrSet->pHeap->pDevHeap,
              128,
              rSetUp.arcId,
              A_LOST_CHILD_ARCID_ANIMATION[i],
              true
              );
        }

        // [hԂɈڍs
        base::LoadStart();
        m_State = STATE_LOAD;

        m_NumHoldChild = 0;
        m_pLastHold = m_pRentalPtrSet->pPlayer;

        return true;
      }

      //------------------------------------------------------------------
      /**
       * @name     Reset
       * @brief    p[^AInitializeɐ퓮AInitializȅԂɂȂ
       */
      //------------------------------------------------------------------
      void CLostChildManager::Reset( void )
      {
      }

      //------------------------------------------------------------------
      /**
       * @name     Finalize
       * @brief    I
       */
      //------------------------------------------------------------------
      void CLostChildManager::Finalize( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name      Update
       * @brief     XV
       * @return    ݂̏
       */
      //------------------------------------------------------------------
      CLostChildManager::STATE CLostChildManager::Update( void )
      {
        switch( m_State )
        {
        case STATE_LOAD:
          LoadUpdate();
          break;
        case STATE_UPDATE:

          // ێĂq̍XV
          CLostChild* pSelect(m_pLostChildArray);
          for(u32 i = 0; i < NUM_LOST_CHILD; i++, pSelect++)
          {
            pSelect->Update();
          }
          break;
        }

        return m_State;
      }

      //------------------------------------------------------------------
      /**
       * @name     LoadUpdate[virtual]
       * @brief    [hǂݐi߂鏃z֐A[hIŕKSetUpLoadAndSetupEnd()ĂԁB
       * @return   true : [hs
       */
      //------------------------------------------------------------------
      bool CLostChildManager::LoadUpdate(void)
      {
        if(m_State != STATE_LOAD)
          return false;

        bool endFlag(true);

        // Aj[V̓ǂݍ
        for( u32 i = 0; i < LOST_CHILD_ANIMATION_MAX; i++)
        {
          // ς
          if(m_ppAnimationArray[i])
            continue;

          // ǂݍݑ҂
          if( m_pRentalPtrSet->pFileReadManager->IsReadFinished(&m_ppBufAnimationArray[i]) )
          {
            gfl::grp::g3d::Resource::Description resource_description;
            // ǂݍ񂾂̂\[XɃA^b`
            m_pResAnimationArray[i].AttachBuffer( 
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                m_ppBufAnimationArray[i], 
                &resource_description, 
                true                      // buf̌n
                );
            m_ppBufAnimationArray[i] = NULL;

            // Aj[VIuWFNg̐
            m_ppAnimationArray[i] = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::ResAnim();
            m_ppAnimationArray[i]->Create( 
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                &m_pResAnimationArray[i],
                0,
                gfl::grp::g3d::ResAnim::TYPE_SKELETAL
                );
          }
          else 
          {
            endFlag = false;
          }
        }

        // fǂݍ
        if( !m_pModelRes )
        {
          // ǂݍ݂҂
          if( m_pRentalPtrSet->pFileReadManager->IsReadFinished(&m_pBuf) )
          {
            m_pModelRes = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Resource();

            // ftHgVF[_[gp            
            gfl::grp::g3d::Resource::Description resource_description;
            u32 common_resource_flag = gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE;
            common_resource_flag |= gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT;

            // ǂݍ񂾂̂\[XɃA^b`
            m_pModelRes->AttachBuffer( 
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                m_pBuf, 
                &resource_description, 
                true                      // buf̌n
                );
            m_pModelRes->Setup( m_pRentalPtrSet->pHeap->pDevHeapAllocator , NULL, common_resource_flag);
            m_pBuf = NULL;
          }
          else
          {
            endFlag = false;
          }
        }

        if( endFlag )
        {
          // ǗqB쐬
          m_pLostChildArray = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) CLostChild[NUM_LOST_CHILD];
          CLostChild* pSelect(m_pLostChildArray);

          CLostChild::RENTAL_PTR_SET lostChildRentalPtrSet;
          //   CLostChild::SETUP_PARAM    lostChildSetUpParam;
          lostChildRentalPtrSet.pScene = m_pRentalPtrSet->pScene;
          lostChildRentalPtrSet.pHeap = m_pRentalPtrSet->pHeap;
          lostChildRentalPtrSet.pModelRes = m_pModelRes;
          lostChildRentalPtrSet.ppAnimationArray = m_ppAnimationArray;

          // Ǘpz
          m_ppLostChildField = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) CLostChild* [NUM_LOST_CHILD];
          m_ppLostChildHold = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) CLostChild* [NUM_LOST_CHILD];
          CLostChild** ppSelect( m_ppLostChildField );

          for(u32 i = 0; i < NUM_LOST_CHILD; i++, pSelect++, ppSelect++)
          {
            pSelect->Initialize(lostChildRentalPtrSet, A_LOST_CHILD_SETUP[i]);
            *(ppSelect) = pSelect;
          }

          m_State = STATE_UPDATE;
          base::LoadAndSetupEnd();

          return false;
        }

        return true;
      }

      //------------------------------------------------------------------
      /**
       * @name      Draw
       * @brief     `揈Aʂfɔf
       */
      //------------------------------------------------------------------
      void CLostChildManager::Draw( void )
      {
        switch( m_State )
        {
        case STATE_LOAD:
          break;
        case STATE_UPDATE:

          // ێĂq̍XV
          CLostChild* pSelect(m_pLostChildArray);
          for(u32 i = 0; i < NUM_LOST_CHILD; i++, pSelect++)
          {
            pSelect->Draw();
          }
          break;
        }
      }

      //------------------------------------------------------------------
      /**
       * @name      PlayerHitFunc
       * @brief     vC[Ƃ̂蔻菈
       */
      //------------------------------------------------------------------
      void CLostChildManager::PlayerHitFunc( void )
      {
        if( m_NumHoldChild == NUM_LOST_CHILD)
          return;

        CLostChild** ppSelect(&m_ppLostChildField[0]);
        for( u32 i = 0; i < NUM_LOST_CHILD - m_NumHoldChild; )
        {
          if( m_pRentalPtrSet->pPlayer->IsHit(**ppSelect) )
          {
            HoldChild( i );
          }
          else
          {
            i++;
            ppSelect++;
          }
        }
      }

      //------------------------------------------------------------------
      /**
       * @name     GetNumHoldChild[const]
       * @brief    ߂܂ꂽq̐擾
       * @return   ߂܂ꂽq̐
       */
      //------------------------------------------------------------------
      u32 CLostChildManager::GetNumHoldChild( void ) const 
      {
        return m_NumHoldChild;
      }

      //------------------------------------------------------------------
      /**
       * @name      AddScene
       * @brief     V[Ɏgǉ
       */
      //------------------------------------------------------------------
      void CLostChildManager::AddScene(void)
      {
        CLostChild* pSelect(m_pLostChildArray);
        for(u32 i = 0; i < NUM_LOST_CHILD; i++, pSelect++)
        {
          pSelect->AddScene();
        }
      }

      //------------------------------------------------------------------
      /**
       * @name      RemoveScene
       * @brief     V[玩g菜
       */
      //------------------------------------------------------------------
      void CLostChildManager::RemoveScene(void)
      {
        CLostChild* pSelect(m_pLostChildArray);
        for(u32 i = 0; i < NUM_LOST_CHILD; i++, pSelect++)
        {
          pSelect->RemoveScene();
        }
      }

      // protected

      //------------------------------------------------------------------
      /**
       * @name     HoldChild
       * @brief    wIndex(m_ppLostChildField)̖qߊlςݔz(m_ppLostChildHold)Ɉړ
       * @param    index      ړq̔zvfԍ 
       */
      //------------------------------------------------------------------
      void CLostChildManager::HoldChild( u32 index )
      {
        // ړΏۂm
        CLostChild* pWork = m_ppLostChildField[index];

        // ŌɘAŌ
        pWork->Slave(m_pLastHold);
        m_pLastHold = pWork;

        // ړΏۈȍ~̕Ol
        for ( u32 i = index ; i < NUM_LOST_CHILD - m_NumHoldChild - 1; i++)
        {
          m_ppLostChildField[i] = m_ppLostChildField[i + 1];
        }

        m_ppLostChildHold[m_NumHoldChild] = pWork;
        m_NumHoldChild++;
      }

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG

// EOF


