

#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CLostChild.cpp
 * @brief  [VlC~jQ[]qNX
 |b|Bf̃\[XǗ͏wōsB
 * @author junya ikuta
 * @date   2012/05/23() 17:21
 */
///////////////////////////////////////////////////////////////////////////////////////

// sys

// appSys
#include "test_ikuta_game_Common.h"

// app
#include "test_ikuta_game_CLostChild.h"

// res
#include "resource/test_ikuta_game_resource_LostChild.h"

namespace test {
  namespace ikuta {
    namespace game {

      const f32 LOST_CHILD_HIT_SIZE(100.0f);
      const f32 LOST_CHILD_SLAVE_OFFSET_Z(400.0f);


      //------------------------------------------------------------------
      /**
       * @name      CLostChild[RXgN^]
       * @brief     ϐ̏s
       */
      //------------------------------------------------------------------
      CLostChild::CLostChild( void ) :
        m_State( STATE_NULL ),
        m_pTargetObject( NULL ),
        m_pRentalPtrSet( NULL ),
        m_pModel( NULL )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name      ~CLostChild[fXgN^]
       * @brief     Finalize()ĂяoB
       */
      //------------------------------------------------------------------
      CLostChild::~CLostChild( void )
      {
        Finalize();
      }

      //------------------------------------------------------------------
      /**
       * @name      Initialize
       * @brief      
       * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
       * @pram      rSetUp      [const,default]
       * @return    true : [hԂɓ
       */
      //------------------------------------------------------------------
      bool CLostChild::Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp)
      {
        // `FbN
        //   GFL_ASSERT
        //  rRentalPtr.

        // ܂؂蕨[
        m_pRentalPtrSet = GFL_NEW( rRentalPtr.pHeap->pHeap )RENTAL_PTR_SET;
        *m_pRentalPtrSet = rRentalPtr;

        m_Pos = rSetUp.pos;
        m_Rot.y = rSetUp.dir;

        // f̐
        m_pModel = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Model();

        gfl::grp::g3d::Model::Description desc;
        desc.animation_slot_num = 1;                               // Aj[VXbgKvmۂ

        m_pModel->Create( 
            m_pRentalPtrSet->pHeap->pHeapAllocator, 
            m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
            m_pRentalPtrSet->pModelRes, 
            0,
            &desc
            );

        m_pModel->SetModelLayerId( MODEL_LAYER_ID_LOST_CHILD );    // ɕ`
   //     m_pRentalPtrSet->pScene->AddSceneNode( m_pModel );


        m_State = STATE_UPDATE;
        m_HitRad = LOST_CHILD_HIT_SIZE;

        // Aj[V
        ChangeAnimation(LOST_CHILD_ANIMATION_WAIT, true, 0);

        return true;
      }

      //------------------------------------------------------------------
      /**
       * @name     Reset
       * @brief    p[^AInitializeɐ퓮AInitializȅԂɂȂ
       */
      //------------------------------------------------------------------
      void CLostChild::Reset( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name     Finalize
       * @brief    I
       */
      //------------------------------------------------------------------
      void CLostChild::Finalize( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name      Update
       * @brief     XV
       * @return    ݂̏
       */
      //------------------------------------------------------------------
      CLostChild::STATE CLostChild::Update( void )
      {
        switch( m_State )
        {
        case STATE_UPDATE:

          break;

        case STATE_SLAVE:
          {
            gfl::math::VEC3 pos;
            m_pTargetObject->GetPosition(&pos);

            m_Pos = pos;
            m_Pos.z += LOST_CHILD_SLAVE_OFFSET_Z;
          }

          break;
        }

        return m_State;
      }

      //------------------------------------------------------------------
      /**
       * @name      Draw
       * @brief     `揈Aʂfɔf
       */
      //------------------------------------------------------------------
      void CLostChild::Draw( void )
      {
        m_pModel->SetTranslate( m_Pos );
        m_pModel->SetRotateXYZ( m_Rot );
      }

      //------------------------------------------------------------------
      /**
       * @name      Slave
       * @brief     wIuWFNgɒǏ]
       * @param     IuWFNgւ̃|C^[const]
       */
      //------------------------------------------------------------------
      void CLostChild::Slave( const CObjectBase* pObj )
      {
        m_pTargetObject = pObj;
        m_State = STATE_SLAVE;
      }

      //------------------------------------------------------------------
      /**
       * @name      AddScene
       * @brief     V[Ɏgǉ
       */
      //------------------------------------------------------------------
      void CLostChild::AddScene(void)
      {
        m_pRentalPtrSet->pScene->AddSceneNode( m_pModel );
      }

      //------------------------------------------------------------------
      /**
       * @name      RemoveScene
       * @brief     V[玩g菜
       */
      //------------------------------------------------------------------
      void CLostChild::RemoveScene(void)
      {
        m_pRentalPtrSet->pScene->RemoveSceneNode( m_pModel );
      }

      // protected

      //------------------------------------------------------------------
      /**
       * @name      ChangeAnimation
       * @brief     Aj[V̕ύX
       * @param     index       Aj[Vԍ
       * @param     changeCnt   OAj[VƂ̕ԃt[[default]
       */
      //------------------------------------------------------------------
      void CLostChild::ChangeAnimation( u32 index, b32 loop, u32 changeCnt)
      {
        m_pModel->ChangeAnimation( 
            m_pRentalPtrSet->pHeap->pHeapAllocator, 
            m_pRentalPtrSet->ppAnimationArray[index], 
            changeCnt, 
            0 
            );

        m_pModel->SetAnimationFrame(0, 0);
        m_pModel->SetAnimationLoop(loop, 0);
      }


    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG

// EOF


