
#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CGameCamera.h
 * @brief  [VlC~jQ[]J
 vC[̃|C^ێAǏ]
 J̎̂3DUtilNXĂ܂ÃNXUtil̃JɃANZXĐs܂B
 * @author junya ikuta
 * @date  2012/05/25() 09:34 
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// appSys
#include "test_ikuta_game_CObjectBase.h"


namespace test {
  namespace ikuta {
    namespace game {

      class CGameCamera
      {
        public:

          enum STATE {
            STATE_NULL = 0,          // 
            STATE_SLAVE_PLAYER,      // vC[ɏ]
            STATE_ZOOM_OUT,          // Y[AEg
            STATE_ZOOM_OUT_RETURN,   // Y[AEg߂
            NUM_STATE
          };

          // e̎؂蕨
          struct RENTAL_PTR_SET{

            gfl::grp::g3d::Scene*         pScene;               // V[
            app::util::Heap*              pHeap;                // gpq[v        
            gfl::grp::g3d::StereoCamera*  pCamera;              // J
            CObjectBase*                  pTargetObject;        // Ǐ]IuWFNg(vC[)
            CTitleCamera*                 pTitleCamera;         // ^CgJAAj[V̍W擾

            RENTAL_PTR_SET() :
              pScene( NULL ),
              pHeap( NULL ),
              pCamera( NULL ),
              pTargetObject( NULL ),
              pTitleCamera( NULL )
            {
            }
          };


          // p\
          struct SETUP_PARAM{

            gfl::math::VEC3               pos;                  // ʒu
            f32                           dir;                  // 
            f32                           rotSpeed;             // ]x
            u32                           arcId;

            SETUP_PARAM() : 
              pos(0.0f, 0.0f, 0.0f), 
              dir(0.0f), 
              rotSpeed( 0.0f )
            {
            }

          };

          //------------------------------------------------------------------
          /**
           * @name     CGameCamera[RXgN^]
           * @brief    ϐ̏s
           */
          //------------------------------------------------------------------
          CGameCamera( void );

          //------------------------------------------------------------------
          /**
           * @name     ~CGameCamera[fXgN^]
           * @brief    FinalizeĂяo
           */
          //------------------------------------------------------------------
          virtual ~CGameCamera();

          //------------------------------------------------------------------
          /**
           * @name      Initialize
           * @brief     
           * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
           * @pram      rSetUp      [const,default]
           * @return    true : 
           */
          //------------------------------------------------------------------
          bool Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp);

          //------------------------------------------------------------------
          /**
           * @name     Finalize
           * @brief    I
           */
          //------------------------------------------------------------------
          void Finalize( void );

          //------------------------------------------------------------------
          /**
           * @name      Update
           * @brief     XV
           * @return    ݂̏
           */
          //------------------------------------------------------------------
          STATE Update( void );


          //------------------------------------------------------------------
          /**
           * @name      GetCameraPosition[const]
           * @brief     W̎擾
           */
          //------------------------------------------------------------------
          void GetCameraPosition( gfl::math::VEC3* pOutPos) const;
          //    const gfl::math::VEC3& GetCameraPosition( void ) const

        protected:

          //------------------------------------------------------------------
          /**
           * @name     Reset
           * @brief    ϐ̏sAI|C^͂̂܂
           */
          //------------------------------------------------------------------
          void Reset(void);

          // ʏϐ
          STATE                           m_State;              // ԕϐ

          RENTAL_PTR_SET*                 m_pRentalPtrSet;      // w̎؂蕨̕ۊ
          gfl::math::VEC3                 m_CameraOffset;       // Ǐ]IuWF̍WJʒu

      };

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG


// EOF
