
//=============================================================================
/**
 * @file   CameraInterpolate.h
 * @brief  Ԋ֐ENXwb_
 * @author rc N
 * @date   2012.05.31
 */
//=============================================================================

#ifndef __CAMERA_INTERPOLATE_H__
#define __CAMERA_INTERPOLATE_H__

namespace field
{
  //-----------------------------------------------------------------------------
  /**
   * @brief 䗦Ԓl擾
   *
   * @param src    n_
   * @param dest@ I_
   * @param fRatio 䗦
   *
   * @return Ԓl
   */
  //-----------------------------------------------------------------------------
  template<typename T> T GetRatioInterpolateValue(const T& src, const T& dest, const float fRatio)
  // { return (1.0f - fRatio)*src + fRatio*dest; }
  { return src + fRatio*(dest - src); }

  //-----------------------------------------------------------------------------
  /**
   * @brief 䗦Ԓl擾(0 <= fRatio <= 1͈̔͂ɃNbv)
   *
   * @param src    n_
   * @param dest@ I_
   * @param fRatio 䗦
   *
   * @return Ԓl
   */
  //-----------------------------------------------------------------------------
  template<typename T> T GetRatioZeroOneInterpolateValue(const T& src, const T& dest, const float fRatio)
  {
    if     ( fRatio <= 0.0f ) return src;
    else if( fRatio >= 1.0f ) return dest;
    else                      return GetRatioInterpolateValue(src, dest, fRatio);
  }

  //-----------------------------------------------------------------------------
  /**
   * @brief 䗦Ԓl擾
   *
   * @param base   _
   * @param range  ͈
   * @param fRatio 䗦
   *
   * @return Ԓl
   */
  //-----------------------------------------------------------------------------
  template<typename T> T GetRatioInterpolateValueByBaseAndRange(const T& base, const T& range, const float fRatio)
  { return base + (fRatio - 0.5f)*range; }

  //-----------------------------------------------------------------------------
  /**
   * @brief l擾
   *
   * @param value1 lP
   * @param value2 lQ
   *
   * @return l
   */
  //-----------------------------------------------------------------------------
  template<typename T> T GetCenterValue(const T& value1, const T& value2) { return 0.5f*(value1 + value2); }

  //-----------------------------------------------------------------------------
  /**
   * @brief Ԕ䗦l擾(Ԃl0`1)
   *
   * @param fValue      l
   * @param fZeroBorder 䗦OE
   * @param fOneBorder  䗦PE
   *
   * @return Ԕ䗦l
   */
  //-----------------------------------------------------------------------------
  extern float GetInterpolateRatioValue(const float fValue, const float fZeroBorder, const float fOneBorder);

  //-----------------------------------------------------------------------------
  /**
   * @brief Ԕ䗦l擾(Ԃl0`1̃NbvȂ)
   *
   * @param fValue      l
   * @param fZeroBorder 䗦OE
   * @param fOneBorder  䗦PE
   *
   * @return Ԕ䗦l
   */
  //-----------------------------------------------------------------------------
  inline float GetInterpolateRatioValueNoBorderClip(const float fValue, const float fZeroValue, const float fOneValue)
  { return (fValue - fZeroValue) / (fOneValue - fZeroValue); }

  extern const float INTERPOLATE_VEL_MAX_INFINITY;
  //-----------------------------------------------------------------------------
  /**
   * @brief ΂˕ԂɂԈړl擾
   *
   * @param1 fSpringCoe    ΂ˌW
   * @param2 fVelMax       ő呬x(INTERPOLATE_VEL_MAX_INFINITYݒ肷ƃ~bgȂ)
   * @param3 fSrcValue     ͒l
   * @param4 fDestValue    o͒l
   * @param5 fDiffTime     oߎ
   * @param6 bIsRadiInterp WA(])Ԃǂ
   *
   * @return Ԉړl
   */
  //-----------------------------------------------------------------------------
  extern float GetSpringInterpolateMove(const float fSpringCoe, const float fVelMax, const float fSrcValue, const float fDestValue, const float fDiffTime, const bool bIsRadiInterp = false);

  //-----------------------------------------------------------------------------
  /**
   * @brief ΂˕ԂɂԒl擾
   *
   * @param1 fSpringCoe    ΂ˌW
   * @param2 fVelMax       ő呬x(INTERPOLATE_VEL_MAX_INFINITYݒ肷ƃ~bgȂ)
   * @param3 fSrcValue     ͒l
   * @param4 fDestValue    o͒l
   * @param5 fDiffTime     oߎ
   * @param6 bIsRadiInterp WA(])Ԃǂ
   *
   * @return Ԓl
   */
  //-----------------------------------------------------------------------------
  extern float GetSpringInterpolateValue(const float fSpringCoe, const float fVelMax, const float fSrcValue, const float fDestValue, const float fDiffTime, const bool bIsRadiInterp = false);

} // namespace field

#endif // __CAMERA_INTERPOLATE_H__

/*  EOF  */





