
//=============================================================================
/**
 * @file   CameraInterpolate.cpp
 * @brief  Ԋ֐ENX
 * @author rc N
 * @date   2012.05.31
 */
//=============================================================================

#include "CameraInterpolate.h"

namespace field
{
  //-----------------------------------------------------------------------------
  // Ԕ䗦l擾(Ԃl0`1)
  //-----------------------------------------------------------------------------
  float GetInterpolateRatioValue(const float fValue, const float fZeroBorder, const float fOneBorder)
  {
#ifdef PM_DEBUG
    if( fZeroBorder > fOneBorder ) GFL_PRINT("닫E(%.2f)닫E(%.2f)̕l傫ł \n", fOneBorder, fZeroBorder);
#endif

    if     ( fValue <= fZeroBorder ) return 0.0f;
    else if( fValue >= fOneBorder  ) return 1.0f;
    else                             return GetInterpolateRatioValueNoBorderClip(fValue, fZeroBorder, fOneBorder);
  }

  const float INTERPOLATE_VEL_MAX_INFINITY = -1.0f;

  //-----------------------------------------------------------------------------
  // ΂˕ԂɂԈړl擾
  //-----------------------------------------------------------------------------
  float GetSpringInterpolateMove(const float fSpringCoe, const float fVelMax, const float fSrcValue, const float fDestValue, const float fDiffTime, const bool bIsRadiInterp)
  {
    float fDiffMove = 0.0f;
    if( bIsRadiInterp ) fDiffMove = CUtil::AddRadian(fDestValue, -fSrcValue);
    else                fDiffMove = fDestValue - fSrcValue;
    const float fDiffMoveAbs = gfl::math::FAbs(fDiffMove);

    float fMove = fSpringCoe*fDiffMove*fDiffTime;
    float fMoveAbs = gfl::math::FAbs(fMove);

    // ǂz`FbN
    if( fMoveAbs > fDiffMoveAbs )
    {
      if( fMove >= 0.0f ) fMove =  fDiffMoveAbs;
      else                fMove = -fDiffMoveAbs;
      fMoveAbs = fDiffMoveAbs;
    }

    // ő呬x~bg
    if( fVelMax > 0.0f )
    {
      const float fMoveMax = fVelMax*fDiffTime;
      if( fMoveAbs > fMoveMax )
      {
        if( fMove >= 0.0f ) fMove =  fMoveMax;
        else                fMove = -fMoveMax;
      }
    }

    return fMove;
  }

  //-----------------------------------------------------------------------------
  // ΂˕ԂɂԒl擾
  //-----------------------------------------------------------------------------
  float GetSpringInterpolateValue(const float fSpringCoe, const float fVelMax, const float fSrcValue, const float fDestValue, const float fDiffTime, const bool bIsRadiInterp)
  {
    return fSrcValue + GetSpringInterpolateMove(fSpringCoe, fVelMax, fSrcValue, fDestValue, fDiffTime, bIsRadiInterp);
  }

} // namespace field

/*  EOF  */





