
//=============================================================================
/**
 * @file   CameraDebugPrimitive.h
 * @brief  fobOv~eBu`T|[gNXwb_
 * @author rc N
 * @date   2012.05.30
 */
//=============================================================================

#ifndef __CAMERA_DEBUG_PRIMITIVE_H__
#define __CAMERA_DEBUG_PRIMITIVE_H__

namespace field
{
  //-----------------------------------------------------------------------------
  /**
   * @brief fobOv~eBu̕`T|[gNX
   */
  //-----------------------------------------------------------------------------
  class CDebugPrim
  {
#ifdef PM_DEBUG

  private:
    static gfl::grp::util::Vertex* m_ainVertexBuf; ///< C(mɂׂ͍|S)`悷邽߂̒_obt@
    static gfl::math::VEC3 m_inCamPosi; ///< Jʒu
    static gfl::math::VEC3 m_inCamDir;  ///< J̌

  public:
    static bool IsNeedInit() { return (m_ainVertexBuf == NULL); } ///< KvƂĂ邩mF
    static void Init();    ///< 
    static void Release(); ///< 
    static void Update(const gfl::grp::g3d::Camera& inCamera); ///< t[

    //-----------------------------------------------------------------------------
    /**
     * @brief `悷
     *
     * @param inSrcPosi  n_
     * @param inDestPosi I_
     * @param inColor    F
     */
    //-----------------------------------------------------------------------------
    static void DrawLine(const gfl::math::VEC3& inSrcPosi, const gfl::math::VEC3& inDestPosi, const gfl::math::VEC4& inColor);

    //-----------------------------------------------------------------------------
    /**
     * @brief ̌q`悷
     *
     * @param ainPosi  ëʒuz
     * @param nPosiNum ʒuz
     * @param inColor  F
     */
    //-----------------------------------------------------------------------------
    static void DrawLineList(const gfl::math::VEC3 ainPosi[], const int nPosiNum, const gfl::math::VEC4& inColor);

    //-----------------------------------------------------------------------------
    /**
     * @brief NULL`悷
     *
     * @param inPosi ʒu
     * @param fSize  傫
     * @param inColor F
     */
    //-----------------------------------------------------------------------------
	static void DrawNull(const gfl::math::VEC3& inPosi, const float fSize, const gfl::math::VEC4& inColor);

    //-----------------------------------------------------------------------------
    /**
     * @brief iq`悷
     *
     * @param nDivideX 
     * @param nDivideZ 
     * @param fLengthX 
     * @param fLengthZ 
     * @param inPosi   Sʒu
     * @param inColor  F
     */
    //-----------------------------------------------------------------------------
    static void DrawGrid(const int nDivideX, const int nDivideZ, const float fLengthX, const float fLengthZ, const gfl::math::VEC3& inPosi, const gfl::math::VEC4& inColor)
	{
      gfl::math::MTX34 mat; gfl::math::MTX34Translate(&mat, &inPosi);
      DrawGrid(nDivideX, nDivideZ, fLengthX, fLengthZ, mat, inColor);
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief iq`悷(])
     *
     * @param nDivideX   
     * @param nDivideZ   
     * @param fLengthX   
     * @param fLengthZ   
     * @param inWorldMat [hԕϊs
     * @param inColor    F
     */
    //-----------------------------------------------------------------------------
	static void DrawGrid(const int nDivideX, const int nDivideZ, const float fLengthX, const float fLengthZ, const gfl::math::MTX34& inWorldMat, const gfl::math::VEC4& inColor);

    //-----------------------------------------------------------------------------
    /**
     * @brief `悷
     *
     * @param inPosi   ʒu
     * @param inDirMat [hϊs
     * @param fLength  
     * @param inColor  F
     */
    //-----------------------------------------------------------------------------
	static void DrawArrow(const gfl::math::VEC3& inPosi, const gfl::math::MTX33& inDirMat, const float fLength, const gfl::math::VEC4& inColor);

    //-----------------------------------------------------------------------------
    /**
     * @brief `悷
     *
     * @param inPosi  ʒu
     * @param inVec   (K͕sv)
     * @param fLength 
     * @param inColor F
     */
    //-----------------------------------------------------------------------------
    static void DrawArrow(const gfl::math::VEC3& inPosi, const gfl::math::VEC3& inVec, const float fLength, const gfl::math::VEC4& inColor);

    //-----------------------------------------------------------------------------
    /**
     * @brief `悷(I_͔)
     *
     * @param inSrcPosi  n_
     * @param inDestPosi I_
     * @param inColor    F
     */
    //-----------------------------------------------------------------------------
	static void DrawArrow(const gfl::math::VEC3& inSrcPosi, const gfl::math::VEC3& inDestPosi, const gfl::math::VEC4& inColor);

    //-----------------------------------------------------------------------------
    /**
     * @brief Ԏ`悷
     *
     * @param inAxisX X
     * @param inAxisY Y
     * @param inAxisZ Z
     * @param inPosi  Sʒu
     * @param fLength ̒
     */
    //----------------------------------------------------------------------------- 
    static void DrawSpaceAxis(const gfl::math::VEC3& inAxisX, const gfl::math::VEC3& inAxisY, const gfl::math::VEC3& inAxisZ, const gfl::math::VEC3& inPosi, const float fLength);

    //-----------------------------------------------------------------------------
    /**
     * @brief }gNX33Ԏ`悷
     *
     * @param inMat   ̓}gNX
     * @param inPosi  sړʒu
     * @param fLength ̒
     */
    //----------------------------------------------------------------------------- 
    static void DrawSpaceAxisByMTX33(const gfl::math::MTX33& inMat, const gfl::math::VEC3& inPosi, const float fLength)
	{
      gfl::math::VEC3 inAxisX; gfl::math::MTX33GetAxisX(&inAxisX, inMat);
      gfl::math::VEC3 inAxisY; gfl::math::MTX33GetAxisY(&inAxisY, inMat);
      gfl::math::VEC3 inAxisZ; gfl::math::MTX33GetAxisZ(&inAxisZ, inMat);
      DrawSpaceAxis(inAxisX, inAxisY, inAxisZ, inPosi, fLength);
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief }gNX34Ԏ`悷
     *
     * @param inMat   ̓}gNX
     * @param fLength ̒
     */
    //----------------------------------------------------------------------------- 
	static void DrawSpaceAxisByMTX34(const gfl::math::MTX34& inMat34, const float fLength)
	{
      const gfl::math::MTX33 inMat33(inMat34);
      gfl::math::VEC3 inPosi; gfl::math::MTX34GetTranslate(&inPosi, inMat34);
      DrawSpaceAxisByMTX33(inMat33, inPosi, fLength);
    }

  private:
    static void  GetLineSideOffsetDirection(gfl::math::VEC3* pDir, const gfl::math::VEC3& inPosi, const gfl::math::VEC3& inLineVec);
    static float GetLineScale(const gfl::math::VEC3& inPosi);

#else

  public:
    static bool IsNeedInit() { return false; }
    static void Init() { ; }
    static void Release() { ; }
    static void Update(const gfl::grp::g3d::Camera& inCamera) { ; }

    static void DrawLine(const gfl::math::VEC3& inSrcPosi, const gfl::math::VEC3& inDestPosi, const gfl::math::VEC4& inColor) { ; }
    static void DrawLineList(const gfl::math::VEC3 ainPosi[], const int nPosiNum, const gfl::math::VEC4& inColor) { ; }
	static void DrawNull(const gfl::math::VEC3& inPosi, const float fSize, const gfl::math::VEC4& inColor) { ; }
    static void DrawGrid(const int nDivideX, const int nDivideZ, const float fLengthX, const float fLengthZ, const gfl::math::VEC3& inPosi, const gfl::math::VEC4& inColor) { ; }
	static void DrawGrid(const int nDivideX, const int nDivideZ, const float fLengthX, const float fLengthZ, const gfl::math::MTX34& inWorldMat, const gfl::math::VEC4& inColor) { ; }
	static void DrawArrow(const gfl::math::VEC3& inPosi, const gfl::math::MTX33& inDirMat, const float fLength, const gfl::math::VEC4& inColor) { ; }
    static void DrawArrow(const gfl::math::VEC3& inPosi, const gfl::math::VEC3& inVec, const float fLength, const gfl::math::VEC4& inColor) { ; }
	static void DrawArrow(const gfl::math::VEC3& inSrcPosi, const gfl::math::VEC3& inDestPosi, const gfl::math::VEC4& inColor) { ; }
    static void DrawSpaceAxis(const gfl::math::VEC3& inAxisX, const gfl::math::VEC3& inAxisY, const gfl::math::VEC3& inAxisZ, const gfl::math::VEC3& inPosi, const float fLength) { ; }
    static void DrawSpaceAxisByMTX33(const gfl::math::MTX33& inMat, const gfl::math::VEC3& inPosi, const float fLength) { ; }
	static void DrawSpaceAxisByMTX34(const gfl::math::MTX34& inMat34, const float fLength) { ; }

#endif
  };

} // namespace field

#endif // __CAMERA_DEBUG_PRIMITIVE_H__

/*  EOF  */



#if 0
	// Op``悷
	static void drawLineTriangle(const float fSize,const tiMatrix& inWorldMat,const tiVector& inColor);

	// ʂ`悷
	static void drawLinePlane(const tiVector& inPosi,const tiVector& inNormVec,const float fSize,const tiVector& inColor = tiVector::UNIT_SCALE);

	// ~`悷
	static void drawLineCircle(const float fRadius,const tiMatrix& inWorldMat,const tiVector& inColor,const int nTotalVertex = 10);

	// Œ蒸_Ő~`悷(WiiBio͖t[mۂƗ̂)
	static void drawLineCircleFixVertexNum(const float fRadius,const tiMatrix& inWorldMat,const tiVector& inColor);

	// 
	static void drawLineSphereFixVertexNum(const float fRadius,const tiVector& inPosi,const tiVector& inColor);

	// ȋ
	static void drawLineEllipticalSphereFixVertexNum(const tiVector& inRadius,const tiMatrix& inWorldMat,const tiVector& inColor);

	// ~(fBottomDist:inPosi~̒܂ł̋)
	static void drawLineCylinderFixVertexNum(const tiVector& inPosi,const tiVector& inUpVector,const float fBottomDist,const float fRadius,const float fLength,const tiVector& inColor);

	// ȉ~
	static void drawLineEllipticalCylinderFixVertexNum(const tiMatrix& inWorldMat,const float fBottomDist,const float fRadiusX,const float fRadiusZ,const float fLength,const tiVector& inColor);

	// `悷
	static void drawBox(const tiVector& inLenXYZ,const tiMatrix& inWorldMat,const tiVector& inColor,const tiVector& inLocalCenterPosi = tiVector::ZERO_POSITION);

private:
	static void drawLineCircleCommon(tiVector ainPosi[],const float fRadius,const tiMatrix& inWorldMat,const tiVector& inColor,const int nTotalVertex);
#endif





