
//=============================================================================
/**
 * @file   CameraDebugPrimitive.cpp
 * @brief  fobOv~eBu`T|[gNX
 * @author rc N
 * @date   2012.05.30
 */
//=============================================================================

#ifdef PM_DEBUG

#include "CameraDebugPrimitive.h"
#include "CameraInterpolate.h"

namespace field
{
  gfl::grp::util::Vertex* CDebugPrim::m_ainVertexBuf = NULL;
  gfl::math::VEC3         CDebugPrim::m_inCamPosi    = gfl::math::VEC3_ZERO;
  gfl::math::VEC3         CDebugPrim::m_inCamDir     = gfl::math::VEC3_UNIT_Z;

  //-----------------------------------------------------------------------------
  // 
  //-----------------------------------------------------------------------------
  void CDebugPrim::Init()
  {
    GFL_ASSERT(m_ainVertexBuf == NULL);
    m_ainVertexBuf = gfl::grp::util::DrawUtil::CreateVertexArray(4);
  }

  //-----------------------------------------------------------------------------
  // 
  //-----------------------------------------------------------------------------
  void CDebugPrim::Release()
  {
    if( m_ainVertexBuf )
      gfl::grp::util::DrawUtil::DeleteVertexArray(m_ainVertexBuf);
  }

  //-----------------------------------------------------------------------------
  // t[
  //-----------------------------------------------------------------------------
  void CDebugPrim::Update(const gfl::grp::g3d::Camera& inCamera)
  {
    gfl::math::VEC3 inLookAtPosi;
    const_cast<gfl::grp::g3d::Camera* >(&inCamera)->GetCameraAndTargetPosition(m_inCamPosi, inLookAtPosi);
    m_inCamDir = inLookAtPosi - m_inCamPosi; gfl::math::VEC3Normalize(&m_inCamDir, &m_inCamDir);

    gfl::math::MTX34 inViewMat;
    gfl::math::MTX44 inProjMat;
    inCamera.GetViewMatrix(&inViewMat);
    inCamera.GetProjectionMatrix(&inProjMat);
    gfl::math::MTX44 mat(gfl::math::MTX44_IDENTITY); // 3ds̓XN[̉YŏcXł邽ߒK킹}gNX쐬EZ
    mat.m[0][0] = mat.m[1][1] = 0.0f;
    mat.m[1][0] = -1.0f;
    mat.m[0][1] =  1.0f;
    MTX44Mult(&inProjMat, &mat, &inProjMat);
    gfl::grp::util::DrawUtil::SetViewMatrix(gfl::math::MTX44(inViewMat));
    gfl::grp::util::DrawUtil::SetProjectionMatrix(inProjMat);

    gfl::grp::util::DrawUtil::SetModelMatrix(gfl::math::MTX44_IDENTITY);
    gfl::grp::util::DrawUtil::MaterialInfo inMaterial;
    inMaterial.m_ShadingType = gfl::grp::util::DrawUtil::MaterialInfo::COLOR_SHADER;
    gfl::grp::util::DrawUtil::SetMaterial(inMaterial);
  }

  //-----------------------------------------------------------------------------
  // `悷
  //-----------------------------------------------------------------------------
  void CDebugPrim::DrawLine(const gfl::math::VEC3& inSrcPosi, const gfl::math::VEC3& inDestPosi, const gfl::math::VEC4& inColor)
  {
    const gfl::math::VEC3 inLineVec = inDestPosi - inSrcPosi;
#if 0
    gfl::math::VEC3 inOfstDir; gfl::math::VEC3Cross(&inOfstDir, &m_inCamDir, &inLineVec);
    if( ikeda::CUtil::CheckAndGetNormalizeVector(&inOfstDir, NULL, inOfstDir) == false ) inOfstDir = BM_VEC3_ZERO;

    const gfl::math::VEC3 inSrcOfst  = inOfstDir*GetLineScale(inSrcPosi);
    const gfl::math::VEC3 inDestOfst = inOfstDir*GetLineScale(inDestPosi);
#else
    gfl::math::VEC3 inSrcOfstDir;  GetLineSideOffsetDirection(&inSrcOfstDir,  inSrcPosi,  inLineVec);
    gfl::math::VEC3 inDestOfstDir; GetLineSideOffsetDirection(&inDestOfstDir, inDestPosi, inLineVec);

    const gfl::math::VEC3 inSrcOfst  = inSrcOfstDir *GetLineScale(inSrcPosi);
    const gfl::math::VEC3 inDestOfst = inDestOfstDir*GetLineScale(inDestPosi);
#endif

    m_ainVertexBuf[0].m_Position = inSrcPosi  - inSrcOfst;
    m_ainVertexBuf[1].m_Position = inSrcPosi  + inSrcOfst;
    m_ainVertexBuf[2].m_Position = inDestPosi - inDestOfst;
    m_ainVertexBuf[3].m_Position = inDestPosi + inDestOfst;
    m_ainVertexBuf[0].m_Color = m_ainVertexBuf[1].m_Color = m_ainVertexBuf[2].m_Color = m_ainVertexBuf[3].m_Color = inColor;

    gfl::grp::util::DrawUtil::DrawVertexStrip(m_ainVertexBuf, 4);
  }

  void CDebugPrim::GetLineSideOffsetDirection(gfl::math::VEC3* pDir, const gfl::math::VEC3& inPosi, const gfl::math::VEC3& inLineVec)
  {
    const gfl::math::VEC3 inTempVec = inPosi - m_inCamPosi;
    gfl::math::VEC3Cross(pDir, &inTempVec, &inLineVec);
    if( CUtil::CheckAndGetNormalizeVector(pDir, NULL, *pDir) == false ) (*pDir) = gfl::math::VEC3_ZERO;
  }

  float CDebugPrim::GetLineScale(const gfl::math::VEC3& inPosi)
  {
    float fDepth = CUtil::GetAxisLength(inPosi - m_inCamPosi, m_inCamDir); CUtil::ZeroClip(&fDepth);
    return 0.01f + fDepth*0.0015f;
  }

  //-----------------------------------------------------------------------------
  // ̌q`悷
  //-----------------------------------------------------------------------------
  void CDebugPrim::DrawLineList(const gfl::math::VEC3 ainPosi[], const int nPosiNum, const gfl::math::VEC4& inColor)
  {
    // _ߖ̂߂ɃgCAOXgbvňxɏƂƃCcł܂̂ň{{
	for( int i = 0; i < nPosiNum-1; i++ )
      DrawLine(ainPosi[i], ainPosi[i+1], inColor);
  }

  //-----------------------------------------------------------------------------
  // NULL`悷
  //-----------------------------------------------------------------------------
  void CDebugPrim::DrawNull(const gfl::math::VEC3& inPosi, const float fSize, const gfl::math::VEC4& inColor)
  {
    const float fHalfSize = 0.5f*fSize;
    DrawLine(gfl::math::VEC3(inPosi.x+fHalfSize, inPosi.y, inPosi.z), gfl::math::VEC3(inPosi.x-fHalfSize, inPosi.y, inPosi.z), inColor);
    DrawLine(gfl::math::VEC3(inPosi.x, inPosi.y+fHalfSize, inPosi.z), gfl::math::VEC3(inPosi.x, inPosi.y-fHalfSize, inPosi.z), inColor);
    DrawLine(gfl::math::VEC3(inPosi.x, inPosi.y, inPosi.z+fHalfSize), gfl::math::VEC3(inPosi.x, inPosi.y, inPosi.z-fHalfSize), inColor);
  }

  //-----------------------------------------------------------------------------
  // iq`悷
  //-----------------------------------------------------------------------------
  void CDebugPrim::DrawGrid(const int nDivideX, const int nDivideZ, const float fLengthX, const float fLengthZ, const gfl::math::MTX34& inWorldMat, const gfl::math::VEC4& inColor)
  {
    const gfl::math::VEC3 inScale(fLengthX, 1.0f, fLengthZ);
    gfl::math::VEC3 inPosi; gfl::math::MTX34GetTranslate(&inPosi, inWorldMat);
    gfl::math::MTX33 inScaleMat; gfl::math::MTX33Scale(&inScaleMat, &inScale);
    gfl::math::MTX33 inSRMat, inTempMat(inWorldMat); gfl::math::MTX33MultLimit(&inSRMat, &inTempMat, &inScaleMat);
    gfl::math::MTX34 inTransMat; gfl::math::MTX34SetMTX33VEC3(&inTransMat, inSRMat, inPosi);

    const float fOfstX = 1.0f/nDivideX;
    for( int i = 0; i <= nDivideX; i++ )
	{
		const float fX = -0.5f + i*fOfstX;
        gfl::math::VEC3 inSrcPosi (fX, 0.0f, -0.5f); gfl::math::VEC3Transform(&inSrcPosi,  &inTransMat, &inSrcPosi);
        gfl::math::VEC3 inDestPosi(fX, 0.0f,  0.5f); gfl::math::VEC3Transform(&inDestPosi, &inTransMat, &inDestPosi);
        DrawLine(inSrcPosi, inDestPosi, inColor);
	}

    const float fOfstZ = 1.0f/nDivideZ;
	for( int i = 0; i <= nDivideZ; i++ )
	{
		const float fZ = -0.5f + i*fOfstZ;
        gfl::math::VEC3 inSrcPosi (-0.5f, 0.0f, fZ); gfl::math::VEC3Transform(&inSrcPosi,  &inTransMat, &inSrcPosi);
        gfl::math::VEC3 inDestPosi( 0.5f, 0.0f, fZ); gfl::math::VEC3Transform(&inDestPosi, &inTransMat, &inDestPosi);
        DrawLine(inSrcPosi, inDestPosi, inColor);
    }
  }

  //-----------------------------------------------------------------------------
  // `悷P
  //-----------------------------------------------------------------------------
  void CDebugPrim::DrawArrow(const gfl::math::VEC3& inPosi, const gfl::math::MTX33& inDirMat, const float fLength, const gfl::math::VEC4& inColor)
  {
    // Pʖ]ւƕϊ}gNX𐶐
    const gfl::math::VEC3 inScale(fLength, fLength, fLength);
    gfl::math::MTX33 inSRMat; gfl::math::MTX33Scale(&inSRMat, &inScale);
    gfl::math::MTX33 inTempMat(inSRMat); gfl::math::MTX33MultLimit(&inSRMat, &inDirMat, &inTempMat);
    gfl::math::MTX34 inTransMat; gfl::math::MTX34SetMTX33VEC3(&inTransMat, inSRMat, inPosi);

    const float HEAD_LEN = 0.2f; // K
    const gfl::math::VEC3 ainPosi[] = {
      gfl::math::VEC3(     0.0f,      0.0f, 0.0f),
      gfl::math::VEC3(     0.0f,      0.0f, 1.0f),
      gfl::math::VEC3( HEAD_LEN,      0.0f, 1.0f-HEAD_LEN),
      gfl::math::VEC3(-HEAD_LEN,      0.0f, 1.0f-HEAD_LEN),
      gfl::math::VEC3(     0.0f,      0.0f, 1.0f),
      gfl::math::VEC3(     0.0f,  HEAD_LEN, 1.0f-HEAD_LEN),
      gfl::math::VEC3(     0.0f, -HEAD_LEN, 1.0f-HEAD_LEN),
      gfl::math::VEC3(     0.0f,      0.0f, 1.0f)
    };

    gfl::math::VEC3 inSrcPosi; gfl::math::VEC3Transform(&inSrcPosi, &inTransMat, &ainPosi[0]);
    for( int i = 0; i < GET_ARRAY_NUMBER(ainPosi)-1; i++ )
    {
      gfl::math::VEC3 inDestPosi; gfl::math::VEC3Transform(&inDestPosi, &inTransMat, &ainPosi[i+1]);
      DrawLine(inSrcPosi, inDestPosi, inColor);
      inSrcPosi = inDestPosi;
    }
  }

  //-----------------------------------------------------------------------------
  // `悷Q
  //-----------------------------------------------------------------------------
  void CDebugPrim::DrawArrow(const gfl::math::VEC3& inPosi, const gfl::math::VEC3& inVec, const float fLength, const gfl::math::VEC4& inColor)
  {
    gfl::math::VEC3 inDir;
    if( CUtil::CheckAndGetNormalizeVector(&inDir, NULL, inVec) == true )
    {
      const float fRatio = GetInterpolateRatioValue(gfl::math::FAbs(inDir.y), 0.5f, 1.0f);
      gfl::math::VEC3 inUpDir = gfl::math::VEC3_UNIT_Y;
      if     ( fRatio >= 1.0f ) inUpDir = gfl::math::VEC3_UNIT_X;
      else if( fRatio >  0.0f )
      {
        inUpDir = gfl::math::VEC3(fRatio, 1.0f-fRatio, 0.0f);
        gfl::math::VEC3Normalize(&inUpDir, &inUpDir);
      }

      gfl::math::MTX33 inDirMat;
      CSpace::CreateMTX33ByFrontUpDirection(&inDirMat, inDir, inUpDir);
      DrawArrow(inPosi, inDirMat, fLength, inColor);
	}
  }

  //-----------------------------------------------------------------------------
  // `悷R
  //-----------------------------------------------------------------------------
  void CDebugPrim::DrawArrow(const gfl::math::VEC3& inSrcPosi, const gfl::math::VEC3& inDestPosi, const gfl::math::VEC4& inColor)
  {
    float fLength;
	gfl::math::VEC3 inDir;
	if( CUtil::CheckAndGetNormalizeVector(&inDir, &fLength, inDestPosi-inSrcPosi) == true )
      DrawArrow(inSrcPosi, inDir, fLength, inColor);
  }

  //-----------------------------------------------------------------------------
  // Ԏ`悷
  //-----------------------------------------------------------------------------
  void CDebugPrim::DrawSpaceAxis(const gfl::math::VEC3& inAxisX, const gfl::math::VEC3& inAxisY, const gfl::math::VEC3& inAxisZ, const gfl::math::VEC3& inPosi, const float fLength)
  {
	DrawArrow(inPosi, inAxisX, fLength, VEC4_COLOR_RED);
	DrawArrow(inPosi, inAxisY, fLength, VEC4_COLOR_GREEN);
	DrawArrow(inPosi, inAxisZ, fLength, VEC4_COLOR_BLUE);
  }

} // namespace field

#endif // PM_DEBUG

/*  EOF  */



#if 0

//-----------------------------------------------------------------------------
// Op``悷
//-----------------------------------------------------------------------------
void tiUtilDebug::drawLineTriangle(const float fSize,const tiMatrix& inWorldMat,const tiVector& inColor)
{
	tiVector ainPosi[4] = { tiVector(0.0f,0.5f,0.0f,1.0f) , tiVector(-0.5f,-0.5f,0.0f,1.0f) , tiVector(0.5f,-0.5f,0.0f,1.0f) };
	const tiMatrix inTransMat = tiMatrix().makeScale(fSize)*inWorldMat;
	for(int i = 0;i < 3;i++)
	{
		ainPosi[i].y += 0.5f/3.0f;
		ainPosi[i]   *= inTransMat;
	}

	ainPosi[3] = ainPosi[0];
	drawLineList(ainPosi,4,inColor);
}

//-----------------------------------------------------------------------------
// ʂ`悷
//-----------------------------------------------------------------------------
void tiUtilDebug::drawLinePlane(const tiVector& inPosi,const tiVector& inNormVec,const float fSize,const tiVector& inColor)
{
	tiVector inNormDir;
	if(tiUtil::checkAndGetNormalizeVector(&inNormDir,NULL,inNormVec) == TRUE)
	{
		tiVector ainPosi[] = { tiVector(-0.5f,0.0f,-0.5f,1.0f),tiVector(-0.5f,0.0f,0.5f,1.0f),tiVector(0.5f,0.0f,0.5f,1.0f),tiVector(-0.5f,0.0f,-0.5f,1.0f),tiVector(0.5f,0.0f,-0.5f,1.0f),tiVector(0.5f,0.0f,0.5f,1.0f) };
		const int TOTAL_POSI = sizeof(ainPosi)/sizeof(tiVector);

		tiMatrix inTransMat = tiMatrix().makeScale(fSize)*tiVector::UNIT_Y.getReachRotMatrix(inNormDir); inTransMat.setTransVector3(inPosi);
		for(int i = 0;i < TOTAL_POSI;i++) ainPosi[i] *= inTransMat;

		drawLineList(ainPosi,TOTAL_POSI,inColor);
		drawArrow(inPosi,inNormDir,fSize,inColor);
	}
}

//-----------------------------------------------------------------------------
// ~`悷
//-----------------------------------------------------------------------------
void tiUtilDebug::drawLineCircle(const float fRadius,const tiMatrix& inWorldMat,const tiVector& inColor,const int nTotalVertex)
{
	CStlVector<tiVector> ainPosi(nTotalVertex);
	drawLineCircleCommon(&ainPosi[0],fRadius,inWorldMat,inColor,nTotalVertex);
}

//-----------------------------------------------------------------------------
// Œ蒸_Ő~`悷
//-----------------------------------------------------------------------------
void tiUtilDebug::drawLineCircleFixVertexNum(const float fRadius,const tiMatrix& inWorldMat,const tiVector& inColor)
{
	const int TOTAL_VERTEX = 10;
	tiVector ainPosi[TOTAL_VERTEX];
	drawLineCircleCommon(ainPosi,fRadius,inWorldMat,inColor,TOTAL_VERTEX);
}

//-----------------------------------------------------------------------------
// ~`悷̋ʏ
//-----------------------------------------------------------------------------
void tiUtilDebug::drawLineCircleCommon(tiVector ainPosi[],const float fRadius,const tiMatrix& inWorldMat,const tiVector& inColor,const int nTotalVertex)
{
	const float OFST_RADI = TIL_PIx2/static_cast<float>(nTotalVertex-1);
	const tiMatrix inTransMat = tiMatrix().makeScale(fRadius)*inWorldMat;

	for(int i = 0;i < nTotalVertex-1;i++)
		ainPosi[i] = tiVector(1.0f,0.0f,0.0f,1.0f)*tiMatrix().makeRotateZ(i*OFST_RADI)*inTransMat;

	ainPosi[nTotalVertex-1] = ainPosi[0];
	drawLineList(ainPosi,nTotalVertex,inColor);
}

#define TOTAL_LINE_CIRCLE_SPHERE (7)
#define OFST_RADI_SPHERE (TIL_PI/TOTAL_LINE_CIRCLE_SPHERE)

//-----------------------------------------------------------------------------
// 
//-----------------------------------------------------------------------------
void tiUtilDebug::drawLineSphereFixVertexNum(const float fRadius,const tiVector& inPosi,const tiVector& inColor)
{
	for(int i = 0;i < TOTAL_LINE_CIRCLE_SPHERE;i++)
	{
		const tiMatrix inTransMat = tiMatrix().makeRotateY(i*OFST_RADI_SPHERE,inPosi);
		drawLineCircleFixVertexNum(fRadius,inTransMat,inColor);
	}
}

//-----------------------------------------------------------------------------
// ȋ
//-----------------------------------------------------------------------------
void tiUtilDebug::drawLineEllipticalSphereFixVertexNum(const tiVector& inRadius,const tiMatrix& inWorldMat,const tiVector& inColor)
{
	const tiMatrix inScaleWorldMat = tiMatrix().makeScale(inRadius)*inWorldMat;
	for(int i = 0;i < TOTAL_LINE_CIRCLE_SPHERE;i++)
	{
		const tiMatrix inTransMat = tiMatrix().makeRotateY(i*OFST_RADI_SPHERE)*inScaleWorldMat;
		drawLineCircleFixVertexNum(1.0f,inTransMat,inColor);
	}
}

//-----------------------------------------------------------------------------
// ~
//-----------------------------------------------------------------------------
void tiUtilDebug::drawLineCylinderFixVertexNum(const tiVector& inPosi,const tiVector& inUpVector,const float fBottomDist,const float fRadius,const float fLength,const tiVector& inColor)
{
	tiMatrix inWorldMat = tiVector::UNIT_Y.getReachRotMatrix(inUpVector.getNormalize3()); inWorldMat.setTransVector3(inPosi);
	drawLineEllipticalCylinderFixVertexNum(inWorldMat,fBottomDist,fRadius,fRadius,fLength,inColor);
}

//-----------------------------------------------------------------------------
// ȉ~
//-----------------------------------------------------------------------------
void tiUtilDebug::drawLineEllipticalCylinderFixVertexNum(const tiMatrix& inWorldMat,const float fBottomDist,const float fRadiusX,const float fRadiusZ,const float fLength,const tiVector& inColor)
{
	const tiMatrix inRotMat90      = tiMatrix().makeRotateX(TIL_PI_2);
	const tiVector inUpDir         = inWorldMat.getUpVector();
	const tiVector inBottomPosi    = inWorldMat.getTransVector() - fBottomDist*inUpDir;
	const tiMatrix inScaleWorldMat = tiMatrix(tiMatrix().makeScale(fRadiusX,1.0f,fRadiusZ)*inWorldMat).setTransVector3(inBottomPosi);

	//drawArrow(inBottomPosi,inUpDir,fLength,inColor);

	const int TOTAL_LINE_CIRCLE = 10;
	const float fYOfst = fLength/(TOTAL_LINE_CIRCLE-1);
	for(int i = 0;i < TOTAL_LINE_CIRCLE;i++)
	{
		const tiMatrix inTransMat = tiMatrix(inRotMat90).setTransVector3(tiVector(0.0f,fYOfst*i,0.0f))*inScaleWorldMat;
		drawLineCircleFixVertexNum(1.0f,inTransMat,inColor);
	}
}

//-----------------------------------------------------------------------------
// `悷
//-----------------------------------------------------------------------------
void tiUtilDebug::drawBox(const tiVector& inLenXYZ,const tiMatrix& inWorldMat,const tiVector& inColor,const tiVector& inLocalCenterPosi)
{
	const tiMatrix inTransMat = tiMatrix().makeScale(inLenXYZ).setTransVector3(inLocalCenterPosi)*inWorldMat;

	// ㉺`
	tiVector ainTopBottom[] = { tiVector(-0.5f, 0.5f,-0.5f,1.0f) , tiVector(0.5f, 0.5f,-0.5f,1.0f) , tiVector(0.5f, 0.5f,0.5f,1.0f) , tiVector(-0.5f, 0.5f,0.5f,1.0f) , tiVector(-0.5f, 0.5f,-0.5f,1.0f) , 
	                            tiVector(-0.5f,-0.5f,-0.5f,1.0f) , tiVector(0.5f,-0.5f,-0.5f,1.0f) , tiVector(0.5f,-0.5f,0.5f,1.0f) , tiVector(-0.5f,-0.5f,0.5f,1.0f) , tiVector(-0.5f,-0.5f,-0.5f,1.0f) };
	const int nTotalTopBottom = sizeof(ainTopBottom)/sizeof(tiVector);

	for(int i = 0;i < nTotalTopBottom;i++) ainTopBottom[i] = ainTopBottom[i]*inTransMat;
	drawLineList(ainTopBottom,nTotalTopBottom,inColor);

	// `
	tiVector ainSide[] = { tiVector(-0.5f,0.5f,-0.5f,1.0f) , tiVector( 0.5f,-0.5f,-0.5f,1.0f) , tiVector( 0.5f,0.5f,-0.5f,1.0f) , tiVector( 0.5f,-0.5f, 0.5f,1.0f) , 
		                   tiVector( 0.5f,0.5f, 0.5f,1.0f) , tiVector(-0.5f,-0.5f, 0.5f,1.0f) , tiVector(-0.5f,0.5f, 0.5f,1.0f) , tiVector(-0.5f,-0.5f,-0.5f,1.0f) };
	const int nTotalSide = sizeof(ainSide)/sizeof(tiVector);

	for(int i = 0;i < nTotalSide;i++) ainSide[i] = ainSide[i]*inTransMat;
	drawLineList(ainSide,nTotalSide,inColor);
}

#endif





