
//=============================================================================
/**
 * @file   CameraBehind.cpp
 * @brief  rnChJNX
 * @author rc N
 * @date   2012.05.31
 */
//=============================================================================

#include "CameraBehind.h"
#include "CameraDebugPrimitive.h"

namespace field
{
  //-----------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------
  CCameraBehind::CCameraBehind() :
  m_bIsAct(false)
  {
  }

  //-----------------------------------------------------------------------------
  // KvƂĂ邩mF
  //-----------------------------------------------------------------------------
  bool CCameraBehind::IsNeedInit() const { return CDebugPrim::IsNeedInit(); }

  //-----------------------------------------------------------------------------
  // 
  //-----------------------------------------------------------------------------
  void CCameraBehind::Init()
  {
    CDebugPrim::Init();
  }

  //-----------------------------------------------------------------------------
  // 
  //-----------------------------------------------------------------------------
  void CCameraBehind::Release()
  {
    CDebugPrim::Release();
  }

  //-----------------------------------------------------------------------------
  // rnChJJn
  //-----------------------------------------------------------------------------
  void CCameraBehind::Begin()
  {
    m_bIsAct = true;
  }

  //-----------------------------------------------------------------------------
  // fobO`悷
  //-----------------------------------------------------------------------------
  void CCameraBehind::DrawDebug(gfl::grp::GraphicsSystem* pGraphicsSystem, const gfl::grp::g3d::Camera& inCamera)
  {
    if( m_bIsAct == true )
    {
      gfl::grp::RenderTarget* pUpperBuf = pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER);
      pGraphicsSystem->BindCurrentCommandList(pUpperBuf);
      gfl::grp::util::DrawUtil::BeginRender(pUpperBuf);

      CDebugPrim::Update(inCamera);

      gfl::grp::util::DrawUtil::EndRender();
     }
  }

} // namespace field

/*  EOF  */





