//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		EventBattleReturn.cpp
 *	@brief  ogĂяo
 *	@author	tomoya takahshi
 *	@date		2011.06.06
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <pmlib.h>

#include "EventBattleReturn.h"

#include "system/gfl_use.h"
#include "sound/sound.h"
#include "gamesystem/GameManager.h"

#include "field/encount/EncountPokeSet.h"
#include "trainer/trid_def.h"

#include "EventAppCall.h"
#include "EventFieldMapControl.h"
#include "EventProcessCall.h"
#include "EventEncountEffect.h"
#include "EventGameOver.h"
#include "trainer/tr_tool.h"

namespace field
{


  //--------------------------------------------------------------
  /**
   * @brief   Cxg𓮂Ă悢ǂ̔֐ z֐
   * @param   p_gman       Q[}l[W[NX
   * @retval  true  NĂ悢
   * @retval  false NȂ
   */
  //--------------------------------------------------------------

  bool EventBattleReturn::BootChk( gamesystem::GameManager* p_gman )
  {
    return true;
  }

  //--------------------------------------------------------------
  /**
   * @brief   bootchktruȅꍇɂĂяo鏉֐ z֐
   * @param   p_gman       Q[}l[W[NX
   */
  //--------------------------------------------------------------

  void EventBattleReturn::InitFunc( gamesystem::GameManager* /*p_gman*/ )
  {
    GFL_PRINT("EventBattleReturn::InitFunc\n");
  }

  //--------------------------------------------------------------
  /**
   * @brief   Ăяo֐ z֐
   * @param   p_gman       Q[}l[W[NX
   * @return  GMEVENT_RESULT  Cxg֐̖߂l
   */
  //--------------------------------------------------------------

  gamesystem::GMEVENT_RESULT EventBattleReturn::MainFunc( gamesystem::GameManager* p_gman )
  {
    gamesystem::GameData* p_gdata = p_gman->GetGameData( );

    GFL_PRINT("EventBattleReturn::MainFunc\n");
    switch ( m_Seq )
    {
    case SEQ_INIT: // ߂l`FbN
      {
        // xAbv`FbN
        // p[^߂̐i`FbNɎgp
        {
          const pml::PokeParty* old_party = p_gdata->GetPlayerParty();
          const pml::PokeParty* new_party = m_cpParam->party[ BTL_CLIENT_PLAYER ];
          u32 member_count = new_party->GetMemberCount();
          GFL_ASSERT( member_count == old_party->GetMemberCount() );
          for( u32 i=0; i<member_count; i++ )
          {
            u32 old_level = old_party->GetMemberPointerConst(i)->GetLevel();
            u32 new_level = new_party->GetMemberPointerConst(i)->GetLevel();
            m_levelup[i] = ( old_level < new_level );
          }
        }


        // ogp[^̏߂B
        if ( ( m_cpParam->competitor == BTL_COMPETITOR_WILD ) ||
            ( m_cpParam->competitor == BTL_COMPETITOR_TRAINER ) )
        {
          // |Pparty߂
          p_gdata->GetPlayerParty( )->CopyFrom( *m_cpParam->party[BTL_CLIENT_PLAYER] );
        }

        // |PX``FbN
        // @todo  

        // ̂Ђ낢܂݂`FbNî݁j
        // @todo  
        // ~mb`tH`FW`FbNî݁j
        // u񂩂ӂṽ`FbN

        // ogŎ擾ǉ
        for( u32 i=0; i<m_cpParam->bonusItemCount; i++ )
        {
          if( m_cpParam->bonusItem[i] != ITEM_DUMMY_DATA ) {
            gfl::heap::HeapBase* heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_EVENT );
            gamesystem::GameData* game_data = p_gman->GetGameData( );
            savedata::MYITEM* my_item = game_data->GetMyItem();
            my_item->Add( m_cpParam->bonusItem[i], 1, heap );
          }
        }

        // ogŎ擾ǉ
        if( 0 < m_cpParam->getMoney ) 
        {
          gamesystem::GameData* game_data = p_gman->GetGameData( );
          savedata::Misc* misc = game_data->GetMisc();
          misc->AddGold( m_cpParam->getMoney );
        }

        // |P܂H
        if ( m_cpParam->result != BTL_RESULT_CAPTURE )
        {
          //߂܂ĂȂΐi`FbN
          m_Seq = SEQ_EVOLVE_CHECK;
        }
        else
        {
          gfl::heap::HeapBase* p_event_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_EVENT );

          //@todo 莝t̂Ƃ̃{bNXւ̓]
          //@todo g[i[̔f
          //@todo o^ʌĂяo
          p_gdata->GetPlayerParty( )->AddMember( *m_cpParam->party[BTL_CLIENT_ENEMY1]->GetMemberPointer( m_cpParam->capturedPokeIdx ) );

          m_pStrInputPoke = p_gdata->GetPlayerParty( )->GetMemberPointer( p_gdata->GetPlayerParty( )->GetMemberCount( ) - 1 );
          m_StrInputParam.type = app::strinput::TYPE_POKEMON_NAME;
          m_StrInputParam.param = m_pStrInputPoke->GetMonsNo( );
          m_StrInputParam.strBuf = GFL_NEW_LOW( p_event_heap ) gfl::str::StrBuf( pml::MONS_NAME_LENGTH, p_event_heap );
          m_StrInputParam.changeFlag = false;

          m_pStrInputPoke->GetNickName( m_StrInputParam.strBuf );

          // O͂
          m_Seq = SEQ_NAMEIN;
        }
      }
      break;

    case SEQ_NAMEIN: // O
      {
        EventAppCall* event = GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventAppCall > ( p_gman->GetGameEventManager( ) );
        event->SetCallTargetApplicationNotFieldControl( EventAppCall::CALL_TARGET_STRINPUT, &m_StrInputParam );

        m_Seq = SEQ_NAMEIN_RET;
      }
      break;

    case SEQ_NAMEIN_RET: // O
      {
        m_pStrInputPoke->SetNickName( m_StrInputParam.strBuf );
        GFL_DELETE m_StrInputParam.strBuf;
        m_StrInputParam.strBuf = NULL;
        m_Seq = SEQ_EVOLVE_CHECK;
      }
      break;

    case SEQ_EVOLVE_CHECK: // i`FbN
      m_PokeCount = 0;
      m_Seq = SEQ_EVOLVE_LOOP;

      //@ogW[Oœǂݍ
      {
        gfl::ro::RoManager *roMgr = GFL_SINGLETON_INSTANCE( gfl::ro::RoManager );
        m_BattleModule = roMgr->LoadModule("rom:/DllBattle.cro");
        roMgr->StartModule(m_BattleModule);
        m_ShinkaModule = roMgr->LoadModule("rom:/DllShinkaDemo.cro");
        roMgr->StartModule(m_ShinkaModule);
      }

      /* FALL THROUGH */

    case SEQ_EVOLVE_LOOP:
      {
        pml::PokeParty* party = p_gdata->GetPlayerParty();
        u32 member_count = party->GetMemberCount();
        for( ; m_PokeCount < member_count; m_PokeCount ++ )
        {
          if( m_levelup[m_PokeCount] )
          {
            MonsNo next_monsno = MONSNO_NULL;
            pml::pokepara::PokemonParam* poke = party->GetMemberPointer(m_PokeCount);
            if( poke->CanEvolve( &next_monsno ) ) {
              //poke->Evolve( next_monsno );
              m_Seq = SEQ_EVOLVE;
              return gamesystem::GMEVENT_RES_CONTINUE;
            }
          }
        }
        m_Seq = SEQ_END;
        gfl::ro::RoManager *roMgr = GFL_SINGLETON_INSTANCE( gfl::ro::RoManager );
        roMgr->DisposeModule( m_BattleModule );
        roMgr->DisposeModule( m_ShinkaModule );
      }
      break;

    case SEQ_EVOLVE:
      {
        pml::PokeParty* party = p_gdata->GetPlayerParty();
        MonsNo next_monsno = MONSNO_NULL;
        pml::pokepara::PokemonParam* poke = party->GetMemberPointer(m_PokeCount);
        poke->CanEvolve( &next_monsno );
        app::shinka_demo::APP_PARAM app_param;
        app_param.InitForBattleLevelUp( party, m_PokeCount, next_monsno );

        EventProcessCall::CallProc<app::shinka_demo::ShinkaDemo, app::shinka_demo::APP_PARAM > ( p_gman, &app_param );
        //EventProcessCall::CallRoProc<app::shinka_demo::ShinkaDemo, app::shinka_demo::APP_PARAM > ( p_gman, &app_param, "rom:/DllBattle.cro" );
        //gamesystem::GameProcManager *p_ProcMan = p_gman->GetProcManager();
        //dll::CallShinkaDemoProc(p_ProcMan, &app_param);

      }

      m_PokeCount ++;
      m_Seq = SEQ_EVOLVE_LOOP;
      break;

    case SEQ_END: // I
      return gamesystem::GMEVENT_RES_FINISH;
    }

    return gamesystem::GMEVENT_RES_CONTINUE;
  }

  //--------------------------------------------------------------
  /**
   * @brief   Ăяo֐ z֐
   * @param   p_gman       Q[}l[W[NX
   */
  //--------------------------------------------------------------

  void EventBattleReturn::EndFunc( gamesystem::GameManager* /*p_gman*/ )
  {
    GFL_PRINT("EventBattleReturn::EndFunc\n");
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  ogp[^ݒ
   */
  //-----------------------------------------------------------------------------

  void EventBattleReturn::SetBattleParam( const BATTLE_SETUP_PARAM * cp_bpara )
  {
    GFL_PRINT("EventBattleReturn::SetBattleParam\n");
    m_cpParam = cp_bpara;
  }




} // namespace field
