#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_Menu.h
 * @brief  j[
 * @author junya ikuta
 * @date   2012/05/01() 19:22
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once
#include <gfl_base.h>
#include <gfl_UI.h>
#include "test_ikuta_CBase.h"

namespace test {
  namespace ikuta {

    class Menu : public CBase 
    {
      GFL_FORBID_COPY_AND_ASSIGN( Menu );

      public:

      // j[
      struct MenuItemData {
        u32 itemID;           // ID (IɎ擾łl)
        u32 paneID;           // yC
        const wchar_t* label; // \镶
      }; 

      // j[S
      struct MenuData {
        const wchar_t* lytResFileName;          // CAEgf[^̃t@C
        gfl::grp::g2d::LytArcIndex arcIndex; // CAEg[ÑA[JCuCfbNX
        u32 itemNum;                         // ڐ
        const MenuItemData* items;           // eڂ̃f[^
      };


      // ZbgAbvp[^
      struct SetupParam { 
        gfl::heap::HeapBase* pHeap;       // q[v
        gfl::heap::HeapBase* pDeviceHeap; // foCXq[v
        const MenuData* pMenuData;        // j[f[^
      };

      //------------------------------------------------------------------------------
      /**
       * @brief RXgN^
         * @param pHeap             ̃vbNȉŎgpq[v 
         * @param pUiDeviceManager  ̃ubNȉŎgp͊Ǘ
         * @param pGraphicsSystem   ̃ubNȉŎgp`VXe匳
         * @param pG3dUtil		      ̃vbNȉŎgp3DVXeȈՃNX
         * @param pLayOutSystem     ̃vbNȉŎgp郌CAEgVXe
         * @param pRandom           ̃ubNȉŎgp郉_@
         * @param pFrameMode        ̃vbÑt[[g[h
       * @param pMenuData           j[ڂ̐ݒ
       */
      //------------------------------------------------------------------------------
      Menu( 
            app::util::Heap*                pHeap,          
            gfl::ui::DeviceManager*         pUiDeviceManager,
            gfl::grp::GraphicsSystem*       pGraphicsSystem, 
            app::util::G3DUtil*             pG3dUtil,		     
            gfl::grp::g2d::LytSys*          pLayOutSystem, 
            gfl::math::Random*              pRandom,         
            gamesystem::FrameMode*          pFrameMode,
          const MenuData* pMenuData );

      //------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //------------------------------------------------------------------------------
      virtual ~Menu();


      //------------------------------------------------------------------------------
      /**
       * @brief Iǂ𒲂ׂ
       */
      //------------------------------------------------------------------------------
      bool IsSelected( void ) const;

      //------------------------------------------------------------------------------
      /**
       * @brief LZǂ𒲂ׂ
       */
      //------------------------------------------------------------------------------
      bool IsCanceled( void ) const;

      //------------------------------------------------------------------------------
      /**
       * @brief Ij[̍ID擾
       */
      //------------------------------------------------------------------------------
      int GetSelectedItemID( void ) const;



      protected:

      const MenuData* m_pMenuData; // j[f[^
      int m_curIdx;                // ݑI𒆂̃j[ڂ̃CfbNX
      int m_selectedIdx;           // Iڂ̃CfbNX
      bool m_selectFlag;           // Iǂ
      bool m_cancelFlag;           // LZǂ

      gfl::grp::g2d::LytSys* m_LytSys;
      gfl::grp::g2d::LytResID m_ResID;
      gfl::grp::g2d::LytWk* m_LytWk;
      gfl::grp::g2d::Env* m_UpperEnv;
      gfl::grp::g2d::Env* m_LowerEnv;


      private:

      // eXg̃C
      virtual u32 UpdateImpl( void ); 
      virtual void DrawImpl( void );

      // CAEgVXe
      void InitializeLayoutSystem( const MenuData* menuData );

      // CAEgVXej
      void FinalizeLayoutSystem( void );

      // j[ڂȈԂɂ
      void SetMenuItemValid( u8 menuItemIdx );

      // j[ڂȈԂɂ
      void SetMenuItemInvalid( u8 menuItemIdx );
    };


  } // namespace ikuta
} // namespace test 

#endif // PM_DEBUG
