
#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_obata_Menu.cpp
 * @brief  j[
 * @author obata_toshihiro
 * @date   2010.12.08
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once 
#include <nn.h>
#include <gflib.h>
#include "test_ikuta_menu.h" 
#include "ikuta_menu_lyt_res.h"
#include "ikuta_menu_lyt_res_pane.h"

#include "../../system/launcher_lyt.h"
#include "../../system/launcher_lyt_pane.h"
//#include ""

namespace test {
  namespace ikuta {

    namespace menu {

      // ZbgAbv
      static const gfl::grp::g2d::LytWkSetUp s_LytWkSetUp[] = {
        {
          gfl::math::VEC3(0,0,0),   // pos
          gfl::math::VEC2(1,1),     // scale
          gfl::math::VEC3(0,0,0),   // rotate
          1,                        // priority
        }, 
      };

      static const gfl::grp::ProjectionParam sc_ProjectionParam[ 2 ] = {
        // p
        {
          gfl::grp::PROJECTION_ORTHO,
          { -200.0f, 200.0f, -120.0f, 120.0f },
          0.10f,
          800.0f,
          gfl::math::PIVOT_UPSIDE_TO_TOP
        },
        // p
        {
          gfl::grp::PROJECTION_ORTHO,
          { -160.0f, 160.0f, -120.0f, 120.0f },
          0.10f,
          800.0f,
          gfl::math::PIVOT_UPSIDE_TO_TOP
        },
      };

      static gfl::grp::ViewParam sc_ViewParam[] = {
        // p
        {
          gfl::math::VEC3(0,0,1),
          gfl::math::VEC3(0,1,0),
          gfl::math::VEC3(0,0,0)
        },
        // p
        {
          gfl::math::VEC3(0,-290,1),
          gfl::math::VEC3(0,1,0),
          gfl::math::VEC3(0,-290,0)
        },
        // p
        {
          gfl::math::VEC3(1,0,1),
          gfl::math::VEC3(0,1,0),
          gfl::math::VEC3(1,0,0)
        },
      }; 

    } // namespace menu
    //--------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     * @param pHeap             ̃vbNȉŎgpq[v 
     * @param pUiDeviceManager  ̃ubNȉŎgp͊Ǘ
     * @param pGraphicsSystem   ̃ubNȉŎgp`VXe匳
     * @param pG3dUtil		      ̃vbNȉŎgp3DVXeȈՃNX
     * @param pLayOutSystem     ̃vbNȉŎgp郌CAEgVXe
     * @param pRandom           ̃ubNȉŎgp郉_@
     */
    //--------------------------------------------------------------------------------
    Menu::Menu( 
        app::util::Heap*                pHeap,          
        gfl::ui::DeviceManager*         pUiDeviceManager,
        gfl::grp::GraphicsSystem*       pGraphicsSystem, 
        app::util::G3DUtil*             pG3dUtil,		     
        gfl::grp::g2d::LytSys*          pLayOutSystem, 
        gfl::math::Random*              pRandom,
        gamesystem::FrameMode*          pFrameMode,
        const MenuData*                 pMenuData
        )
      :
      CBase( pHeap, pUiDeviceManager, pGraphicsSystem, pG3dUtil, pLayOutSystem, pRandom, pFrameMode),
      m_pMenuData( pMenuData ),
      m_curIdx( 0 ),
      m_selectedIdx( 0 ),
      m_selectFlag( false ),
      m_cancelFlag( false ),
      //    m_pLayOutSystem( NULL ),
      m_ResID( 0 ),
      m_LytWk( NULL ),
      m_UpperEnv( NULL ),
      m_LowerEnv( NULL )
      { 
        this->InitializeLayoutSystem( pMenuData );
      }


    // CAEgVXe
    void Menu::InitializeLayoutSystem( const MenuData* menuData )
    {
      // CAEgVXe
      {
        static const gfl::grp::g2d::LytSysSetUp SetUp = {
          10, // lyt_resource_max
          10  // lyt_wk_max
        };


        //       m_pLayOutSystem = GFL_NEW(m_pHeap->pHeap) gfl::grp::g2d::LytSys(&SetUp, m_pHeap->pHeap_allocator, m_pHeap->pDevHeapAllocator);

        // \[Xǂݍ
        gfl::fs::ArcFile* arc = GFL_NEW(m_pHeap->pHeap) gfl::fs::ArcFile( m_pHeap->pHeap, menuData->lytResFileName, gfl::fs::ArcFile::OPEN );
        m_ResID = m_pLayOutSystem->LoadLytRes( m_pHeap->pDevHeapAllocator, arc, 0 );
        GFL_DELETE arc;
        //      m_pLayOutSystem->SetDefaultFont(SystemFont_GetFont() , "cbf_std.bcfnt");

        // VRAMɃeNX`]B
        m_pLayOutSystem->TransferAllTexture( m_ResID, gfl::grp::MEMORY_AREA_FCRAM );

        // CAEg[N
        m_LytWk  = m_pLayOutSystem->CreateLytWk( m_ResID, menuData->arcIndex, NULL, 0, 0, &menu::s_LytWkSetUp[0] );
      }

      // [U[EnvgpB
      { 
        m_UpperEnv = GFL_NEW(m_pHeap->pHeap) gfl::grp::g2d::Env();
        m_LowerEnv = GFL_NEW(m_pHeap->pHeap) gfl::grp::g2d::Env();

        m_UpperEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, menu::sc_ProjectionParam[0], menu::sc_ViewParam[0] );
        m_UpperEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, menu::sc_ProjectionParam[0], menu::sc_ViewParam[2] );

        m_LowerEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, menu::sc_ProjectionParam[1], menu::sc_ViewParam[1] );
        m_LowerEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, menu::sc_ProjectionParam[1], menu::sc_ViewParam[1] );

        m_LytWk->SetUserEnv( m_UpperEnv, m_LowerEnv );
      } 

      // eLXg{bNXyCɕݒ
      for( int i=0; i<menuData->itemNum; i++ )
      {
        gfl::grp::g2d::LytTextBox* textBox = m_LytWk->GetTextBoxPane( menuData->items[i].paneID );
        GFL_ASSERT( textBox );
        textBox->SetString( menuData->items[i].label );
      }
    }



    //-----------------------------------------------------------------------------
    // fXgN^
    //-----------------------------------------------------------------------------
    Menu::~Menu()
    { 
    //  this->FinalizeLayoutSystem();
    //
      if( m_LytWk )
      {
        if( m_pLayOutSystem )     // Öׂ
        {
          m_pLayOutSystem->RemoveLytWk( m_LytWk );
        }

        m_LytWk = 0;
      }
    }

    // CAEgVXej
    void Menu::FinalizeLayoutSystem( void )
    {
      GFL_DELETE m_UpperEnv;
      GFL_DELETE m_LowerEnv; 
      GFL_DELETE m_pLayOutSystem; 
    }





    //-----------------------------------------------------------------------------
    // C
    //-----------------------------------------------------------------------------
    u32 Menu::UpdateImpl( void )
    {
      if( m_selectFlag || m_cancelFlag ) {
        return 0;
      }

      // I
      if( m_pButton->IsTrigger( gfl::ui::BUTTON_A ) ) {
        m_selectedIdx = m_curIdx;
        m_selectFlag = true;
        this->End();
        return 0;
      } 

      // LZ
      if( m_pButton->IsTrigger( gfl::ui::BUTTON_B ) ) {
        m_cancelFlag = true;
        this->End();
        return 0;
      } 

      // J[\ړ
      if( m_pCrosskey->IsRepeat( gfl::ui::DIR_DOWN ) ) {
        this->SetMenuItemInvalid( m_curIdx );
        m_curIdx = ( m_curIdx + 1 ) % m_pMenuData->itemNum;
        this->SetMenuItemValid( m_curIdx );
      }

      // J[\ړ
      if( m_pCrosskey->IsRepeat( gfl::ui::DIR_UP ) ) {
        this->SetMenuItemInvalid( m_curIdx );
        m_curIdx = ( m_curIdx + m_pMenuData->itemNum - 1 ) % m_pMenuData->itemNum;
        this->SetMenuItemValid( m_curIdx );
      }

      // J[\ړ
      if( m_pCrosskey->IsRepeat( gfl::ui::DIR_RIGHT ) ) {
        this->SetMenuItemInvalid( m_curIdx );
        m_curIdx = ( m_curIdx + 14 ) % m_pMenuData->itemNum;
        this->SetMenuItemValid( m_curIdx );
      }

      // J[\ړ
      if( m_pCrosskey->IsRepeat( gfl::ui::DIR_LEFT ) ) {
        this->SetMenuItemInvalid( m_curIdx );
        m_curIdx = ( m_curIdx + m_pMenuData->itemNum - 14 ) % m_pMenuData->itemNum;
        this->SetMenuItemValid( m_curIdx );
      }

      return 0;
    }


    // j[ڂȈԂɂ
    void Menu::SetMenuItemValid( u8 menuItemIdx )
    {
      u32 pane_id = m_pMenuData->items[ menuItemIdx ].paneID;
      gfl::grp::g2d::LytTextBox* textBox = m_LytWk->GetTextBoxPane( pane_id );
      textBox->SetScale( gfl::math::VEC2( 1.2f, 1.2f ) );
    }


    // j[ڂȈԂɂ
    void Menu::SetMenuItemInvalid( u8 menuItemIdx )
    {
      u32 pane_id = m_pMenuData->items[ menuItemIdx ].paneID;
      gfl::grp::g2d::LytTextBox* textBox = m_LytWk->GetTextBoxPane( pane_id );
      textBox->SetScale( gfl::math::VEC2( 1.0f, 1.0f ) );
    }



    //-----------------------------------------------------------------------------
    // `
    //-----------------------------------------------------------------------------
    void Menu::DrawImpl( void )
    { 
      m_pLayOutSystem->UpdateAll();


      //      m_pGraphicsSystem->StartRendering();

      gfl::grp::RenderTarget* upperFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER);
      gfl::grp::RenderTarget* rightFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER_RIGHT);
      gfl::grp::RenderTarget* lowerFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_LOWER);

      m_pLayOutSystem->DrawAll( m_pGraphicsSystem, gfl::grp::DISPLAY_UPPER, upperFrameBuffer, rightFrameBuffer );
      m_pLayOutSystem->DrawAll( m_pGraphicsSystem, gfl::grp::DISPLAY_LOWER, lowerFrameBuffer );

      //m_pGraphicsSystem->EndRendering();


      // `XV
      //m_pGraphicsSystem->SwapBuffer(); 
      //nngxWaitVSync(NN_GX_DISPLAY_BOTH);

      // obt@Xbv
      //m_pGraphicsSystem->VSyncAfter();
    }



    //-----------------------------------------------------------------------------
    // Ij[ڂID擾
    //-----------------------------------------------------------------------------
    int Menu::GetSelectedItemID( void ) const
    {
      GFL_ASSERT( m_selectFlag ); // Iς݂łȂƃ_

      return m_pMenuData->items[ m_selectedIdx ].itemID;
    }


    //------------------------------------------------------------------------------
    // Iǂ𒲂ׂ
    //------------------------------------------------------------------------------
    bool Menu::IsSelected( void ) const
    {
      return m_selectFlag;
    }


    //------------------------------------------------------------------------------
    // LZǂ𒲂ׂ
    //------------------------------------------------------------------------------
    bool Menu::IsCanceled( void ) const
    {
      return m_cancelFlag;
    }


  } // namespace ikuta
} // namespace test 

#endif // PM_DEBUG
