#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_Proc.h
 * @brief  eXgvZX
 * @author obata_toshihiro
 * @date   2012/05/01() 15:28
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// Sys
#include <gfl_Base.h>
#include <gfl_Heap.h>
#include <gfl_UI.h>
#include <gamesystem/GameProc.h>
#include <str/gfl_MsgData.h>
#include <math/gfl_MathRandom.h>
#include <poke_tool/poke_model_sys.h>

// appSys
#include "app/util/app_util_heap.h"

namespace test {
  namespace ikuta {
    class Menu;
    class CBase;

    class CText;
    class CPokemon;

    class Proc : public gamesystem::GameProc
    {
      public:

        enum STATE {
          kSTATE_NULL = 0,  // 
          kSTATE_LOAD,      // [h
          kSTATE_3D_DRAW,   // 3Df`撆
          kNUM_STATE
        };

        Proc( void );
        virtual ~Proc( void );

        virtual gfl::proc::Result InitFunc( gfl::proc::Manager* pProcManager );
        virtual gfl::proc::Result UpdateFunc( gfl::proc::Manager* pProcManager );
        virtual void DrawFunc( gfl::proc::Manager* pProcManager );
        virtual gfl::proc::Result EndFunc( gfl::proc::Manager* pProcManager );

      protected:

        void DeleteMenuAndCreateSelectedChild( gfl::proc::Manager* proc_manager );
        void CreateChild( u32 child );

        virtual gamesystem::FrameMode GetFrameMode( void ) const;

        // ʏϐ
        STATE                           m_State;            // ԕϐ
 
        Menu*                           m_pMenu;            // qV[
        CBase*                           m_pChild;           // qj[

        // IuWFNg
        CText*                          m_pText;            // eLXg\

        // VXe֘A
        gfl::ui::DeviceManager*         m_pUiDeviceManager; // ͊Ǘ
        gfl::grp::GraphicsSystem*       m_pGraphicsSystem;  // `VXe匳
        //       gfl::grp::g3d::System*          m_pG3dSys;          // ̃vbNȉŎgp3DVXe(Utilɓꂽ)
        //       gfl::grp::g3d::Scene*           m_Scene;
        //       gfl::grp::g3d::StereoCamera*    m_Camera; 
        app::util::G3DUtil*             m_pG3dUtil;		      // ̃vbNȉŎgp3DVXeȈՃNX
        app::util::Heap*                m_pHeap;            // ̃vbNȉŎgpq[v 
        gfl::grp::g2d::LytSys*          m_pLayOutSystem;    // ̃vbNȉŎgp郌CAEgVXe
        gfl::math::Random*              m_pRandom;          // _@
        gamesystem::FrameMode           m_FrameMode;

        // |Pf֘A
        poke_tool::PokeModelSystem*     m_pPokeModelSystem;
        CPokemon*                       m_pPokeArray;       // |P̔z
    };
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG
