#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_Proc.cpp
 * @brief  eXgvZX
 * @author junya ikuta
 * @date   2012/05/01() 15:37
 */
/////////////////////////////////////////////////////////////////////////////////////// 

// Sys
#include <gflib.h>
#include <base/gfl_ProcManager.h>

// appSys
#include <system/main.h>
#include "gamesystem/GameProc.h"
#include "gamesystem/GameProcManager.h"
#include "dll/DllProc.h"

// appProc
#include "test_ikuta_menu.h"
#include "test_ikuta_CProc3DTest.h"
#include "test_ikuta_CProcTitleTest.h"
#include "game/test_ikuta_game_CProcGame.h"

// app
#include "test_ikuta_Proc.h"
#include "test_ikuta_CText.h"                       // eLXg\NX
#include "test_ikuta_CPokemon.h"

// res
#include "ikuta_menu_lyt_res.h"
#include "ikuta_menu_lyt_res_pane.h"

//#include "../../system/launcher_lyt.h"
//#include "../../system/launcher_lyt_pane.h"

#include "message/debug_message.gaix"               // bZ[Warct@Cwb_[
#include "message/debug/msg_d_ikuta.h"              // gp郁bZ[W̃wb_[

#include "ikuta_game.gaix"
#include "arc_def.h"

namespace test {
  namespace ikuta {
    namespace game{


    // qj[̒`
    enum ITEM_ID{
      kITEM_ID_3D_TEST = 0,
      kITEM_ID_TITLE,
      kITEM_ID_GAME,
      kNUM_ITEM
    };


#define kDIRECT_JUMP_CHILD  (kITEM_ID_GAME)

    test::ikuta::Menu::MenuItemData kA_MENU_ITEM_DATA[ kNUM_ITEM ] = 
    {
      { kITEM_ID_3D_TEST,           PANENAME_IKUTA_MENU_PANE_TEXTBOX_00, L"3D Test" },
      { kITEM_ID_TITLE,             PANENAME_IKUTA_MENU_PANE_TEXTBOX_01, L"TITLE Test" },
      { kITEM_ID_GAME,              PANENAME_IKUTA_MENU_PANE_TEXTBOX_02, L"Game" }
    };

    test::ikuta::Menu::MenuData kMENU_DATA =
    {
      L"rom:/ikuta_menu_lyt_res.garc",
      LYTRES_IKUTA_MENU_LYT_RES_IKUTA_MENU_BCLYT,
      kNUM_ITEM, 
      kA_MENU_ITEM_DATA
    }; 

    // 萔`
    static const f32 NEAR_PLANE = 32.0f;
    static const f32 FAR_PLANE  = 5000.1f;

    const u32                         k3D_SYSTEM_RESOURCE_OBJECT_MAX(1024 + 512);

    //-------------------------------------------------------------------------------------
    // RXgN^
    //-------------------------------------------------------------------------------------
    Proc::Proc( void ) :

      // ʏϐ
      m_State( kSTATE_NULL ),

      m_pMenu( 0 ),
      m_pChild( 0 ),

      // IuWFNg
      m_pText( 0 ),

      // VXe
      m_pHeap( NULL ),
      m_pGraphicsSystem( NULL ),
      m_pUiDeviceManager( NULL ),
      m_pLayOutSystem( 0 ),
      m_pG3dUtil( 0 ),
      m_pRandom( 0 ),
      m_FrameMode( gamesystem::FRAMEMODE_60 ),

      // poke
      m_pPokeModelSystem( 0 ),
      m_pPokeArray( 0 )
      {
      }


    //-------------------------------------------------------------------------------------
    // fXgN^
    //-------------------------------------------------------------------------------------
    Proc::~Proc( void )
    {

    }


    //-------------------------------------------------------------------------------------
    // 
    //-------------------------------------------------------------------------------------
    gfl::proc::Result Proc::InitFunc( gfl::proc::Manager* pProcManager )
    {
      GFL_UNUSED( pProcManager );

      //------------------------------------------------------------------------------------
      // VXe

      // q[vAP[^
      gfl::heap::HeapBase* parent_app_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP ); 
      gfl::heap::HeapBase* parent_dev_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );     
      m_pHeap = GFL_NEW(parent_app_heap) app::util::Heap; 
      size_t app_heap_size = parent_app_heap->GetTotalAllocatableSize();
      size_t dev_heap_size = parent_dev_heap->GetTotalAllocatableSize();
      m_pHeap->Create(parent_app_heap, parent_dev_heap, HEAPID_IKUTA_APP, app_heap_size, HEAPID_IKUTA_DEVICE, dev_heap_size);

      // _@̏
      m_pRandom = GFL_NEW( m_pHeap->pHeap )gfl::math::Random();
      m_pRandom->Initialize();

      // ObtBbNVXe̐(VOg)
      m_pGraphicsSystem = GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetGraphicsSystem();
      m_pGraphicsSystem->InitializeApplicationMemory(m_pHeap->pDevHeapAllocator);                 // AvP[ṼfoCXq[vgp
      GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->SetRenderingParameter(0.0f);               // ? 

      //----------------------------------------------------------------------------------------
      // 3D

      // 3DVXe̐
      gfl::grp::g3d::System::Description description;
      description.resource_object_num_max = k3D_SYSTEM_RESOURCE_OBJECT_MAX;
      m_pG3dUtil = GFL_NEW(m_pHeap->pHeap) app::util::G3DUtil();
      m_pG3dUtil->CreateG3dSystem(m_pHeap, &description);
    //  m_pG3dUtil->CreateG3dScene(app::util::G3DUtil::ENVIRONMENT_RES_NONE, 0, m_pHeap);
    //    m_pG3dUtil->CreateG3dScene(ARCID_IKUTA_GAME, GARC_ikuta_game_SceneEnvironmentSetting_BCENV, m_pHeap, false);
      m_pG3dUtil->CreateG3dScene(ARCID_IKUTA_GAME, GARC_ikuta_game_SceneEnvironmentSetting_BCENV_LZ, m_pHeap, true);

    // J͎qV[ō쐬`ɂ
#if 0
      // JvOō쐬
      const app::util::G3DUtil::CAMERA_CREATE_DATA dat[] =
      {
        {
          //          kCAMERA_DISTANCE,
          gfl::math::VEC3(0.0f,0.0f,-1.0f),
          gfl::math::VEC3(0.0f,0.0f,0.0f),
          1.0f,
          1000.0f,
          gfl::grp::g3d::StereoCamera::FOVY_RADIAN_DEFAULT,
          0.0f,
          gfl::grp::g3d::StereoCamera::DEPTH_LEVEL_DEFAULT,
          gfl::grp::g3d::StereoCamera::DEPTH_RANGE_DEFAULT,
          gfl::grp::g3d::StereoCamera::REAL_SWITCH_DEFAULT
        },
      };
      m_pG3dUtil->CreateG3dCamera( m_pHeap, app::util::G3DUtil::SETUP_CAMERA_UPPER, &dat[0], NULL );
#endif
      // GbWVXe쐬
      m_pG3dUtil->CreateEdgeSystem(m_pGraphicsSystem, app::util::G3DUtil::EDGE_SET_FLAG_UPPER, m_pHeap );
      m_pG3dUtil->SetupG3dScene();

      // |PfVXe쐬
      //     m_pPokeModelSystem = GFL_NEW(m_pHeap->pHeap) poke_tool::PokeModelSystem();  
      //     m_pPokeModelSystem->InitSystem(m_pHeap->pHeapAllocator, m_pHeap->pDevHeapAllocator, GFL_SINGLETON_INSTANCE(gamesystem::GameManager )->GetFileReadManager());

      // ̓VXe
      m_pUiDeviceManager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetUiDeviceManager();


      //-----------------------------------------------------------------------------
      // 2D

      // CAEgVXe
      {
        gfl::grp::g2d::LytSysSetUp lytSysSetUp;
        lytSysSetUp.lyt_resource_max = 128;
        lytSysSetUp.lyt_wk_max = 10;

        m_pLayOutSystem = GFL_NEW( m_pHeap->pHeap ) gfl::grp::g2d::LytSys(
            &lytSysSetUp,
            m_pHeap->pHeapAllocator,
            m_pHeap->pDevHeapAllocator
            );
      }

      //------------------------------------------------------------------------------
      // IuWFNg
#if 0
      // |P
      {
        m_pPokeArray = GFL_NEW_ARRAY( m_pHeap->pHeap ) CPokemon[kNUM_POKEMON];
        CPokemon* pSelect = &m_pPokeArray[0];
        u32 prevHeap(m_pHeap->pHeap->GetTotalFreeSize());
        u32 prevDevHeap(m_pHeap->pDevHeap->GetTotalFreeSize());

        for( u32 i = 0; i < kNUM_POKEMON; i++, pSelect++ )
        {
          CPokemon::SETUP_PARAM setup;
          setup.pHeap = m_pHeap;
          setup.pScene =  m_pG3dUtil->GetScene();
          setup.pPokeModelSystem = m_pPokeModelSystem;

          setup.pos = kPOKEMON_DEF_POSITION + kPOKEMON_DISTANCE * i;
          pSelect->Init(&setup);

          //  GFL_PRINT( "HEAPID_IKUTA: 0x%x/0x%x, 0x%x/0x%x\n", 
          GFL_PRINT( "HEAPID_IKUTA: %d/%d, %d/%d\n", 
              m_pHeap->pHeap->GetTotalFreeSize(), m_pHeap->pHeap->GetTotalSize(),
              m_pHeap->pDevHeap->GetTotalFreeSize(), m_pHeap->pDevHeap->GetTotalSize() );

          GFL_PRINT( "- %d, - %d\n", prevHeap - m_pHeap->pHeap->GetTotalFreeSize(), 
              prevDevHeap - m_pHeap->pDevHeap->GetTotalFreeSize());

          prevHeap = m_pHeap->pHeap->GetTotalFreeSize();
          prevDevHeap = m_pHeap->pDevHeap->GetTotalFreeSize();
        }
      }

      // 2DeLXg
      {
        m_pText = GFL_NEW( m_pHeap->pHeap ) CText();
        CText::SETUP_PARAM textSetUp;
        textSetUp.pHeap = m_pHeap;
        textSetUp.pGraphicsSystem = m_pGraphicsSystem;
        textSetUp.pLayOutSystem = m_pLayOutSystem;
        textSetUp.startMessageRabel = 0;
        textSetUp.pLayOutFilePath = kFILEPATH_LAYOUT;
        textSetUp.layOutArcIndex = kARC_INDEX;
        textSetUp.layOutTextBoxPaneIndex = kLAYOUT_TEXTBOX_PANE_INDEX;
        textSetUp.pMessageFilePath = kFILEPATH_MESSAGE;
        textSetUp.messageDatID = kMESSAGE_ARC_INDEX; 
        m_pText->Init(&textSetUp);
      }

      //--------------------------------------------------------------------------------
      // ̑p[^

      m_State = kSTATE_LOAD;

#endif

#ifdef kDIRECT_JUMP_CHILD
     CreateChild( kDIRECT_JUMP_CHILD );  

#else
     //--------------------------------------------------------------------------------
      // j[쐬
      m_pMenu = GFL_NEW( m_pHeap->pHeap ) test::ikuta::Menu( 
          m_pHeap,
          m_pUiDeviceManager,
          m_pGraphicsSystem, 
          m_pG3dUtil,
          m_pLayOutSystem,
          m_pRandom,
          &m_FrameMode,
          &kMENU_DATA
          );
#endif

      return gfl::proc::RES_FINISH;
    }

    //-------------------------------------------------------------------------------------
    // I
    //-------------------------------------------------------------------------------------
    gfl::proc::Result Proc::EndFunc( gfl::proc::Manager* pProcManager )
    {
      GFL_UNUSED( pProcManager );

      // ʏϐ
      m_State = kSTATE_NULL;

      // ؂蕨null邾
      m_pUiDeviceManager = 0;

      // qV[̔j
      GFL_SAFE_DELETE( m_pMenu );

      // ō쐬̂j
      //   GFL_SAFE_DELETE( m_pText );
      //   GFL_SAFE_DELETE_ARRAY( m_pPokeArray );

      //	pPokeModel->RemoveScene( m_pG3dUtil->GetScene() );  // BoxPokeModel::RemoveScene(void)

      // VXe͏ԂɒӂȂ΂ȂH
      GFL_SAFE_DELETE( m_pPokeModelSystem );   
      GFL_SAFE_DELETE( m_pLayOutSystem );

      // Util̃fXgN^͋󔒂Ȃ̂Ŏŏ
      if( m_pG3dUtil )
      {
        // null`FbNĂȂ̂m_pG3dUtilĂ鎞AL̕CreateĂ鎖ۏႳĂȂƂȂB
        m_pG3dUtil->DeleteEdgeSystem();
        //  m_pG3dUtil->DeleteG3dLight();
    //    m_pG3dUtil->DeleteG3dCamera();
        m_pG3dUtil->DeleteG3dScene();
        m_pG3dUtil->DeleteG3dSystem();
        GFL_SAFE_DELETE( m_pG3dUtil );
      }

      // OtBbNVXe͎؂蕨AAP[^[蓖ĂĂ̂ŏ
      if( m_pGraphicsSystem )
      {
        m_pGraphicsSystem->FinalizeApplicationMemory();
        m_pGraphicsSystem = 0;
      }

      // q[vUtil̓fXgN^Ŗ薳
      GFL_SAFE_DELETE( m_pHeap );

      return gfl::proc::RES_FINISH;
    }

    //-------------------------------------------------------------------------------------
    // XV
    //-------------------------------------------------------------------------------------
    gfl::proc::Result Proc::UpdateFunc( gfl::proc::Manager* pProcManager )
    {
      GFL_UNUSED( pProcManager );

      // j[̍XV 
      if( m_pMenu ) 
      {
        m_pMenu->Update();

        // j[ŃLZIꂽvbNI
        if( m_pMenu->IsCanceled() )
        {
          return gfl::proc::RES_FINISH;
        }
        // Iꂽ烁j[jĎqV[쐬
        else if( m_pMenu->IsSelected() ) 
        {
          this->DeleteMenuAndCreateSelectedChild( pProcManager );
        }
      }
      // qV[̍XV
      else 
      {
        m_pChild->Update(); 
        if( m_pChild->IsEnd() ) 
        {
          GFL_SAFE_DELETE( m_pChild );

          m_pMenu = GFL_NEW( m_pHeap->pHeap ) Menu( 
              m_pHeap,
              m_pUiDeviceManager,
              m_pGraphicsSystem, 
              m_pG3dUtil,
              m_pLayOutSystem,
              m_pRandom,
              &m_FrameMode,
              &kMENU_DATA
              );

        }
      }
#if 0
      switch(m_State)
      {
      case kSTATE_LOAD:
#if 1
        bool next(true);
        CPokemon* pSelect = &m_pPokeArray[0];
        for( u32 i = 0; i < kNUM_POKEMON; i++, pSelect++ )
        {
          pSelect->Update();

          // S̃[hI܂ő҂
          if(!pSelect->IsSettingEnd())
            next = false;
        }

        if(next)
        {
          m_State = kSTATE_3D_DRAW;
          CPokemon* pSelect = &m_pPokeArray[1];
          for( u32 i = 1; i < kNUM_POKEMON; i++, pSelect++ )
          {
            pSelect->SetParent(m_pPokeArray);
          }
        }
#endif
        break;


      case kSTATE_3D_DRAW:
        {
          // ͑
          m_pPokeArray->ManualUpdate( m_pUiDeviceManager );

          CPokemon* pSelect = &m_pPokeArray[1];
          for( u32 i = 1; i < kNUM_POKEMON; i++, pSelect++ )
          {
            pSelect->Update();
          }

          gfl::math::VEC3 cameraPos(m_pPokeArray->GetPosition());

          m_pG3dUtil->GetUpperCamera()->SetCameraAndTargetPosition(cameraPos + kCAMERA_DISTANCE, cameraPos);
        }
      }
#endif
      // qV[ŌĂяo`ɕύXH
#if 0
      // vĊmF
      m_pG3dUtil->CalculateG3dScene();
      m_pPokeModelSystem->UpdateSystem();
      m_pPokeModelSystem->UpdateModel();
      m_pPokeModelSystem->UpdateModelAnime();
      m_pG3dUtil->Update3D( false );

      // CAEg̍XV
      m_pLayOutSystem->UpdateAll();
#endif
      return gfl::proc::RES_CONTINUE;
    }


    //-------------------------------------------------------------------------------------
    // `揈
    //-------------------------------------------------------------------------------------
    void Proc::DrawFunc( gfl::proc::Manager* pProcManager )
    {
      GFL_UNUSED( pProcManager );

      GFL_UNUSED( pProcManager );

      if( m_pMenu )
      {
        m_pMenu->Draw();
      }
      else if( m_pChild )
      {
        m_pChild->Draw();
      }
#if 0
      gfl::grp::RenderTarget* upperFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER);
      gfl::grp::RenderTarget* rightFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER_RIGHT);
      gfl::grp::RenderTarget* lowerFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_LOWER);

      m_pLayOutSystem->DrawAll( m_pGraphicsSystem, gfl::grp::DISPLAY_UPPER, upperFrameBuffer, rightFrameBuffer );
      m_pLayOutSystem->DrawAll( m_pGraphicsSystem, gfl::grp::DISPLAY_LOWER, lowerFrameBuffer );

      m_pG3dUtil->Draw3D( m_pGraphicsSystem );
#endif    
    }


    //-------------------------------------------------------------------------------------
    // j[j, IꂽeXgCX^X𐶐
    //-------------------------------------------------------------------------------------
    void Proc::DeleteMenuAndCreateSelectedChild( gfl::proc::Manager* proc_manager )
    {
      GFL_ASSERT( m_pMenu );
      GFL_ASSERT( m_pChild == NULL );

      // IIDoč폜
      int selectedItemId = m_pMenu->GetSelectedItemID(); 
      GFL_SAFE_DELETE( m_pMenu );

      CreateChild( selectedItemId );
      //GFL_PRINT( "2: m_graphics_system=%x\n", m_graphics_system );
    }

    //-------------------------------------------------------------------------------------
    // j[j, IꂽeXgCX^X𐶐
    //-------------------------------------------------------------------------------------
    void Proc::CreateChild( u32 child )
    {
      // Iڂ𐶐
      switch( child ) 
      {
      default:
        GFL_ASSERT(0);
        /* fall through */
      case kITEM_ID_3D_TEST: 
        m_pChild = GFL_NEW( m_pHeap->pHeap ) CProc3DTest
          (
           m_pHeap,
           m_pUiDeviceManager,
           m_pGraphicsSystem, 
           m_pG3dUtil,
           m_pLayOutSystem,
           m_pRandom,
           &m_FrameMode
          );  
        break;

      case kITEM_ID_TITLE: 
        m_pChild = GFL_NEW( m_pHeap->pHeap ) CProcTitleTest
          (
           m_pHeap,
           m_pUiDeviceManager,
           m_pGraphicsSystem, 
           m_pG3dUtil,
           m_pLayOutSystem,
           m_pRandom,
           &m_FrameMode
          );  
        break;

      case kITEM_ID_GAME: 
        m_pChild = GFL_NEW( m_pHeap->pHeap ) CProcGame
          (
           m_pHeap,
           m_pUiDeviceManager,
           m_pGraphicsSystem, 
           m_pG3dUtil,
           m_pLayOutSystem,
           m_pRandom,
           &m_FrameMode
          );  
        break;

      }

    }

    gamesystem::FrameMode Proc::GetFrameMode( void ) const
    {
      return m_FrameMode;
    }


    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG
