#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_CText.cpp
 * @brief  CAEgƃbZ[WX^WĨbp[NX
 * @author junya ikuta
 * @date   2012/05/09() 16:01
 */
///////////////////////////////////////////////////////////////////////////////////////

// VXe
#include "test_ikuta_CText.h"

// res
#include "message/debug_message.gaix"               // bZ[Warct@Cwb_[
#include "message/debug/msg_d_ikuta.h"              // gp郁bZ[W̃wb_[


namespace test {
  namespace ikuta {

    // ZbgAbv
    const gfl::grp::g2d::LytWkSetUp const kA_LAYOUT_WORK_SET_UP[] = {
      {
        gfl::math::VEC3(0,0,0),   // pos
        gfl::math::VEC2(1,1),     // scale
        gfl::math::VEC3(0,0,0),   // rotate
        1,                        // priority
      }, 
    };

    static const gfl::grp::ProjectionParam sc_ProjectionParam[ 2 ] = {
      // p
      {
        gfl::grp::PROJECTION_ORTHO,
        { -200.0f, 200.0f, -120.0f, 120.0f },
        0.10f,
        800.0f,
        gfl::math::PIVOT_UPSIDE_TO_TOP
      },
      // p
      {
        gfl::grp::PROJECTION_ORTHO,
        { -160.0f, 160.0f, -120.0f, 120.0f },
        0.10f,
        800.0f,
        gfl::math::PIVOT_UPSIDE_TO_TOP
      },
    };

    static gfl::grp::ViewParam sc_ViewParam[] = {
      // p
      {
        gfl::math::VEC3(0,0,1),
        gfl::math::VEC3(0,1,0),
        gfl::math::VEC3(0,0,0)
      },
      // p
      {
        gfl::math::VEC3(0,-290,1),
        gfl::math::VEC3(0,1,0),
        gfl::math::VEC3(0,-290,0)
      },
      // p
      {
        gfl::math::VEC3(1,0,1),
        gfl::math::VEC3(0,1,0),
        gfl::math::VEC3(1,0,0)
      },
    }; 

    const u32 kSTR_BUF_SIZE(1024);
    const u32 kSTR_BUF_TEMP_SIZE(1024);

    //------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     */
    //------------------------------------------------------------------------------
    CText::CText( void ) : 

      // p[^ϐ
      m_State( kSTATE_NULL ),               // ԕϐ
      m_DrawMessageLabel( 0 ),              // \̃x            

      // VXe
      m_pHeap( 0 ),                         // gpq[v(ؕ)
      m_pGraphicsSystem( 0 ),               // gpOtBbNVXe(؂蕨)

      // CAEg֘A
      m_pLayOutSystem( 0 ),
      m_ResID( gfl::grp::g2d::LYTSYS_RESID_ERROR ),
      m_pLayOutWork( 0 ),
      //    m_pUpperEnv( 0 ),
      //    m_pLowerEnv( 0 ),
      m_LayOutTextBoxPaneIndex( 0 ),

      // bZ[W֘A
      m_pMessageData( 0 ),
      m_pStrBuf( 0 ),
      m_pStrBufTmp( 0 )
      {


      }

    //------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //------------------------------------------------------------------------------
    CText::~CText()
    {
      Uninit();
    }

    //------------------------------------------------------------------------------
    /**
     * @brief 
     * @param pSetUp            ɕKvȃf[^\
     */
    //------------------------------------------------------------------------------
    bool CText::Init(CText::SETUP_PARAM* pSetUp)
    {
      // ASSEART

      Uninit();

      // nꂽ|C^L
      m_pHeap = pSetUp->pHeap;                                      // gpq[v(؂蕨)
      m_pGraphicsSystem = pSetUp->pGraphicsSystem;                  // gpOtBbNVXe(؂蕨)
      m_pLayOutSystem = pSetUp->pLayOutSystem;                      // gp郌CAEgVXe(؂蕨)
      m_LayOutTextBoxPaneIndex = pSetUp->layOutTextBoxPaneIndex;    // CAEg̃eLXg{bNXID

      // CAEg[N̍쐬
      if( !InitLayoutWork ( pSetUp->pLayOutFilePath, pSetUp->layOutArcIndex ) )
      {
        Uninit();
        return false;
      }

      // bZ[W̍쐬
      m_pMessageData = GFL_NEW(m_pHeap->pHeap) gfl::str::MsgData(
          pSetUp->pMessageFilePath,
          pSetUp->messageDatID,
          m_pHeap->pHeap, 
          gfl::str::MsgData::LOAD_FULL 
          );

      // bZ[Wpobt@쐬
      //  m_pStrBuf    = GFL_NEW( m_pHeap->pHeap ) gfl::str::StrBuf( kSTR_BUF_SIZE, m_pHeap->pHeap );
      m_pStrBufTmp = GFL_NEW( m_pHeap->pHeap ) gfl::str::StrBuf( kSTR_BUF_TEMP_SIZE, m_pHeap->pHeap );

      // ̑p[^
      m_State = kSTATE_DRAW;
      m_DrawMessageLabel = pSetUp->startMessageRabel;

      // ̕ύX
      ResetText();

      return true;
    }

    //------------------------------------------------------------------------------
    /**
     * @brief I
     */
    //------------------------------------------------------------------------------
    void CText::Uninit( void )
    {
      GFL_SAFE_DELETE( m_pStrBuf );
      GFL_SAFE_DELETE( m_pStrBufTmp );
      GFL_SAFE_DELETE( m_pMessageData );

      m_pHeap = 0;
      m_pGraphicsSystem = 0;
      m_LayOutTextBoxPaneIndex = 0;
      m_State = kSTATE_NULL;
      m_DrawMessageLabel = 0;

      // CAEgVXeɉ˗
      UninitLayoutWork();

      // CAEgVXeɃ\[X̉˗
      if( m_ResID != gfl::grp::g2d::LYTSYS_RESID_ERROR)
      {
        if( m_pLayOutSystem )     // Ö
          m_pLayOutSystem->ReleaseLytRes( m_ResID );

        m_ResID = gfl::grp::g2d::LYTSYS_RESID_ERROR;
      }

      m_pLayOutSystem = 0;
    }

    //------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //------------------------------------------------------------------------------
    CText::STATE CText::Update( void )
    {
      return m_State;
    }

    //------------------------------------------------------------------------------
    /**
     * @brief `揈
     */
    //------------------------------------------------------------------------------
    void CText::Draw( void )
    {
      // `͏wŃCAEgVXes

    }

    //------------------------------------------------------------------------------
    /**
     * @brief eLXg݂̏Ԃ̏Ԃɖ߂
     * */
    //------------------------------------------------------------------------------
    void CText::ResetText( void )
    {      
      // if( label >= m_pMessageData->GetStrCount() )

      m_pMessageData->GetString(m_DrawMessageLabel, *m_pStrBufTmp);
      m_pLayOutWork->GetTextBoxPane(m_LayOutTextBoxPaneIndex)->SetString(m_pStrBufTmp->GetPtr());
    }


    //------------------------------------------------------------------------------
    /**
     * @brief `悷郉xԍZbg
     */
    //------------------------------------------------------------------------------
    void CText::SetDrawMessageLabel( const u32 label )
    {
      // if( label >= m_pMessageData->GetStrCount() )

      if( m_DrawMessageLabel != label )
      {
        m_DrawMessageLabel = label;

      }
    }

    //------------------------------------------------------------------------------
    /**
     * @brief `撆̃xԍ擾
     */
    //------------------------------------------------------------------------------
    u32 CText::GetDrawMessageLabel( void ) const
    { 

      return m_DrawMessageLabel; 

    }


    //------------------------------------------------------------------------------
    /**
     * @brief ێĂ郉x̑擾
     */
    //------------------------------------------------------------------------------
    u32 CText::LabelSize( void )
    {
      return m_pMessageData->GetStrCount();
    }

    // private

    //------------------------------------------------------------------------------
    /**
     * @brief CAEg[N
     */
    //------------------------------------------------------------------------------
    bool CText::InitLayoutWork( const wchar_t* pFilePath, gfl::grp::g2d::LytArcIndex layOutArcIndex )
    {
      // \[X̓ǂݍ
      gfl::fs::ArcFile* pArc = GFL_NEW( m_pHeap->pHeap ) gfl::fs::ArcFile( m_pHeap->pHeap, pFilePath, gfl::fs::ArcFile::OPEN );
      m_ResID = m_pLayOutSystem->LoadLytRes( m_pHeap->pDevHeapAllocator, pArc, 0 );
      GFL_DELETE pArc;

      // VRAMɃeNX`]
      m_pLayOutSystem->TransferAllTexture( m_ResID, gfl::grp::MEMORY_AREA_FCRAM );

      // CAEg[N𐶐
      m_pLayOutWork = m_pLayOutSystem->CreateLytWk( m_ResID, layOutArcIndex, NULL, 0, 0, &kA_LAYOUT_WORK_SET_UP[0] );

      // [U[Env쐬


      return true;
    }

    //------------------------------------------------------------------------------
    /**
     * @brief CAEg[Nj
     */
    //------------------------------------------------------------------------------
    void CText::UninitLayoutWork( void )
    {
      if( m_pLayOutWork )
      {
        if( m_pLayOutSystem )     // Öׂ
        {
          m_pLayOutSystem->RemoveLytWk( m_pLayOutWork );
        }

        m_pLayOutWork = 0;
      }
    }


  } // namespace ikuta
} // namespace test 

#endif // PM_DEBUG

// EOF
