#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_Proc.cpp
 * @brief  eXgvZX
 * @author junya ikuta
 * @date   2012/05/01() 15:37
 */
/////////////////////////////////////////////////////////////////////////////////////// 

// Sys
#include <gflib.h>
#include <base/gfl_ProcManager.h>

// appSys
#include <system/main.h>
#include "gamesystem/GameProc.h"
#include "gamesystem/GameProcManager.h"
#include "dll/DllProc.h"

// app
#include "test_ikuta_CProcTitleTest.h"
#include "test_ikuta_CText.h"                       // eLXg\NX
#include "test_ikuta_CPokemon.h"

// res
#include "ikuta_title.h"
#include "ikuta_menu_lyt_res.h"
#include "ikuta_menu_lyt_res_pane.h"

#include "../../system/launcher_lyt.h"
#include "../../system/launcher_lyt_pane.h"

#include "message/debug_message.gaix"               // bZ[Warct@Cwb_[
#include "message/debug/msg_d_ikuta.h"              // gp郁bZ[W̃wb_[



namespace test {
  namespace ikuta {

    // 萔`

    const wchar_t* const              kTITLE_FILEPATH_LAYOUT(L"rom:/ikuta_menu_lyt_res.garc");
    const gfl::grp::g2d::LytArcIndex  kTITLE_ARC_INDEX(LYTRES_IKUTA_MENU_LYT_RES_IKUTA_MENU_BCLYT);    
    const gfl::grp::g2d::LytPaneIndex kTITLE_LAYOUT_TEXTBOX_PANE_INDEX(PANENAME_IKUTA_MENU_PANE_TEXTBOX_00);

    const wchar_t* const              kTITLE_FILEPATH_MESSAGE(L"rom:/debug_message.garc");
    const u32                         kTITLE_MESSAGE_ARC_INDEX(GARC_debug_message_d_ikuta_DAT);

    const u32                         kTITLE_NUM_POKEMON(1);                              // 8OK

    const gfl::math::VEC3             kTITLE_POKEMON_DEF_POSITION(0.0f, 0.0f, 0.0f);        // ʒu
    const gfl::math::VEC3             kTITLE_POKEMON_DISTANCE(0.0f, 0.0f, 50.0f);
    const gfl::math::VEC3             kTITLE_CAMERA_DISTANCE(0.0f, 500.0f, 500.0f);

    enum TITLE_ANIMATION {
      kTITLE_ANIMATION_UPDATE = 0,
      kTITLE_ANIMATION_LOOP,
      kNUM_TITLE_ANIMATION
    };



    //-------------------------------------------------------------------------------------
    // RXgN^
    //-------------------------------------------------------------------------------------
    CProcTitleTest::CProcTitleTest(
        app::util::Heap*                pHeap,          
        gfl::ui::DeviceManager*         pUiDeviceManager,
        gfl::grp::GraphicsSystem*       pGraphicsSystem, 
        app::util::G3DUtil*             pG3dUtil,		     
        gfl::grp::g2d::LytSys*          pLayOutSystem, 
        gfl::math::Random*              pRandom,
        gamesystem::FrameMode*          pFrameMode
        ) :
      CBase( pHeap, pUiDeviceManager, pGraphicsSystem, pG3dUtil, pLayOutSystem, pRandom, pFrameMode),

      // ʏϐ
      m_State( kSTATE_NULL ),

      // IuWFNg
      //     m_pText( 0 ),

      // CAEg֘A
      m_pLayOutWork( 0 ),  
      m_ResID(  gfl::grp::g2d::LYTSYS_RESID_ERROR ),
      m_pUpperLayoutEnv( 0 ),
      m_pLowerLayoutEnv( 0 ),

      // poke
      m_pPokeModelSystem( 0 ),
      m_pPokeArray( 0 )
      {
        // JvOō쐬
        app::util::G3DUtil::CAMERA_CREATE_DATA dat[] =
        {
          {
            kCAMERA_DISTANCE,
            //   gfl::math::VEC3(0.0f,0.0f,-1.0f),
            gfl::math::VEC3(0.0f,0.0f,0.0f),
            1.0f,
            1000.0f,
            gfl::grp::g3d::StereoCamera::FOVY_RADIAN_DEFAULT,
            0.0f,
            gfl::grp::g3d::StereoCamera::DEPTH_LEVEL_DEFAULT,
            gfl::grp::g3d::StereoCamera::DEPTH_RANGE_DEFAULT,
            gfl::grp::g3d::StereoCamera::REAL_SWITCH_DEFAULT
          },
        };
        m_pG3dUtil->CreateG3dCamera( m_pHeap, app::util::G3DUtil::SETUP_CAMERA_LOWER, &dat[0], NULL );
        m_pG3dUtil->CalculateG3dScene();

        // |PfVXe쐬
        m_pPokeModelSystem = GFL_NEW(m_pHeap->pHeap) poke_tool::PokeModelSystem();  
        m_pPokeModelSystem->InitSystem(m_pHeap->pHeapAllocator, m_pHeap->pDevHeapAllocator, GFL_SINGLETON_INSTANCE(gamesystem::GameManager )->GetFileReadManager());

        //------------------------------------------------------------------------------
        // IuWFNg

        // |P
        {
          m_pPokeArray = GFL_NEW_ARRAY( m_pHeap->pHeap ) CPokemon[kTITLE_NUM_POKEMON];
          CPokemon* pSelect = &m_pPokeArray[0];
          u32 prevHeap(m_pHeap->pHeap->GetTotalFreeSize());
          u32 prevDevHeap(m_pHeap->pDevHeap->GetTotalFreeSize());

          for( u32 i = 0; i < kTITLE_NUM_POKEMON; i++, pSelect++ )
          {
            CPokemon::SETUP_PARAM setup;
            setup.pHeap = m_pHeap;
            setup.pScene =  m_pG3dUtil->GetScene();
            setup.pPokeModelSystem = m_pPokeModelSystem;

            setup.pos = kTITLE_POKEMON_DEF_POSITION + kTITLE_POKEMON_DISTANCE * i;
            pSelect->Init(&setup);

            //  GFL_PRINT( "HEAPID_IKUTA: 0x%x/0x%x, 0x%x/0x%x\n", 
            GFL_PRINT( "HEAPID_IKUTA: %d/%d, %d/%d\n", 
                m_pHeap->pHeap->GetTotalFreeSize(), m_pHeap->pHeap->GetTotalSize(),
                m_pHeap->pDevHeap->GetTotalFreeSize(), m_pHeap->pDevHeap->GetTotalSize() );

            GFL_PRINT( "- %d, - %d\n", prevHeap - m_pHeap->pHeap->GetTotalFreeSize(), 
                prevDevHeap - m_pHeap->pDevHeap->GetTotalFreeSize());

            prevHeap = m_pHeap->pHeap->GetTotalFreeSize();
            prevDevHeap = m_pHeap->pDevHeap->GetTotalFreeSize();
          }
        }

        //------------------------------------------------------------------------------
        // CAEg[N̍쐬
        static const gfl::grp::g2d::LytArcIndex kA_ANIME_ARC_INDEX[ kNUM_TITLE_ANIMATION ] =
        {
          LYTRES_IKUTA_TITLE_TITLE_SRIDE_BCLAN,  // Aj
          LYTRES_IKUTA_TITLE_TITLE_LOOP_BCLAN
        };

        static const gfl::grp::g2d::LytWkSetUp kLAYOUT_WORK_SETUP =
        {
          gfl::math::VEC3(0,0,0),   // pos
          gfl::math::VEC2(1,1),     // scale
          gfl::math::VEC3(0,0,0),   // rotate
          1,                        // priority
        };

        // \[Xǂݍ
        {
          gfl::fs::ArcFile* arc_file = GFL_NEW_LOW( m_pHeap->pHeap ) gfl::fs::ArcFile( m_pHeap->pHeap , L"rom:/ikuta_title.garc", gfl::fs::ArcFile::OPEN );
          m_ResID = m_pLayOutSystem->LoadLytRes( m_pHeap->pDevHeapAllocator, arc_file, 0 );
          GFL_DELETE arc_file;
        }

        // VRAMɃeNX`]
        m_pLayOutSystem->TransferAllTexture( m_ResID, gfl::grp::MEMORY_AREA_FCRAM );

        // CAEg[N𐶐
        m_pLayOutWork = m_pLayOutSystem->CreateLytWk( 
            m_ResID, 
            LYTRES_IKUTA_TITLE_TITLE_BCLYT, 
            &kA_ANIME_ARC_INDEX[0], 
            kNUM_TITLE_ANIMATION, 
            kNUM_TITLE_ANIMATION, 
            &kLAYOUT_WORK_SETUP, 
            false            
            );

        m_pLayOutWork->BindAnime( kTITLE_ANIMATION_UPDATE );
        m_pLayOutWork->SetAutoAnime( kTITLE_ANIMATION_UPDATE , true );
 //       m_pLayOutWork->SetAutoAnime( kTITLE_ANIMATION_LOOP , false );

#if 0
        // env
        const gfl::grp::ProjectionParam proj_param[2] =
        {
          // ʗp
          {
            gfl::grp::PROJECTION_PERSPECTIVE,
            { -200.0f, 200.0f, -120.0f, 120.0f },  // 200͉ʉ̔̃TCY, 120͉ʏc̔̃TCY
            35.0f,  //     0.10f,
            340.0f,  //     800.0f,
            gfl::math::PIVOT_UPSIDE_TO_TOP,
          },
          // ʗp
          {
            gfl::grp::PROJECTION_ORTHO,
            { -160.0f, 160.0f, -120.0f, 120.0f },  // 160͉ʉ̔̃TCY, 120͉ʏc̔̃TCY
            0.10f,
            800.0f,
            gfl::math::PIVOT_UPSIDE_TO_TOP,
          },
        };

        // CAEg[N̕`Ɏgpr[vZp[^ł.
        // ̎̂߂, ʂ͉EځEڂ2̃Jpӂ܂.
        const gfl::grp::ViewParam view_param[3] =
        {
          {	// ʁiځj
            gfl::math::VEC3(0,0,1),		// JW
            gfl::math::VEC3(0,1,0),		// 
            gfl::math::VEC3(0,0,0),		// ^[QbgW
          },
          {	// ʁiEځj
            gfl::math::VEC3(0,0,1),	// JW
            gfl::math::VEC3(0,1,0),		// 
            gfl::math::VEC3(0,0,0),	// ^[QbgW
          },
          // ʗp
          {
            gfl::math::VEC3(0,-290,1),  // JW( ʗp̃J, YW-290ɐݒu܂ )
            gfl::math::VEC3(0,1,0),     // 
            gfl::math::VEC3(0,-290,0),  // ^[QbgW
          },
        };

        // CAEg[N`悷邽߂̊, ʗpEʗp2pӂ܂.
        // ʗp
        m_pUpperLayoutEnv = GFL_NEW( m_pHeap->pHeap ) gfl::grp::g2d::Env();
        m_pUpperLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, proj_param[0], view_param[0] );  // ʏ`p
        m_pUpperLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, proj_param[0], view_param[1] );   // ̎`掞̉Eڗp
        // ʗp
        m_pLowerLayoutEnv = GFL_NEW( m_pHeap->pHeap ) gfl::grp::g2d::Env();
        m_pLowerLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, proj_param[1], view_param[2] );  // ʏ`p
        m_pLowerLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, proj_param[1], view_param[2] );   // ̎`掞̉Eڗp

        // `CAEg[NɊ֘At܂.
        m_pLayOutWork->SetUserEnv( m_pUpperLayoutEnv, m_pLowerLayoutEnv );
#endif
        //--------------------------------------------------------------------------------
        // ̑p[^
        m_State = kSTATE_LOAD;

      }

    //-------------------------------------------------------------------------------------
    // fXgN^
    //-------------------------------------------------------------------------------------
    CProcTitleTest::~CProcTitleTest( void )
    {
      // ō쐬̂j
      GFL_SAFE_DELETE_ARRAY( m_pPokeArray );

      GFL_SAFE_DELETE( m_pUpperLayoutEnv );
      GFL_SAFE_DELETE( m_pLowerLayoutEnv );

      if( m_pG3dUtil )
        m_pG3dUtil->DeleteG3dCamera();

      // CAEgVXeɃ\[X̉˗
      if( m_ResID != gfl::grp::g2d::LYTSYS_RESID_ERROR)
      {
        if( m_pLayOutSystem )     // Ö
          m_pLayOutSystem->ReleaseLytRes( m_ResID );

        m_ResID = gfl::grp::g2d::LYTSYS_RESID_ERROR;
      }

      if( m_pLayOutWork )
      {
        // UseEnv̊֘At(Ń|C^nullNA)
        m_pLayOutWork->SetGlobalEnv();

        GFL_SAFE_DELETE( m_pUpperLayoutEnv );
        GFL_SAFE_DELETE( m_pLowerLayoutEnv );

        if( m_pLayOutSystem )     // Öׂ
        {
          m_pLayOutSystem->RemoveLytWk( m_pLayOutWork );
        }
        m_pLayOutWork = 0;
      }

#if 0 
      // ʏϐ
      m_State = kSTATE_NULL;

      // ؂蕨null邾
      m_pUiDeviceManager = 0;

      // ō쐬̂j
      GFL_SAFE_DELETE( m_pText );
      GFL_SAFE_DELETE_ARRAY( m_pPokeArray );

      //	pPokeModel->RemoveScene( m_pG3dUtil->GetScene() );  // BoxPokeModel::RemoveScene(void)

      // VXe͏ԂɒӂȂ΂ȂH
      GFL_SAFE_DELETE( m_pPokeModelSystem );   
      GFL_SAFE_DELETE( m_pLayOutSystem );

      // Util̃fXgN^͋󔒂Ȃ̂Ŏŏ
      if( m_pG3dUtil )
      {
        // null`FbNĂȂ̂m_pG3dUtilĂ鎞AL̕CreateĂ鎖ۏႳĂȂƂȂB
        m_pG3dUtil->DeleteEdgeSystem();
        //  m_pG3dUtil->DeleteG3dLight();
        m_pG3dUtil->DeleteG3dCamera();
        m_pG3dUtil->DeleteG3dScene();
        m_pG3dUtil->DeleteG3dSystem();
        GFL_SAFE_DELETE( m_pG3dUtil );
      }

      // OtBbNVXe͎؂蕨AAP[^[蓖ĂĂ̂ŏ
      if( m_pGraphicsSystem )
      {
        m_pGraphicsSystem->FinalizeApplicationMemory();
        m_pGraphicsSystem = 0;
      }

      // q[vUtil̓fXgN^Ŗ薳
      GFL_SAFE_DELETE( m_pHeap );
#endif
    }


    //-------------------------------------------------------------------------------------
    // XV
    //-------------------------------------------------------------------------------------
    u32 CProcTitleTest::UpdateImpl( void )
    {
#if 1
      switch(m_State)
      {
      case kSTATE_LOAD:
#if 1
        bool next(true);
        CPokemon* pSelect = &m_pPokeArray[0];
        for( u32 i = 0; i < kTITLE_NUM_POKEMON; i++, pSelect++ )
        {
          pSelect->Update();

          // S̃[hI܂ő҂
          if(!pSelect->IsSettingEnd())
            next = false;
        }

        if(next)
        {
          m_State = kSTATE_UPDATE;
          CPokemon* pSelect = &m_pPokeArray[1];
          for( u32 i = 1; i < kTITLE_NUM_POKEMON; i++, pSelect++ )
          {
            pSelect->SetParent(m_pPokeArray);
          }
        }
#endif
        break;


      case kSTATE_UPDATE:
        {
          // ͑
          m_pPokeArray->ManualUpdate( m_pUiDeviceManager );

          CPokemon* pSelect = &m_pPokeArray[1];
          for( u32 i = 1; i < kTITLE_NUM_POKEMON; i++, pSelect++ )
          {
            pSelect->Update();
          }

          gfl::math::VEC3 cameraPos(m_pPokeArray->GetPosition());
          m_pG3dUtil->GetLowerCamera()->SetCameraAndTargetPosition(cameraPos + kTITLE_CAMERA_DISTANCE, cameraPos);

          // Aj[VIA[vԂɈڍs
          if( m_pLayOutWork->IsAnimeEnd( kTITLE_ANIMATION_UPDATE ) )
          {
            m_pLayOutWork->UnBindAnime( kTITLE_ANIMATION_UPDATE );
            m_pLayOutWork->SetAutoAnime( kTITLE_ANIMATION_UPDATE , false );

            m_pLayOutWork->BindAnime( kTITLE_ANIMATION_LOOP );
            m_pLayOutWork->SetAutoAnime( kTITLE_ANIMATION_LOOP , true );
            m_State = kSTATE_LOOP;
          }

        }


      case kSTATE_LOOP:
        {

        }
        break;    
      }
#endif
      // vĊmF
      m_pG3dUtil->CalculateG3dScene();
      m_pPokeModelSystem->UpdateSystem();
      m_pPokeModelSystem->UpdateModel();
      m_pPokeModelSystem->UpdateModelAnime();
      m_pG3dUtil->Update3D( false );

      // CAEg̍XV
      m_pLayOutSystem->UpdateAll();

      return 0;
    }


    //-------------------------------------------------------------------------------------
    // `揈
    //-------------------------------------------------------------------------------------
    void CProcTitleTest::DrawImpl( void )
    {
      gfl::grp::RenderTarget* upperFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER);
      gfl::grp::RenderTarget* rightFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER_RIGHT);
      gfl::grp::RenderTarget* lowerFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_LOWER);

      m_pLayOutSystem->DrawAll( m_pGraphicsSystem, gfl::grp::DISPLAY_UPPER, upperFrameBuffer, rightFrameBuffer );
      m_pLayOutSystem->DrawAll( m_pGraphicsSystem, gfl::grp::DISPLAY_LOWER, lowerFrameBuffer );

      m_pG3dUtil->Draw3D( m_pGraphicsSystem );
    }

  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG
