#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_Proc.cpp
 * @brief  eXgvZX
 * @author junya ikuta
 * @date   2012/05/01() 15:37
 */
/////////////////////////////////////////////////////////////////////////////////////// 

// Sys
#include <gflib.h>
#include <base/gfl_ProcManager.h>

// appSys
#include <system/main.h>
#include "gamesystem/GameProc.h"
#include "gamesystem/GameProcManager.h"
#include "dll/DllProc.h"

// app
#include "test_ikuta_CProc3DTest.h"
#include "test_ikuta_CText.h"                       // eLXg\NX
#include "test_ikuta_CPokemon.h"

// res
#include "ikuta_menu_lyt_res.h"
#include "ikuta_menu_lyt_res_pane.h"

#include "../../system/launcher_lyt.h"
#include "../../system/launcher_lyt_pane.h"

#include "message/debug_message.gaix"               // bZ[Warct@Cwb_[
#include "message/debug/msg_d_ikuta.h"              // gp郁bZ[W̃wb_[



namespace test {
  namespace ikuta {

    // 萔`

    const wchar_t* const              kFILEPATH_LAYOUT(L"rom:/ikuta_menu_lyt_res.garc");
    const gfl::grp::g2d::LytArcIndex  kARC_INDEX(LYTRES_IKUTA_MENU_LYT_RES_IKUTA_MENU_BCLYT);    
    const gfl::grp::g2d::LytPaneIndex kLAYOUT_TEXTBOX_PANE_INDEX(PANENAME_IKUTA_MENU_PANE_TEXTBOX_04);

    const wchar_t* const              kFILEPATH_MESSAGE(L"rom:/debug_message.garc");
    const u32                         kMESSAGE_ARC_INDEX(GARC_debug_message_d_ikuta_DAT);

    const u32                         kNUM_POKEMON(5);                              // 8OK

    const gfl::math::VEC3             kPOKEMON_DEF_POSITION(0.0f, 0.0f, 0.0f);        // ʒu
    const gfl::math::VEC3             kPOKEMON_DISTANCE(0.0f, 0.0f, 50.0f);
    const gfl::math::VEC3             kCAMERA_DISTANCE(0.0f, 500.0f, 500.0f);

    //-------------------------------------------------------------------------------------
    // RXgN^
    //-------------------------------------------------------------------------------------
    CProc3DTest::CProc3DTest(
        app::util::Heap*                pHeap,          
        gfl::ui::DeviceManager*         pUiDeviceManager,
        gfl::grp::GraphicsSystem*       pGraphicsSystem, 
        app::util::G3DUtil*             pG3dUtil,		     
        gfl::grp::g2d::LytSys*          pLayOutSystem, 
        gfl::math::Random*              pRandom,
        gamesystem::FrameMode*          pFrameMode
        ) :
      CBase( pHeap, pUiDeviceManager, pGraphicsSystem, pG3dUtil, pLayOutSystem, pRandom, pFrameMode),

      // ʏϐ
      m_State( kSTATE_NULL ),

      // IuWFNg
      m_pText( 0 ),

      // VXe

      // poke
      m_pPokeModelSystem( 0 ),
      m_pPokeArray( 0 )
      {

        // JvOō쐬
        app::util::G3DUtil::CAMERA_CREATE_DATA dat[] =
        {
          {
            kCAMERA_DISTANCE,
            //          gfl::math::VEC3(0.0f,0.0f,-1.0f),
            gfl::math::VEC3(0.0f,0.0f,0.0f),
            1.0f,
            1000.0f,
            gfl::grp::g3d::StereoCamera::FOVY_RADIAN_DEFAULT,
            0.0f,
            gfl::grp::g3d::StereoCamera::DEPTH_LEVEL_DEFAULT,
            gfl::grp::g3d::StereoCamera::DEPTH_RANGE_DEFAULT,
            gfl::grp::g3d::StereoCamera::REAL_SWITCH_DEFAULT
          },
        };
        m_pG3dUtil->CreateG3dCamera( m_pHeap, app::util::G3DUtil::SETUP_CAMERA_UPPER, &dat[0], NULL );
        m_pG3dUtil->CalculateG3dScene();


        // |PfVXe쐬
        m_pPokeModelSystem = GFL_NEW(m_pHeap->pHeap) poke_tool::PokeModelSystem();  
        m_pPokeModelSystem->InitSystem(m_pHeap->pHeapAllocator, m_pHeap->pDevHeapAllocator, GFL_SINGLETON_INSTANCE(gamesystem::GameManager )->GetFileReadManager());

        //------------------------------------------------------------------------------
        // IuWFNg

        // |P
        {
          m_pPokeArray = GFL_NEW_ARRAY( m_pHeap->pHeap ) CPokemon[kNUM_POKEMON];
          CPokemon* pSelect = &m_pPokeArray[0];
          u32 prevHeap(m_pHeap->pHeap->GetTotalFreeSize());
          u32 prevDevHeap(m_pHeap->pDevHeap->GetTotalFreeSize());

          for( u32 i = 0; i < kNUM_POKEMON; i++, pSelect++ )
          {
            CPokemon::SETUP_PARAM setup;
            setup.pHeap = m_pHeap;
            setup.pScene =  m_pG3dUtil->GetScene();
            setup.pPokeModelSystem = m_pPokeModelSystem;

            setup.pos = kPOKEMON_DEF_POSITION + kPOKEMON_DISTANCE * i;
            pSelect->Init(&setup);

            //  GFL_PRINT( "HEAPID_IKUTA: 0x%x/0x%x, 0x%x/0x%x\n", 
            GFL_PRINT( "HEAPID_IKUTA: %d/%d, %d/%d\n", 
                m_pHeap->pHeap->GetTotalFreeSize(), m_pHeap->pHeap->GetTotalSize(),
                m_pHeap->pDevHeap->GetTotalFreeSize(), m_pHeap->pDevHeap->GetTotalSize() );

            GFL_PRINT( "- %d, - %d\n", prevHeap - m_pHeap->pHeap->GetTotalFreeSize(), 
                prevDevHeap - m_pHeap->pDevHeap->GetTotalFreeSize());

            prevHeap = m_pHeap->pHeap->GetTotalFreeSize();
            prevDevHeap = m_pHeap->pDevHeap->GetTotalFreeSize();
          }
        }

        // 2DeLXg
        {
          m_pText = GFL_NEW( m_pHeap->pHeap ) CText();
          CText::SETUP_PARAM textSetUp;
          textSetUp.pHeap = m_pHeap;
          textSetUp.pGraphicsSystem = m_pGraphicsSystem;
          textSetUp.pLayOutSystem = m_pLayOutSystem;
          textSetUp.startMessageRabel = 0;
          textSetUp.pLayOutFilePath = kFILEPATH_LAYOUT;
          textSetUp.layOutArcIndex = kARC_INDEX;
          textSetUp.layOutTextBoxPaneIndex = kLAYOUT_TEXTBOX_PANE_INDEX;
          textSetUp.pMessageFilePath = kFILEPATH_MESSAGE;
          textSetUp.messageDatID = kMESSAGE_ARC_INDEX; 
          m_pText->Init(&textSetUp);
        }

        //--------------------------------------------------------------------------------
        // ̑p[^

        m_State = kSTATE_LOAD;



      }


    //-------------------------------------------------------------------------------------
    // fXgN^
    //-------------------------------------------------------------------------------------
    CProc3DTest::~CProc3DTest( void )
    {
      // ō쐬̂j
      GFL_SAFE_DELETE( m_pText );
      GFL_SAFE_DELETE_ARRAY( m_pPokeArray );

      if( m_pG3dUtil )
        m_pG3dUtil->DeleteG3dCamera();


#if 0 
      // ʏϐ
      m_State = kSTATE_NULL;

      // ؂蕨null邾
      m_pUiDeviceManager = 0;

      // ō쐬̂j
      GFL_SAFE_DELETE( m_pText );
      GFL_SAFE_DELETE_ARRAY( m_pPokeArray );

      //	pPokeModel->RemoveScene( m_pG3dUtil->GetScene() );  // BoxPokeModel::RemoveScene(void)

      // VXe͏ԂɒӂȂ΂ȂH
      GFL_SAFE_DELETE( m_pPokeModelSystem );   
      GFL_SAFE_DELETE( m_pLayOutSystem );

      // Util̃fXgN^͋󔒂Ȃ̂Ŏŏ
      if( m_pG3dUtil )
      {
        // null`FbNĂȂ̂m_pG3dUtilĂ鎞AL̕CreateĂ鎖ۏႳĂȂƂȂB
        m_pG3dUtil->DeleteEdgeSystem();
        //  m_pG3dUtil->DeleteG3dLight();
        m_pG3dUtil->DeleteG3dCamera();
        m_pG3dUtil->DeleteG3dScene();
        m_pG3dUtil->DeleteG3dSystem();
        GFL_SAFE_DELETE( m_pG3dUtil );
      }

      // OtBbNVXe͎؂蕨AAP[^[蓖ĂĂ̂ŏ
      if( m_pGraphicsSystem )
      {
        m_pGraphicsSystem->FinalizeApplicationMemory();
        m_pGraphicsSystem = 0;
      }

      // q[vUtil̓fXgN^Ŗ薳
      GFL_SAFE_DELETE( m_pHeap );
#endif
    }


    //-------------------------------------------------------------------------------------
    // XV
    //-------------------------------------------------------------------------------------
    u32 CProc3DTest::UpdateImpl( void )
    {
      switch(m_State)
      {
      case kSTATE_LOAD:
#if 1
        bool next(true);
        CPokemon* pSelect = &m_pPokeArray[0];
        for( u32 i = 0; i < kNUM_POKEMON; i++, pSelect++ )
        {
          pSelect->Update();

          // S̃[hI܂ő҂
          if(!pSelect->IsSettingEnd())
            next = false;
        }

        if(next)
        {
          m_State = kSTATE_3D_DRAW;
          CPokemon* pSelect = &m_pPokeArray[1];
          for( u32 i = 1; i < kNUM_POKEMON; i++, pSelect++ )
          {
            pSelect->SetParent(m_pPokeArray);
          }
        }
#endif
        break;


      case kSTATE_3D_DRAW:
        {
          // ͑
          m_pPokeArray->ManualUpdate( m_pUiDeviceManager );

          CPokemon* pSelect = &m_pPokeArray[1];
          for( u32 i = 1; i < kNUM_POKEMON; i++, pSelect++ )
          {
            pSelect->Update();
          }

          gfl::math::VEC3 cameraPos(m_pPokeArray->GetPosition());

          m_pG3dUtil->GetUpperCamera()->SetCameraAndTargetPosition(cameraPos + kCAMERA_DISTANCE, cameraPos);
        }
      }

      // vĊmF
      m_pG3dUtil->CalculateG3dScene();
      m_pPokeModelSystem->UpdateSystem();
      m_pPokeModelSystem->UpdateModel();
      m_pPokeModelSystem->UpdateModelAnime();
      m_pG3dUtil->Update3D( false );

      // CAEg̍XV
      m_pLayOutSystem->UpdateAll();

      return 0;
    }


    //-------------------------------------------------------------------------------------
    // `揈
    //-------------------------------------------------------------------------------------
    void CProc3DTest::DrawImpl( void )
    {
      gfl::grp::RenderTarget* upperFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER);
      gfl::grp::RenderTarget* rightFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER_RIGHT);
      gfl::grp::RenderTarget* lowerFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_LOWER);

      m_pLayOutSystem->DrawAll( m_pGraphicsSystem, gfl::grp::DISPLAY_UPPER, upperFrameBuffer, rightFrameBuffer );
      m_pLayOutSystem->DrawAll( m_pGraphicsSystem, gfl::grp::DISPLAY_LOWER, lowerFrameBuffer );

      m_pG3dUtil->Draw3D( m_pGraphicsSystem );
    }

  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG
