
#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_CPokemon.h
 * @brief  eXgp|P1CNX
 * @author junya ikuta
 * @date   2012/05/10() 11:48
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// VXe
#include <gfl_Base.h>
#include <gfl_UI.h>

// AvP[VVXe
#include "app/util/app_util_heap.h"
#include <poke_tool/poke_model_sys.h>


namespace test {
  namespace ikuta {

    class CPokemon 
    {
      GFL_FORBID_COPY_AND_ASSIGN( CPokemon );         // ?

      public:

      // p\
      struct SETUP_PARAM{
        gfl::math::VEC3             pos;                   // ʒu
        f32                         dir;                   // 

        MonsNo                      monsNo;
        pml::FormNo                 formNo;
        pml::Sex                    sex;


        poke_tool::PokeModelSystem*   pPokeModelSystem;       // 郂fVXe(؂蕨)
        gfl::grp::g3d::Scene*         pScene;                 // V[(؂蕨)
        app::util::Heap*              pHeap;                  // gpq[v(؂蕨)
        //         gfl::grp::GraphicsSystem*   pGraphicsSystem;        // gpOtBbNVXe(؂蕨)


        SETUP_PARAM() : pHeap( 0 ), pos(0.0f, 0.0f, 0.0f), dir(0.0f), monsNo(MONSNO_PIKATYUU), formNo(0), sex(pml::SEX_MALE),
        pPokeModelSystem( 0 ), pScene( 0 )
        {
        }
      };

      // NX̏
      enum STATE{
        kSTATE_NULL = 0,
        kSTATE_LOAD,        // fǂݍݒ
        kSTATE_WAIT,        // Ă
        kSTATE_MOVE,        // ړ
        kNUM_STATE
      };

      //------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       */
      //------------------------------------------------------------------------------
      CPokemon( void );

      //------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //------------------------------------------------------------------------------
      virtual ~CPokemon();

      //------------------------------------------------------------------------------
      /**
       * @brief 
       * @param pSetUp            ɕKvȃf[^\
       */
      //------------------------------------------------------------------------------
      bool Init(SETUP_PARAM* pSetUp);

      //------------------------------------------------------------------------------
      /**
       * @brief I
       */
      //------------------------------------------------------------------------------
      void Uninit( void );

      //------------------------------------------------------------------------------
      /**
       * @brief XV
       */
      //------------------------------------------------------------------------------
      STATE Update( void );

      //------------------------------------------------------------------------------
      /**
       * @brief lԑł̍XV
       */
      //------------------------------------------------------------------------------
      STATE ManualUpdate( gfl::ui::DeviceManager* pDevice );

      //------------------------------------------------------------------------------
      /**
       * @brief `揈
       */
      //------------------------------------------------------------------------------
      void Draw( void );

      //------------------------------------------------------------------------------
      /**
       * @brief W擾
       */
      //------------------------------------------------------------------------------
      const gfl::math::VEC3& GetPosition( void ) const;

      //------------------------------------------------------------------------------
      /**
       * @brief [hƃV[ݒ肪Ă邩
       */
      //------------------------------------------------------------------------------
      bool IsSettingEnd( void ) const;

      //------------------------------------------------------------------------------
      /**
       * @brief tĂeZbg
       */
      //------------------------------------------------------------------------------
      bool SetParent( CPokemon* pParent );

      protected:

      //------------------------------------------------------------------------------
      /**
       * @brief XV
       */
      //------------------------------------------------------------------------------
      STATE ImplUpdate( gfl::math::VEC3& rMove );

      //------------------------------------------------------------------------------
      /**
       * @brief f̃[h҂Đݒs֐Atruě͌Ă΂ȂH
       */
      //------------------------------------------------------------------------------
      bool PokeModelLoadWait();

      // p[^ϐ
      STATE                         m_State;              // ԕϐ
      CPokemon*                     m_pParent;            // tĂe

      // VXe
      app::util::Heap*              m_pHeap;              // gpq[v(؂蕨)
      gfl::grp::g3d::Scene*         m_pScene;             // V[(؂蕨)

      // |Pf֘A
      poke_tool::PokeModelSystem*     m_pPokeModelSystem; // gp郂fVXe(؂蕨)
      poke_tool::PokeModel*           m_pPokeModel;       // gp郂f(fVXe̎؂蕨)

    };
  } // namespace ikuta
} // namespace test 

#endif // PM_DEBUG

// EOF
