
#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_CPokemon.cpp
 * @brief  eXgp|P1CNX
 * @author junya ikuta
 * @date   2012/05/10() 12:22
 */
///////////////////////////////////////////////////////////////////////////////////////

#include "test_ikuta_CPokemon.h"


namespace test {
  namespace ikuta {

    const f32 kSTOP_DISTANCE(100.0f);                                      // Ă̂~܂鋗
    const f32 kSTOP_DISTANCE_SQUARE(kSTOP_DISTANCE * kSTOP_DISTANCE);     // 2
    const f32 kMOVE_SPEED_MANUAL(10.0f);
    const f32 kMOVE_SPEED(7.0f);
    const f32 kMOVE_SPEED_SQUARE(kMOVE_SPEED * kMOVE_SPEED);

    const f32 kSTICK_SKIP_LEVEL(0.003);                                               // ͈ƂȂAXeBbN̓(0.0f ` 1.0f)
    const f32 kSTICK_SKIP_LEVEL_SQUARE( kSTICK_SKIP_LEVEL * kSTICK_SKIP_LEVEL );

    //------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     */
    //------------------------------------------------------------------------------
    CPokemon::CPokemon( void ) :
      m_State( kSTATE_NULL ),     // ԕϐ
      m_pParent( 0 ),             // Ă

      // VXe
      m_pHeap( 0 ),               // gpq[v(؂蕨)
      m_pScene( 0 ),              // o^V[(؂蕨)

      // |Pf֘A
      m_pPokeModelSystem( 0 ),    // gp郂fVXe(؂蕨)
      m_pPokeModel( 0 )           // gp郂f(fVXe̎؂蕨)

      {


      }

    //------------------------------------------------------------------------------
    /**
     * @brief fXgN^
     */
    //------------------------------------------------------------------------------
    CPokemon::~CPokemon()
    {
      Uninit();
    }

    //------------------------------------------------------------------------------
    /**
     * @brief 
     * @param pSetUp            ɕKvȃf[^\
     */
    //------------------------------------------------------------------------------
    bool CPokemon::Init(SETUP_PARAM* pSetUp)
    {
      // nꂽ|C^L
      m_pHeap = pSetUp->pHeap;                            // gpq[v(؂蕨)      
      m_pPokeModelSystem = pSetUp->pPokeModelSystem;      // 郂fVXe(؂蕨)
      m_pScene = pSetUp->pScene;                          // V[(؂蕨)

      // |P̃fݒ
      poke_tool::PokeModel::SetupOption option;
      option.useShaderModel = true;
      //	option.isAsync = true;
    	option.anmType = poke_tool::MODEL_ANIME_TYPE_BATTLE;   // ogpƂ킢̃[V̕p͕s

      //	option.useDaeFaceAnime = false;  // @todo ً}̂false

      poke_tool::PokeModel::SimpleParam param = {
        pSetUp->monsNo,
        pSetUp->formNo,
        pSetUp->sex,      // 
        0,                // isRare?
        false,            // IsEgg
        0                 // pb`[pH
      };

      // f̐(̎_ł̓[h͊ĂȂH)
      m_pPokeModel = m_pPokeModelSystem->CreateModelSimple(
          &param,
          m_pHeap->pHeapAllocator,
          m_pHeap->pDevHeapAllocator,
          &option);

      // Wn͂̃^C~OŃZbgĂvH
      m_pPokeModel->SetPosition(&pSetUp->pos);
      m_pPokeModel->SetRotateY(pSetUp->dir);

      // ̑p[^[
      m_State = kSTATE_LOAD;

      return true;
    }

    //------------------------------------------------------------------------------
    /**
     * @brief I
     */
    //------------------------------------------------------------------------------
    void CPokemon::Uninit( void )
    {
      m_pParent = 0;
      m_State = kSTATE_NULL;
      m_pHeap = 0;

      // fV[ƃ|PfVXe痣E
      if( m_pPokeModel )
      {
        if( m_pScene && IsSettingEnd() ) 
        {
          m_pScene->SwitchEdgeMapModel( m_pPokeModel->GetG3dModel(), false );
          m_pPokeModel->RemoveScene( m_pScene );
        }

        if( m_pPokeModelSystem )
          m_pPokeModelSystem->DeleteModel( m_pPokeModel );

        m_pPokeModel = 0;
      }

      m_pPokeModelSystem = 0;
      m_pScene = 0;
    }

    //------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //------------------------------------------------------------------------------
    CPokemon::STATE CPokemon::Update( void )
    {
      gfl::math::VEC3 move(0.0f, 0.0f, 0.0f);
      //          move.Normalize();
      //        move *= kMOVE_SPEED;

      // eȂĂ
      if(m_pParent)
      {
        move = m_pParent->GetPosition() - GetPosition();
        
      
              // f32 distanceSq( move.LengthSquare() );
        f32 distance( move.Length() );

        // 
        if( distance != 0.0f )
          m_pPokeModel->SetRotateY( gfl::math::Atan2Rad(move.x, move.z) );
        
        // ۂ
        if( distance >= kSTOP_DISTANCE ) 
        {
          u32 moveSpeed(kMOVE_SPEED);
          
          // ̈ړŁA荞ł܂
          if( distance < kMOVE_SPEED )
          {
            moveSpeed = distance;
          }

          move.SafeNormalize(move);
          move *= moveSpeed;
        }
        else
          move = move.Zero();
      }

      switch( m_State )
      {
      case kSTATE_WAIT:
        // kMOVE_SPEED

        break;

      }

      return ImplUpdate(move);
    }

    //------------------------------------------------------------------------------
    /**
     * @brief lԑł̍XV
     */
    //------------------------------------------------------------------------------
    CPokemon::STATE CPokemon::ManualUpdate( gfl::ui::DeviceManager* pDevice )
    {
      // ͏񂩂ړ͂쐬
      gfl::ui::VectorDevice* pStick = pDevice->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
      gfl::math::VEC3 move(pStick->GetX(), 0.0f, - pStick->GetY());
     
      f32 distanceSq( move.LengthSquare() );
      if ( distanceSq <= kSTICK_SKIP_LEVEL_SQUARE )
      {
        // ͌덷͈͓
        move = move.Zero();
      }
      else
      {
        // 
        m_pPokeModel->SetRotateY( gfl::math::Atan2Rad(move.x, move.z) );
    
        // ړ͂̉H
        move.SafeNormalize(move);
        move *= kMOVE_SPEED_MANUAL;
      }

      switch( m_State )
      {
      case kSTATE_WAIT:
        // kMOVE_SPEED

        break;

      }

      return ImplUpdate(move);

    }

    //------------------------------------------------------------------------------
    /**
     * @brief `揈
     */
    //------------------------------------------------------------------------------
    void CPokemon::Draw( void )
    {
      // `͏wŃfVXes
    }


    //------------------------------------------------------------------------------
    /**
     * @brief W擾
     */
    //------------------------------------------------------------------------------
    const gfl::math::VEC3& CPokemon::GetPosition( void ) const
    {
      return m_pPokeModel->GetPosition();
    }

    //------------------------------------------------------------------------------
    /**
     * @brief [hƃV[ݒ肪Ă邩
     */
    //------------------------------------------------------------------------------
    bool CPokemon::IsSettingEnd( void ) const
    {
      return (m_State != kSTATE_NULL && m_State != kSTATE_LOAD);
    }


    //------------------------------------------------------------------------------
    /**
     * @brief tĂeZbg
     */
    //------------------------------------------------------------------------------
    bool CPokemon::SetParent( CPokemon* pParent )
    {
      m_pParent = pParent;
      return true;
    }


    // protected
    //------------------------------------------------------------------------------
    /**
     * @brief XV
     */
    //------------------------------------------------------------------------------
    CPokemon::STATE CPokemon::ImplUpdate( gfl::math::VEC3& rMove )
    {
 //     float moveSpeedSq( Move.LengthSquare() );

// ړȂĂdlɂȂ
#if 0
      // ړʂvZ
      if (moveSpeed != 0.0f) 
      {
         m_pPokeModel->SetRotateY( gfl::math::Atan2Rad(rMove.x, rMove.z) );
      }
#endif
      switch( m_State )
      {
      case kSTATE_LOAD:
        // [hݒ肪
        if(PokeModelLoadWait())
        {
          // V[Ɋ֘At
          m_pPokeModel->AddScene(m_pScene);
          m_pPokeModel->SetVisible(true);                                     // Öׂ
          m_pScene->SwitchEdgeMapModel(m_pPokeModel->GetG3dModel(), true);

          m_State = kSTATE_WAIT;
        }

        break;

      case kSTATE_WAIT:
        {

          //  m_pPokeModel->SetPosition(&( m_pPokeModel->GetPosition() + rMove ));

 //         if( moveSpeed != 0.0f )
          if( !rMove.IsZero() )
          {
            // ړ̊Jn
            m_State = kSTATE_MOVE;

            // Aj[V̕ύX
            m_pPokeModel->ChangeAnime( poke_tool::MODEL_ANIME_BT_WAIT_A );
            m_pPokeModel->PlayAnime();
   
            gfl::math::VEC3 pos(m_pPokeModel->GetPosition());
            pos = pos += rMove;
            m_pPokeModel->SetPosition(&pos);
          }
          else
          {
            // ҋ@s


          }
        }
        break;


        case kSTATE_MOVE:
        {

          if( rMove.IsZero() )
        //  if( moveSpeed == 0.0f )
          {
            // ړ̏I
            m_State = kSTATE_WAIT;

            // Aj[V̕ύX
            m_pPokeModel->ChangeAnime( poke_tool::MODEL_ANIME_APPEAL );
            m_pPokeModel->PlayAnime();
    
          }
          else
          {
            // ړs
            gfl::math::VEC3 pos(m_pPokeModel->GetPosition());
            pos = pos += rMove;
            m_pPokeModel->SetPosition(&pos);

m_pPokeModel->PlayAnime();
m_pPokeModel->PlayAnime();
m_pPokeModel->PlayAnime();

          }
        }
        break;

      }



      return m_State;
    }


    //------------------------------------------------------------------------------
    /**
     * @brief f̃[h҂Đݒs֐Atruě͌Ă΂ȂH
     */
    //------------------------------------------------------------------------------
    bool CPokemon::PokeModelLoadWait( void )
    {
      // ǂݍݑ҂
      if( m_pPokeModel->IsFinishLoad() == false ){
        return false;
      }

      m_pPokeModel->SetAdjustScaleType( poke_tool::POKE_ADJUST_STATUS );

      // [Vf[^ȂcH
      proj::motion::BaseMotionCharacter* motion_data = m_pPokeModel->GetMotionData();
      if( motion_data ) {
        motion_data->SetAttributeOn( proj::motion::Motion::M_ATTR_NO_IK );
      }


      //	pPokeModel->ChangeAnime( poke_tool::MODEL_ANIME_BT_WAIT_A );
      m_pPokeModel->ChangeAnime( poke_tool::MODEL_ANIME_APPEAL );
      m_pPokeModel->PlayAnime();
      //	pPokeModel->SetIsLoop( true );

      const f32 MODEL_COMMON_SCALE = 1.14f;
      m_pPokeModel->SetScale( MODEL_COMMON_SCALE );

      xy_system::PokemonShaderModel* shader_model = m_pPokeModel->GetShaderModel();
      shader_model->SetLightVec( gfl::math::VEC4(1, 0, 0, 1) );
      shader_model->SetLightColor( gfl::math::VEC4(1, 1, 1, 1) );
      return true; 
    }

  } // namespace ikuta
} // namespace test 

#endif // PM_DEBUG

// EOF
