#if PM_DEBUG

//========================================================================================
/**
 * @file   test_ikuta_Base.h
 * @brief  eXg̃x[X
 * @author junya ikuta
 * @date   2012/05/01() 19:26
 */
//========================================================================================
#pragma once
#include <gflib.h>
#include <math/gfl_MathRandom.h>
#include <gfl_UI.h>
#include <gfl_Base.h>
#include <gfl_Heap.h>
#include <gfl_UI.h>
#include <ui/gfl_UI_DeviceManager.h>
#include <gamesystem/GameProc.h>
#include <str/gfl_MsgData.h>
#include <math/gfl_MathRandom.h>
#include <poke_tool/poke_model_sys.h>
// appSys
#include "app/util/app_util_heap.h"
#include "app/util/app_util_3d.h"

namespace test {
  namespace ikuta {


    class CBase 
    {
      public:
        //--------------------------------------------------------------------------------
        /**
         * @brief RXgN^
         * @param pHeap             ̃vbNȉŎgpq[v 
         * @param pUiDeviceManager  ̃ubNȉŎgp͊Ǘ
         * @param pGraphicsSystem   ̃ubNȉŎgp`VXe匳
         * @param pG3dUtil		      ̃vbNȉŎgp3DVXeȈՃNX
         * @param pLayOutSystem     ̃vbNȉŎgp郌CAEgVXe
         * @param pRandom           ̃ubNȉŎgp郉_@
         * @param pFrameMode        ̃vbÑt[[g[h
         */
        //--------------------------------------------------------------------------------
        CBase( 
            app::util::Heap*                pHeap,          
            gfl::ui::DeviceManager*         pUiDeviceManager,
            gfl::grp::GraphicsSystem*       pGraphicsSystem, 
            app::util::G3DUtil*             pG3dUtil,		     
            gfl::grp::g2d::LytSys*          pLayOutSystem, 
            gfl::math::Random*              pRandom,
            gamesystem::FrameMode*          pFrameMode
            );

        //--------------------------------------------------------------------------------
        /**
         * @brief fXgN^
         */
        //--------------------------------------------------------------------------------
        virtual ~CBase( void );

        //--------------------------------------------------------------------------------
        /**
         * @brief XV
         */
        //--------------------------------------------------------------------------------
        u32 Update( void );

        //--------------------------------------------------------------------------------
        /**
         * @brief `揈
         */
        //--------------------------------------------------------------------------------
        void Draw( void );

        //--------------------------------------------------------------------------------
        /**
         * @breif Iǂ𒲂ׂ
         */
        //--------------------------------------------------------------------------------
        bool IsEnd( void ) const;


      protected:

        bool m_end_flag; // Iǂ

        // VXe֘A
        gfl::ui::DeviceManager*         m_pUiDeviceManager; // ̃vbNȉŎgp͊Ǘ
        gfl::grp::GraphicsSystem*       m_pGraphicsSystem;  // ̃vbNȉŎgp`VXe匳
        app::util::G3DUtil*             m_pG3dUtil;		      // ̃vbNȉŎgp3DVXeȈՃNX
        app::util::Heap*                m_pHeap;            // ̃vbNȉŎgpq[v 
        gfl::grp::g2d::LytSys*          m_pLayOutSystem;    // ̃vbNȉŎgp郌CAEgVXe
        gfl::math::Random*              m_pRandom;          // ̃vbNȉŎgp郉_@
        gamesystem::FrameMode*          m_pFrameMode;       // ̃vbÑt[[g[h

        // 
        gfl::ui::VectorDevice*          m_pCrosskey;
        gfl::ui::VectorDevice*          m_pStick;
        gfl::ui::Button*                m_pButton;
        gfl::ui::TouchPanel*            m_pTouchpanel;

        // eXgI
        void End( void );

      private:

        // eXg̃C
        virtual u32 UpdateImpl( void ) = 0;

        // eXg̕`揈
        virtual void DrawImpl( void );
    };


  } // namespace ikuta
} // namespace test


#endif // PM_DEBUG
