
#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CTitleCamera.cpp
 * @brief  [VlC~jQ[]^CgJ
 Aj[VĐ邾̃J
 * @author junya ikuta
 * @date  2012/05/25() 09:34 
 */
///////////////////////////////////////////////////////////////////////////////////////

// appSys

// app
#include "test_ikuta_game_CTitleCamera.h"        
#include "../resource/test_ikuta_game_resource_Camera.h"



namespace test {
  namespace ikuta {
    namespace game {


      //------------------------------------------------------------------
      /**
       * @name     CTitleCamera[RXgN^]
       * @brief    ϐ̏s
       */
      //------------------------------------------------------------------
      CTitleCamera::CTitleCamera( void ) : 
        m_State(STATE_NULL),
        m_StateEndFlag( false ),
        m_pRentalPtrSet( NULL ),
        m_pCamera( NULL ),
        m_pResAnimationArray( NULL ),
        m_ppBufAnimationArray( NULL ),
        m_ppAnimationArray( NULL )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name     ~CTitleCamera[fXgN^]
       * @brief    FinalizeĂяo
       */
      //------------------------------------------------------------------
      CTitleCamera::~CTitleCamera()
      {
        Finalize();
      }


      //------------------------------------------------------------------
      /**
       * @name      Initialize
       * @brief     A[hI܂ŊĂ܂B 
       * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
       * @pram      rSetUp      [const]
       * @return    true : 
       */
      //------------------------------------------------------------------
      bool CTitleCamera::Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp)
      {
        // `FbN


        // ܂؂蕨[
        m_pRentalPtrSet = GFL_NEW( rRentalPtr.pHeap->pHeap )RENTAL_PTR_SET;
        *m_pRentalPtrSet = rRentalPtr;



        // JƊꏉ̓[h


        // Aj[V\[X̍쐬
        m_pResAnimationArray = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Resource[TITLE_CAMERA_ANIMATION_MAX];
        m_ppBufAnimationArray = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) void* [TITLE_CAMERA_ANIMATION_MAX];
        m_ppAnimationArray = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::ResAnim* [TITLE_CAMERA_ANIMATION_MAX];

        //        gfl::grp::g3d::Resource* pSelect( m_pResAnimationArray );
        for( u32 i = 0; i < TITLE_CAMERA_ANIMATION_MAX; i++)
        {
          m_ppAnimationArray[i] = NULL;

          m_pRentalPtrSet->pFileReadManager->AddReadRequest(
              &m_ppBufAnimationArray[i],
              NULL,
              m_pRentalPtrSet->pHeap->pDevHeap,
              128,
              rSetUp.arcId,
              A_TITLE_CAMERA_ARCID_ANIMATION[i],
              true
              );
        }

        // [hԂɈڍs
        base::LoadStart();
        m_State = STATE_LOAD;
        m_StateEndFlag = false;
        return true;
      }

      //------------------------------------------------------------------
      /**
       * @name     Reset
       * @brief    p[^AInitializeɐ퓮AInitializȅԂɂȂ
       */
      //------------------------------------------------------------------
      void CTitleCamera::Reset( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name     Finalize
       * @brief    I
       */
      //------------------------------------------------------------------
      void CTitleCamera::Finalize( void )
      {
    
      }

      //------------------------------------------------------------------
      /**
       * @name      Update
       * @brief     XVA[hLoadUpdate𐄏
       * @return    ݂̏
       */
      //------------------------------------------------------------------
      CTitleCamera::STATE CTitleCamera::Update( void )
      {
        if( m_StateEndFlag )
          return m_State;

        switch( m_State )
        {
        case STATE_LOAD:
          LoadUpdate();
          break;

        case STATE_WAIT:              // ^Cgʑҋ@     

          break;
        
        case STATE_ENTER:             // 肪ꂽ
          if( m_pCamera->IsAnimationFrameEndFrame() )
          {
            m_StateEndFlag = true;
          }
          gfl::math::VEC3 pos;
          gfl::math::VEC3 pos2;

#if 0
          m_pCamera->GetTargetPosition(pos);
          m_pCamera->GetCameraPosition(pos2);
          GFL_PRINT("pos x:%f, y:%f, z:%f  ", pos2.x, pos2.y, pos2.z);
          GFL_PRINT("tpos x:%f, y:%f, z:%f\n", pos.x, pos.y, pos.z);
#endif
          break; 
        }

        return m_State;
      }

      //------------------------------------------------------------------
      /**
       * @name     LoadUpdate[virtual]
       * @brief    [hǂݐi߂鏃z֐A[hIŕKSetUpLoadAndSetupEnd()ĂԁB
       * @return   true : [hs
       */
      //------------------------------------------------------------------
      bool CTitleCamera::LoadUpdate(void)
      {

        if(m_State != STATE_LOAD)
          return false;

        bool endFlag(true);

        // Aj[V̓ǂݍ
        for( u32 i = 0; i < TITLE_CAMERA_ANIMATION_MAX; i++)
        {
          // ς
          if(m_ppAnimationArray[i])
            continue;

          // ǂݍݑ҂
          if( m_pRentalPtrSet->pFileReadManager->IsReadFinished(&m_ppBufAnimationArray[i]) )
          {
            gfl::grp::g3d::Resource::Description resource_description;
            // ǂݍ񂾂̂\[XɃA^b`
            m_pResAnimationArray[i].AttachBuffer( 
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                m_ppBufAnimationArray[i], 
                &resource_description, 
                true                      // buf̌n
                );
            m_ppBufAnimationArray[i] = NULL;

            // Aj[VIuWFNg̐
            if( m_pResAnimationArray[i].GetCameraAnimsCount() >= 0 )
            {
              m_ppAnimationArray[i] = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::ResAnim();
              m_pResAnimationArray[i].GetResAnim(
                gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_CAMERA,
                0,
                m_ppAnimationArray[i]
              );
            }
#if 0
            m_ppAnimationArray[i] = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::ResAnim();
            m_ppAnimationArray[i]->Create( 
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                &m_pResAnimationArray[i],
                0,
                gfl::grp::g3d::ResAnim::TYPE_CAMERA
                );
#endif
          }
          else 
          {
            endFlag = false;
          }
        }

        if( endFlag )
        {
          m_State = STATE_WAIT;
          base::LoadAndSetupEnd();

          // J
          m_pCamera = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::StereoCamera();
          gfl::grp::g3d::Camera::ResourceDescription des;
          des.animation_enable = true;

          m_pCamera->Create( 
              m_pRentalPtrSet->pHeap->pHeapAllocator, 
              m_pRentalPtrSet->pHeap->pDevHeapAllocator,
              &m_pResAnimationArray[0],
              0,
              &des
              );


          ChangeAnimation(TITLE_CAMERA_ANIMATION_ENTER, true, 0);


          // ꏉ
          CGameCameraBase::Initialize( m_pRentalPtrSet->pUtil, m_pCamera );

          return false;
        }

        return true;
      }


        //------------------------------------------------------------------
        /**
         * @name      Message
         * @brief     ÕbZ[W
         * @param     message     bZ[Wʎq
         * @return    true : K؂ɏꂽ
         */
        //------------------------------------------------------------------
        b32 CTitleCamera::Message(MESSAGE message)
        {
          switch( message )
          {
            case MESSAGE_SETUP_TITLE :        // ^CgJn̏ԂɃZbgAbv
            {
              m_State = STATE_WAIT;
              ChangeAnimation(TITLE_CAMERA_ANIMATION_WAIT, false, 0);
              m_StateEndFlag = false;
              break;
            }

            case MESSAGE_SETUP_TITLE_ENTER :  // ^CgŌ{^ꂽԂɃZbgAbv
            {
              m_State = STATE_ENTER;
              ChangeAnimation(TITLE_CAMERA_ANIMATION_ENTER, false, 0);
              m_StateEndFlag = false;
              break;
            }
          }

          return false;
        }


      // protected 

      //------------------------------------------------------------------
      /**
       * @name      ChangeAnimation
       * @brief     Aj[V̕ύX
       * @param     index       Aj[Vԍ
       * @param     loop        true [v[= false]
       * @param     changeCnt   OAj[VƂ̕ԃt[[= 0]
       */
      //------------------------------------------------------------------
      void CTitleCamera::ChangeAnimation( u32 index, b32 loop, u32 changeCnt)
      {
        m_pCamera->ChangeAnimation( 
            m_pRentalPtrSet->pHeap->pHeapAllocator, 
            m_ppAnimationArray[index], 
            changeCnt,       
            gfl::grp::g3d::ANIMATION_MAX_ANIM_MEMBERS_USE_MAX_MEMBERS 
            );

        m_pCamera->SetAnimationFrame(0);
        m_pCamera->SetAnimationLoop(loop);
      }


    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG


// EOF
