#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CProcTitle.cpp
 * @brief  [VlC~jQ[]^CgV[
 ̎dlƂāA\[Xׂ͂čŏɗpӂׁAIuWFNg͑Sďw̎؂蕨łB
 * @author junya ikuta
 * @date   2012/05/18() 09:52
 */
/////////////////////////////////////////////////////////////////////////////////////// 

// Sys

// appSys

// app
#include "test_ikuta_game_CProcTitle.h"
#include "../test_ikuta_game_CSkyBox.h"
#include "../test_ikuta_game_CPlayer.h"
#include "test_ikuta_game_CTitleCamera.h"

// res


namespace test {
  namespace ikuta {
    namespace game{

      // 萔`

      //-------------------------------------------------------------------------------------
      // RXgN^
      //-------------------------------------------------------------------------------------
      CProcTitle::CProcTitle(
          app::util::Heap*                pHeap,          
          gfl::ui::DeviceManager*         pUiDeviceManager,
          gfl::grp::GraphicsSystem*       pGraphicsSystem, 
          app::util::G3DUtil*             pG3dUtil,		     
          gfl::grp::g2d::LytSys*          pLayOutSystem, 
          gfl::math::Random*              pRandom,  
          gamesystem::FrameMode*          pFrameMode,
          const RENTAL_OBJ_PTR_SET&       rRentalObjPtrSet
          ) :
        // NX
        CBase( pHeap, pUiDeviceManager, pGraphicsSystem, pG3dUtil, pLayOutSystem, pRandom, pFrameMode),

        // ʏϐ
        m_State( STATE_NULL ),

        // IuWFNg
        m_pRentalObjPtrSet( NULL )
        {  

          // ܂؂蕨[
          m_pRentalObjPtrSet = GFL_NEW( m_pHeap->pHeap )RENTAL_OBJ_PTR_SET;
          *m_pRentalObjPtrSet = rRentalObjPtrSet;

          // eIuWFNgZbgAbv
          m_pRentalObjPtrSet->pTree->Message( CTree::MESSAGE_SETUP_TITLE );
          m_pRentalObjPtrSet->pTitleCamera->Message( CTitleCamera::MESSAGE_SETUP_TITLE );
        

          // eIuWFNgV[ɒǉ
          m_pRentalObjPtrSet->pTree->AddScene();
          m_pRentalObjPtrSet->pTitleCamera->SetMyself();
          m_pRentalObjPtrSet->pSkyBox->AddScene();
    
          // ̑p[^
          m_State = STATE_START;

        }

      //-------------------------------------------------------------------------------------
      // fXgN^
      //-------------------------------------------------------------------------------------
      CProcTitle::~CProcTitle( void )
      {
        if( !m_pRentalObjPtrSet )
          return;

        // eIuWFNgV[폜
        m_pRentalObjPtrSet->pTree->RemoveScene();
        m_pRentalObjPtrSet->pTitleCamera->RemoveMyself();
        m_pRentalObjPtrSet->pSkyBox->RemoveScene();

        if(m_State == STATE_ENTER)
          m_pRentalObjPtrSet->pPlayer->RemoveScene();
      }

      //-------------------------------------------------------------------------------------
      // XV
      //-------------------------------------------------------------------------------------
      u32 CProcTitle::UpdateImpl( void )
      {
        switch(m_State)
        {
        case STATE_START:
          {
            m_pRentalObjPtrSet->pTree->Update();
          //  m_pRentalObjPtrSet->pSkyBox->Update();
            m_pRentalObjPtrSet->pTitleCamera->Update();

            // c[̃Aj[VIҋ@ʂ
            if( m_pRentalObjPtrSet->pTree->IsStateEnd() )
            {
              // ҋ@Ԃ
              m_pRentalObjPtrSet->pTree->Message( CTree::MESSAGE_SETUP_TITLE_WAIT );


              m_State = STATE_PUSH_WAIT;
            }

            break;
          }
        case STATE_PUSH_WAIT:
          {
            m_pRentalObjPtrSet->pTree->Update();
          //  m_pRentalObjPtrSet->pSkyBox->Update();
            m_pRentalObjPtrSet->pTitleCamera->Update();

            // A{^Ŏ̒iK
            if( m_pButton->IsTrigger( gfl::ui::BUTTON_A ) ) 
            {
              m_pRentalObjPtrSet->pTree->Message( CTree::MESSAGE_SETUP_TITLE_ENTER );
              m_pRentalObjPtrSet->pTitleCamera->Message( CTitleCamera::MESSAGE_SETUP_TITLE_ENTER );
              m_State = STATE_ENTER;

              // vC[ǉ
              m_pRentalObjPtrSet->pPlayer->AddScene();
              m_pRentalObjPtrSet->pPlayer->Message( CPlayer::MESSAGE_SETUP_TITLE_ENTER );
            }

            break;
          }

        case STATE_ENTER:
          {
            m_pRentalObjPtrSet->pTree->Update();
          //  m_pRentalObjPtrSet->pSkyBox->Update();
            m_pRentalObjPtrSet->pTitleCamera->Update();

            if( m_pRentalObjPtrSet->pTree->IsStateEnd() )
            {
              // ʏvC
              return UPDATE_RESULT_ENTER_PLAY;
            }

            break;
          }
        }

        // 3DV[̍XV
        m_pG3dUtil->CalculateG3dScene();
        m_pG3dUtil->Update3D( false );

        return UPDATE_RESULT_CONTINUE;
      }


      //-------------------------------------------------------------------------------------
      // `揈
      //-------------------------------------------------------------------------------------
      void CProcTitle::DrawImpl( void )
      {
      //  m_pRentalObjPtrSet->pTree->Draw();
       // m_pRentalObjPtrSet->pSkyBox->Draw();
     //   m_pRentalObjPtrSet->pTitleCamera->Draw();


        m_pG3dUtil->Draw3D( m_pGraphicsSystem );
      }

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG
