

#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CTree.h
 * @brief  [VlC~jQ[]^CgŎg؂ƊŔ
            Ugłg
 * @author junya ikuta
 * @date  2012/05/25() 09:34 
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// appSys

// app
#include "test_ikuta_game_CResourceObjectBase.h"        


namespace test {
  namespace ikuta {
    namespace game {

      class CTree : public CResourceObjectBase
      {
        GFL_FORBID_COPY_AND_ASSIGN( CTree );                // ֎~

        typedef CResourceObjectBase base;

        public:

        enum STATE {
          STATE_NULL = 0,          // 
          STATE_LOAD,              // [h(LOAD_STATEƏdӁAKƂ)
          STATE_TITLE_START,       // ^CgJn
          STATE_TITLE_WAIT,        // ^Cgʑҋ@     
          STATE_TITLE_ENTER,       // 肪ꂽ
          STATE_TITLE_END,         // I
          NUM_STATE
        };

        enum MESSAGE {
          MESSAGE_SETUP_TITLE = 0,    // ^CgJn̏ԂɃZbgAbv
          MESSAGE_SETUP_TITLE_WAIT,   // ^Cg̑ҋ@ԂɃZbgAbv(JnԂ玩łȂĂcH)
          MESSAGE_SETUP_TITLE_ENTER,  // ^CgŌ{^ꂽԂɃZbgAbv
          
          MESSAGE_MAX
        };

        // e̎؂蕨
        struct RENTAL_PTR_SET{

          gfl::grp::g3d::Scene*         pScene;               // V[
          app::util::Heap*              pHeap;                // gpq[v        
          gfl::fs::FileReadManager*     pFileReadManager;     // 񓯊t@Cǂݍ

          RENTAL_PTR_SET() :
            pScene( NULL ),
            pHeap( NULL ),
            pFileReadManager( NULL )
          {
          }
        };

        // p\
        struct SETUP_PARAM{

          gfl::math::VEC3               pos;                  // ʒu
          f32                           dir;                  // 
          u32                           arcId;

          SETUP_PARAM() : 
            pos(0.0f, 0.0f, 0.0f), 
            dir(0.0f), 
            arcId(0)
          {
          }
        };

        //------------------------------------------------------------------
        /**
         * @name     CTree[RXgN^]
         * @brief    ϐ̏s
         */
        //------------------------------------------------------------------
        CTree( void );

        //------------------------------------------------------------------
        /**
         * @name     ~CTree[fXgN^]
         * @brief    FinalizeĂяo
         */
        //------------------------------------------------------------------
        virtual ~CTree();

        //------------------------------------------------------------------
        /**
         * @name      Initialize
         * @brief     A[hI܂ŊĂ܂B 
         * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
         * @pram      rSetUp      [const]
         * @return    true : 
         */
        //------------------------------------------------------------------
        bool Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp);

        //------------------------------------------------------------------
        /**
         * @name     Reset
         * @brief    p[^AInitializeɐ퓮AInitializȅԂɂȂ
         */
        //------------------------------------------------------------------
        void Reset( void );

        //------------------------------------------------------------------
        /**
         * @name     SetUpTitle
         * @brief    Initializeɐ퓮A^CgAj[V̊JnԂɂȂ
         */
        //------------------------------------------------------------------
        void SetUpTitle( void );
 
        //------------------------------------------------------------------
        /**
         * @name     Finalize
         * @brief    I
         */
        //------------------------------------------------------------------
        void Finalize( void );

        //------------------------------------------------------------------
        /**
         * @name      Update
         * @brief     XVA[hLoadUpdate𐄏
         * @return    ݂̏
         */
        //------------------------------------------------------------------
        STATE Update( void );

        //------------------------------------------------------------------
        /**
         * @name     LoadUpdate[virtual]
         * @brief    [hǂݐi߂鏃z֐A[hIŕKSetUpLoadAndSetupEnd()ĂԁB
         * @return   true : [hs
         */
        //------------------------------------------------------------------
        bool LoadUpdate(void);      
      
        //------------------------------------------------------------------
        /**
         * @name      AddScene
         * @brief     V[Ɏgǉ
         */
        //------------------------------------------------------------------
        void AddScene(void);      
      
        //------------------------------------------------------------------
        /**
         * @name      RemoveScene
         * @brief     V[玩g菜
         */
        //------------------------------------------------------------------
        void RemoveScene(void);      

        //------------------------------------------------------------------
        /**
         * @name      Message
         * @brief     ÕbZ[W
         * @param     message     bZ[Wʎq
         * @return    true : K؂ɏꂽ
         */
        //------------------------------------------------------------------
        b32 Message(MESSAGE message);     


        b32 IsStateEnd( void ) const
        {
          return m_StateEndFlag;
        } 

      protected:

        //------------------------------------------------------------------
        /**
         * @name      ChangeAnimation
         * @brief     Aj[V̕ύX
         * @param     index       Aj[Vԍ
         * @param     loop        true [v[= false]
         * @param     changeCnt   OAj[VƂ̕ԃt[[= 0]
         */
        //------------------------------------------------------------------
        void ChangeAnimation( u32 index, b32 loop = false, u32 changeCnt = 0 );

        // ʏϐ
        STATE                           m_State;              // ԕϐ
        b32                             m_StateEndFlag;       // true L̏Ԃłׂ͏IĂ
        gfl::math::VEC3                 m_Pos;
        f32                             m_Dir;

        // VXe
        RENTAL_PTR_SET*                 m_pRentalPtrSet;          // w̎؂蕨̕ۊ


        // \[X֘A
        gfl::grp::g3d::Model*           m_pModel;          // f
        gfl::grp::g3d::Resource*        m_pModelRes;       // f\[X
        void*                           m_pBuf;            // 񓯊ǂݍݗpobt@|C^ 
       
        gfl::grp::g3d::Resource*        m_pResAnimationArray;    // Aj[V\[X(z)
        void**                          m_ppBufAnimationArray;   // 񓯊ǂݍݗpobt@|C^(z)
        gfl::grp::g3d::ResAnim**        m_ppAnimationArray;      // Aj[VzAς݂nullŔfׂɃ^u|C^

      };

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG


// EOF
