

#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CTree.cpp
 * @brief  [VlC~jQ[]^CgŎg؂ƊŔ
 Ugłg
 * @author junya ikuta
 * @date  2012/05/25() 09:34 
 */
///////////////////////////////////////////////////////////////////////////////////////

// appSys
#include "test_ikuta_game_Common.h"
#include "resource/test_ikuta_game_resource_Tree.h"

// app
#include "test_ikuta_game_CTree.h"        


namespace test {
  namespace ikuta {
    namespace game {


      //------------------------------------------------------------------
      /**
       * @name     CTree[RXgN^]
       * @brief    ϐ̏s
       */
      //------------------------------------------------------------------
      CTree::CTree( void ) : 
        m_State( STATE_NULL ),
m_StateEndFlag( false ),
        m_Pos( 0.0f, 0.0f, 0.0f),
        m_Dir( 0.0f ),
        m_pRentalPtrSet( NULL ),
        m_pModel( NULL ),
        m_pModelRes( NULL ),
        m_pBuf( NULL ),
        m_pResAnimationArray( NULL ),
        m_ppBufAnimationArray( NULL ),
        m_ppAnimationArray( NULL )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name     ~CTree[fXgN^]
       * @brief    FinalizeĂяo
       */
      //------------------------------------------------------------------
      CTree::~CTree()
      {
        Finalize();
      }

      //------------------------------------------------------------------
      /**
       * @name      Initialize
       * @brief     A[hI܂ŊĂ܂B 
       * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
       * @pram      rSetUp      [const]
       * @return    true : 
       */
      //------------------------------------------------------------------
      bool CTree::Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp)
      {
        // `FbN
        //   GFL_ASSERT
        //  rRentalPtr.

        // ܂؂蕨[
        m_pRentalPtrSet = GFL_NEW( rRentalPtr.pHeap->pHeap )RENTAL_PTR_SET;
        *m_pRentalPtrSet = rRentalPtr;

        // f̐(̎_ł̓[hĂȂ)
        m_pModel = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Model();
        //     m_pModelRes = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Resource();

        // 񓯊\[X̓ǂݍ
        m_pRentalPtrSet->pFileReadManager->AddReadRequest(
            &m_pBuf,
            NULL,
            m_pRentalPtrSet->pHeap->pDevHeap,
            128,
            rSetUp.arcId,
            TREE_ARCID_MODEL,
            true
            );

        // Aj[V\[X̍쐬
        m_pResAnimationArray = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Resource[TREE_ANIMATION_MAX];
        m_ppBufAnimationArray = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) void* [TREE_ANIMATION_MAX];
        m_ppAnimationArray = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::ResAnim* [TREE_ANIMATION_MAX];

        //        gfl::grp::g3d::Resource* pSelect( m_pResAnimationArray );
        for( u32 i = 0; i < TREE_ANIMATION_MAX; i++)
        {
          m_ppAnimationArray[i] = NULL;

          m_pRentalPtrSet->pFileReadManager->AddReadRequest(
              &m_ppBufAnimationArray[i],
              NULL,
              m_pRentalPtrSet->pHeap->pDevHeap,
              128,
              rSetUp.arcId,
              A_TREE_ARCID_ANIMATION[i],
              true
              );
        }


        // [hԂɈڍs
        base::LoadStart();
        m_State = STATE_LOAD;
m_StateEndFlag = false;

        m_Pos = rSetUp.pos;
        m_Dir = rSetUp.dir;

        return true;
      }

      //------------------------------------------------------------------
      /**
       * @name     Reset
       * @brief    p[^AInitializeɐ퓮AInitializȅԂɂȂ
       */
      //------------------------------------------------------------------
      void CTree::Reset( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name     SetUpTitle
       * @brief    Initializeɐ퓮A^CgAj[V̊JnԂɂȂ
       */
      //------------------------------------------------------------------
      void CTree::SetUpTitle( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name     Finalize
       * @brief    I
       */
      //------------------------------------------------------------------
      void CTree::Finalize( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name      Update
       * @brief     XVA[hLoadUpdate𐄏
       * @return    ݂̏
       */
      //------------------------------------------------------------------
      CTree::STATE CTree::Update( void )
      {
        if( m_StateEndFlag )
          return m_State;

        switch( m_State )
        {
        case STATE_LOAD:
          LoadUpdate();
          break;

        case STATE_TITLE_START:       // ^CgJn
          if( m_pModel->IsAnimationFrameEndFrame() )
          {
            m_StateEndFlag = true;
          }
          break;
        case STATE_TITLE_WAIT:        // ^Cgʑҋ@     
        
          break;
        case STATE_TITLE_ENTER:       // 肪ꂽ 
          if( m_pModel->IsAnimationFrameEndFrame() )
          {
            m_StateEndFlag = true;
          }
          break;
        case STATE_TITLE_END:         // I

          break;
        }

        return m_State;
      }

      //------------------------------------------------------------------
      /**
       * @name     LoadUpdate[virtual]
       * @brief    [hǂݐi߂鏃z֐A[hIŕKSetUpLoadAndSetupEnd()ĂԁB
       * @return   true : [hs
       */
      //------------------------------------------------------------------
      bool CTree::LoadUpdate(void)
      {
        if(m_State != STATE_LOAD)
          return false;

        bool endFlag(true);

        // Aj[V̓ǂݍ
        for( u32 i = 0; i < TREE_ANIMATION_MAX; i++)
        {
          // ς
          if(m_ppAnimationArray[i])
            continue;

          // ǂݍݑ҂
          if( m_pRentalPtrSet->pFileReadManager->IsReadFinished(&m_ppBufAnimationArray[i]) )
          {
            gfl::grp::g3d::Resource::Description resource_description;
            // ǂݍ񂾂̂\[XɃA^b`
            m_pResAnimationArray[i].AttachBuffer( 
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                m_ppBufAnimationArray[i], 
                &resource_description, 
                true                      // buf̌n
                );
            m_ppBufAnimationArray[i] = NULL;

            // Aj[VIuWFNg̐
            m_ppAnimationArray[i] = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::ResAnim();
            m_ppAnimationArray[i]->Create( 
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                &m_pResAnimationArray[i],
                0,
                gfl::grp::g3d::ResAnim::TYPE_SKELETAL
                );
          }
          else 
          {
            endFlag = false;
          }
        }


        // f̓ǂݍ
        if( !m_pModelRes )
        {
          // ǂݍ݂҂
          if( m_pRentalPtrSet->pFileReadManager->IsReadFinished(&m_pBuf) )
          {

            m_pModelRes = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Resource();

            // ftHgVF[_[gp            
            gfl::grp::g3d::Resource::Description resource_description;
            u32 common_resource_flag = gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE;
            common_resource_flag |= gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT;

            // ǂݍ񂾂̂\[XɃA^b`
            m_pModelRes->AttachBuffer( 
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                m_pBuf, 
                &resource_description, 
                true                      // buf̌n
                );
            m_pModelRes->Setup( m_pRentalPtrSet->pHeap->pDevHeapAllocator , NULL, common_resource_flag);
            m_pBuf = NULL;

            // f
            gfl::grp::g3d::Model::Description desc;
            desc.animation_slot_num = 1;                               // Aj[VXbgKvmۂ

            m_pModel->Create( 
                m_pRentalPtrSet->pHeap->pHeapAllocator, 
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                m_pModelRes, 
                0,
                &desc
                );


            m_pModel->SetModelLayerId( MODEL_LAYER_ID_TREE );         // ɕ`

          }
          else
          {
            endFlag = false;
          }
        }

        if( endFlag )
        {
          m_State = STATE_TITLE_ENTER;
          base::LoadAndSetupEnd();

          ChangeAnimation(TREE_ANIMATION_TITLE_ENTER, true, 0);
          return false;
        }


        return true;
      }


      //------------------------------------------------------------------
      /**
       * @name      AddScene
       * @brief     V[Ɏgǉ
       */
      //------------------------------------------------------------------
      void CTree::AddScene(void)
      {
        m_pRentalPtrSet->pScene->AddSceneNode( m_pModel );
      }

      //------------------------------------------------------------------
      /**
       * @name      RemoveScene
       * @brief     V[玩g菜
       */
      //------------------------------------------------------------------
      void CTree::RemoveScene(void)
      {
        m_pRentalPtrSet->pScene->RemoveSceneNode( m_pModel );
      }

        //------------------------------------------------------------------
        /**
         * @name      Message
         * @brief     ÕbZ[W
         * @param     message     bZ[Wʎq
         * @return    true : K؂ɏꂽ
         */
        //------------------------------------------------------------------
        b32 CTree::Message(MESSAGE message)
        {
          switch( message )
          {
            case MESSAGE_SETUP_TITLE :        // ^CgJn̏ԂɃZbgAbv
            {
              m_State = STATE_TITLE_START;
              ChangeAnimation(TREE_ANIMATION_TITLE_START, false, 0);
              m_StateEndFlag = false;
              break;
            }

            case MESSAGE_SETUP_TITLE_WAIT :   // ^Cg̑ҋ@ԂɃZbgAbv(JnԂ玩łȂĂcH)
            {
              m_State = STATE_TITLE_WAIT;
              ChangeAnimation(TREE_ANIMATION_TITLE_WAIT, true, 0);
              m_StateEndFlag = false;
              break;
            }

            case MESSAGE_SETUP_TITLE_ENTER :  // ^CgŌ{^ꂽԂɃZbgAbv
            {
              m_State = STATE_TITLE_ENTER;
              ChangeAnimation(TREE_ANIMATION_TITLE_ENTER, false, 0);
              m_StateEndFlag = false;
              break;
            }
          }

          return false;
        }



      //  protected:

      //------------------------------------------------------------------
      /**
       * @name      ChangeAnimation
       * @brief     Aj[V̕ύX
       * @param     index       Aj[Vԍ
       * @param     loop        true [v[= false]
       * @param     changeCnt   OAj[VƂ̕ԃt[[= 0]
       */
      //------------------------------------------------------------------
      void CTree::ChangeAnimation( u32 index, b32 loop, u32 changeCnt)
      {
        m_pModel->ChangeAnimation( 
            m_pRentalPtrSet->pHeap->pHeapAllocator, 
            m_ppAnimationArray[index], 
            changeCnt, 
            0 
            );

        m_pModel->SetAnimationFrame(0, 0);
        m_pModel->SetAnimationLoop(loop, 0);
      }

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG


// EOF
