
#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CSkyBox.h
 * @brief  [VlC~jQ[]XJC{bNX
 * @author junya ikuta
 * @date   2012/05/23() 17:21
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

//#define USE_XY_SKYBOX_SYSTEM      // `:xy_system̃XJC{bNXgp@RgAEg:ʏ̃f`

// sys
#include <gfl_Macros.h>
#include <fs/gfl_FileReadManager.h>

// appSys
#ifdef USE_XY_SKYBOX_SYSTEM
#include "system/skybox/Skybox.h"
#else
#include <grp/g3d/gfl_G3dModel.h>
#endif 

// app
#include "test_ikuta_game_CResourceObjectBase.h"

namespace test {
  namespace ikuta {
    namespace game {
    
      class CGameCamera;

      class CSkyBox : public CResourceObjectBase
      {
        GFL_FORBID_COPY_AND_ASSIGN( CSkyBox );                // ֎~
        typedef CResourceObjectBase base;     

        public:

        enum STATE {
          STATE_NULL = 0,  // 
          STATE_LOAD,      // [h(LOAD_STATEƏdӁAKƂ)
          STATE_UPDATE,    // ʏXV
          NUM_STATE
        };

        // e̎؂蕨
        struct RENTAL_PTR_SET{

          gfl::grp::g3d::Scene*         pScene;               // V[
          app::util::Heap*              pHeap;                // gpq[v        
          gfl::fs::FileReadManager*     pFileReadManager;     // 񓯊t@Cǂݍ
          CGameCamera*                  pGameCamera;          // Q[ŎgpĂJ

          RENTAL_PTR_SET() :
            pScene( NULL ),
            pHeap( NULL ),
            pFileReadManager( NULL ),
            pGameCamera( NULL )
          {
          }

        };


        // p\
        struct SETUP_PARAM{

          gfl::math::VEC3               pos;                  // ʒu
          f32                           dir;                  // 
          f32                           rotSpeed;             // ]x
          u32                           arcId;                // gpA[Nt@CID

          SETUP_PARAM() : 
            pos(0.0f, 0.0f, 0.0f), 
            dir(0.0f), 
            rotSpeed( 0.0f ),
            arcId( 0 )
          {
          }

        };


        //------------------------------------------------------------------
        /**
         * @name      CSkyBox[RXgN^]
         * @brief     ϐ̏s
         */
        //------------------------------------------------------------------
        CSkyBox( void );

        //------------------------------------------------------------------
        /**
         * @name      ~CSkyBox[fXgN^]
         * @brief     Finalize()Ăяo
         */
        //------------------------------------------------------------------
        virtual ~CSkyBox( void );

        //------------------------------------------------------------------
        /**
         * @name      Initialize
         * @brief     A[hI܂ŊĂ܂B 
         * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
         * @pram      rSetUp      [const,default]
         * @return    true : [hԂɓ
         */
        //------------------------------------------------------------------
        bool Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp);

        //------------------------------------------------------------------
        /**
         * @name     Finalize
         * @brief    I
         */
        //------------------------------------------------------------------
        void Finalize( void );

        //------------------------------------------------------------------
        /**
         * @name      Update
         * @brief     XVA[hLoadUpdate𐄏
         * @return    ݂̏
         */
        //------------------------------------------------------------------
        STATE Update( void );

        //------------------------------------------------------------------
        /**
         * @name     LoadUpdate[virtual]
         * @brief    [hǂݐi߂鏃z֐A[hIŕKSetUpLoadAndSetupEnd()ĂԁB
         * @return   true : [hs
         */
        //------------------------------------------------------------------
        bool LoadUpdate(void);      

        //------------------------------------------------------------------
        /**
         * @name      Draw
         * @brief     `揈A܂B
         */
        //------------------------------------------------------------------
        void Draw( void );

        //------------------------------------------------------------------
        /**
         * @name      Enable
         * @brief     \A\̐؂ւ[default]
         */
        //------------------------------------------------------------------
        void DrawEnable( b32 flag = true );

        //------------------------------------------------------------------
        /**
         * @name      IsDraw[const]
         * @brief     \A\̏Ԏ擾
         * @return    true : \
         */
        //------------------------------------------------------------------
        b32 IsDraw( void ) const;

        //------------------------------------------------------------------
        /**
         * @name      AddScene
         * @brief     V[Ɏgǉ
         */
        //------------------------------------------------------------------
        void AddScene(void);      
      
        //------------------------------------------------------------------
        /**
         * @name      RemoveScene
         * @brief     V[玩g菜
         */
        //------------------------------------------------------------------
        void RemoveScene(void);      

   //     static const SETUP_PARAM DEF_SETUP_PARAM;

        protected:

        // ʏϐ
        STATE                           m_State;              // ԕϐ
        b32                             m_HideFlag;           // true = \

        // VXe
        RENTAL_PTR_SET*                 m_pRentalPtrSet;      // w̎؂蕨̕ۊ

        // IuWFNg
        #ifdef USE_XY_SKYBOX_SYSTEM
        xy_system::skybox::Skybox*      m_pSkybox;            // XJC{bNX
        #else
        gfl::grp::g3d::Model*           m_pSkyModel;          // XJC{bNX̃f
        gfl::grp::g3d::Resource*        m_pSkyModelRes;       // XJC{bNX̃f\[X
        void*                           m_pBuf;               // 񓯊ǂݍݗpobt@|C^ 
        #endif
        private:
      };

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG

// EOF
