
#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CSkyBox.cpp
 * @brief  [VlC~jQ[]XJC{bNX
 * @author junya ikuta
 * @date   2012/05/23() 17:21
 */
///////////////////////////////////////////////////////////////////////////////////////

// sys

// appSys
#include "test_ikuta_game_Common.h"

// app
#include "test_ikuta_game_CSkyBox.h"        // parent
#include "test_ikuta_game_CGameCamera.h"

// res
#include "arc_def.h"
#include "ikuta_game.gaix"

namespace test {
  namespace ikuta {
    namespace game {

      const u32 ARC_DATID_SKY_BOX(GARC_ikuta_game_skybox_BCMDL_LZ);

      //------------------------------------------------------------------
      /**
       * @name      CSkyBox[RXgN^]
       * @brief     ϐ̏s
       */
      //------------------------------------------------------------------
      CSkyBox::CSkyBox( void ) : 
        m_State( STATE_NULL ),
        m_pRentalPtrSet( 0 ),
#ifdef USE_XY_SKYBOX_SYSTEM      
        m_pSkybox( 0 )
#else 
          m_pSkyModel( 0 ),
        m_pSkyModelRes( 0 ),
        m_pBuf( 0 )
#endif
        {

        }

      //------------------------------------------------------------------
      /**
       * @name      ~CSkyBox[fXgN^]
       * @brief     Finalize()Ăяo
       */
      //------------------------------------------------------------------
      CSkyBox::~CSkyBox( void )
      {
        Finalize();
      }

      //------------------------------------------------------------------
      /**
       * @name      Initialize
       * @brief     A[hI܂ŊĂ܂B 
       * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
       * @pram      rSetUp      [const,default]
       * @return    true : [hԂɓ
       */
      //------------------------------------------------------------------
      bool CSkyBox::Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp )
      {
        // `FbN
        //   GFL_ASSERT
        //  rRentalPtr.

        // ܂؂蕨[
        m_pRentalPtrSet = GFL_NEW( rRentalPtr.pHeap->pHeap )RENTAL_PTR_SET;
        *m_pRentalPtrSet = rRentalPtr;

#ifdef USE_XY_SKYBOX_SYSTEM
        // XJC{bNX̐(̎_ł̓[hĂȂ)
        m_pSkybox = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) xy_system::skybox::Skybox;
        m_pSkybox->StartCreation(
            m_pRentalPtrSet->pHeap->pHeap,
            m_pRentalPtrSet->pHeap->pDevHeap,
            gamesystem::PMSeason::SUMMER
            );
#else
        // f
        m_pSkyModel = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Model();
        m_pSkyModelRes = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Resource();

        // 񓯊\[X̓ǂݍ
        m_pRentalPtrSet->pFileReadManager->AddReadRequest(
            &m_pBuf,
            NULL,
            m_pRentalPtrSet->pHeap->pDevHeap,
            128,
            rSetUp.arcId,
            ARC_DATID_SKY_BOX,
            true
            );

#endif

        // [hԂɈڍs
        base::LoadStart();
        m_State = STATE_LOAD;
        m_HideFlag = true;

        return true;
      }


      //------------------------------------------------------------------
      /**
       * @name     Finalize
       * @brief    I
       */
      //------------------------------------------------------------------
      void CSkyBox::Finalize( void )
      {
        // I͏ԂɂĕωAƂ肠̓[ĥ̂

#ifdef USE_XY_SKYBOX_SYSTEM
        // V[痣E
        m_pSkybox->RemoveFromScene( m_pRentalPtrSet->pScene );
        GFL_SAFE_DELETE( m_pSkybox );
#endif
        GFL_SAFE_DELETE ( m_pRentalPtrSet );
        m_State = STATE_NULL;

        base::Reset();
      }

      //------------------------------------------------------------------
      /**
       * @name      Update
       * @brief     XVA[hLoadUpdate𐄏
       * @return    ݂̏
       */
      //------------------------------------------------------------------
      CSkyBox::STATE CSkyBox::Update( void )
      {
        switch( m_State )
        {
        case STATE_LOAD:
          LoadUpdate();
          break;

        case STATE_UPDATE:

          // XJC{bNX̒SJW
#ifdef USE_XY_SKYBOX_SYSTEM

#else
          gfl::math::VEC3 pos;
          m_pRentalPtrSet->pGameCamera->GetCameraPosition(&pos);
          m_pSkyModel->SetTranslate(pos);

#endif

          break;

        }


        return m_State;
      }

      //------------------------------------------------------------------
      /**
       * @name     LoadUpdate[virtual]
       * @brief    [hǂݐi߂鏃z֐A[hIŕKSetUpLoadAndSetupEnd()ĂԁB
       * @return   true : [hs
       */
      //------------------------------------------------------------------
      bool CSkyBox::LoadUpdate(void)
      {
        // G[`FbN
        if(m_State != STATE_LOAD)
          return false;

#ifdef USE_XY_SKYBOX_SYSTEM
        // XV
        if( m_pSkybox->UpdateCreation() )
        {
          // V[ɓo^AԂڍs
          m_pSkybox->AddToScene(
              m_pRentalPtrSet->pScene,
              0,
              0,
              0,
              0,
              0
              );

          m_State = STATE_UPDATE;
          base::LoadAndSetupEnd();

          return false;
        }

#else
        // ǂݍ݂҂
        if( m_pRentalPtrSet->pFileReadManager->IsReadFinished(&m_pBuf) )
        {
          // ftHgVF[_[gp            
          gfl::grp::g3d::Resource::Description resource_description;
          u32 common_resource_flag = gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE;
          common_resource_flag |= gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT;

          // ǂݍ񂾂̂\[XɃA^b`
          m_pSkyModelRes->AttachBuffer( 
              m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
              m_pBuf, 
              &resource_description, 
              true                      // buf̌n
              );
          m_pSkyModelRes->Setup( m_pRentalPtrSet->pHeap->pDevHeapAllocator , NULL, common_resource_flag);
          m_pBuf = NULL;

          // f
          gfl::grp::g3d::Model::Description desc;
          desc.animation_slot_num = 3;                               // Aj[VXbgKvmۂ

          m_pSkyModel->Create( 
              m_pRentalPtrSet->pHeap->pHeapAllocator, 
              m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
              m_pSkyModelRes, 
              0);

          m_pSkyModel->SetModelLayerId( MODEL_LAYER_ID_SKYBOX );     // Kŏɕ`
          s32 numMaterial( m_pSkyModel->GetMaterialCount() );
          for(s32 i = 0; i < numMaterial; i++)
            m_pSkyModel->SetMaterialDepthTestMaskEnable(i, false);  // [xl͏܂Ȃ
         // m_pRentalPtrSet->pScene->AddSceneNode( m_pSkyModel );

          m_State = STATE_UPDATE;
          base::LoadAndSetupEnd();

          m_pSkyModel->SetTranslate(0.0f, 200.0f, 500.0f);

          return false;
        }
#endif

        return true;
      }

      //------------------------------------------------------------------
      /**
       * @name      Draw
       * @brief     `揈A܂B
       */
      //------------------------------------------------------------------
      void CSkyBox::Draw( void )
      {
      }

      //------------------------------------------------------------------
      /**
       * @name      Enable
       * @brief     \A\̐؂ւ[default]
       */
      //------------------------------------------------------------------
      void CSkyBox::DrawEnable( b32 flag )
      {
        m_HideFlag = !flag;

#ifndef USE_XY_SKYBOX_SYSTEM
        u32 numMesh = m_pSkyModel->GetMeshCount();
        for( u32 i = 0; i < numMesh; i++ )
        {
          m_pSkyModel->SetMeshVisible(i, !m_HideFlag);
        }
#endif
      }


      //------------------------------------------------------------------
      /**
       * @name      IsDraw[const]
       * @brief     \A\̏Ԏ擾
       * @return    true : \
       */
      //------------------------------------------------------------------
      b32 CSkyBox::IsDraw( void ) const
      {
        return !m_HideFlag;
      }

      //------------------------------------------------------------------
      /**
       * @name      AddScene
       * @brief     V[Ɏgǉ
       */
      //------------------------------------------------------------------
      void CSkyBox::AddScene(void)
      {
#ifndef USE_XY_SKYBOX_SYSTEM
        m_pRentalPtrSet->pScene->AddSceneNode( m_pSkyModel );
#endif
      }

      //------------------------------------------------------------------
      /**
       * @name      RemoveScene
       * @brief     V[玩g菜
       */
      //------------------------------------------------------------------
      void CSkyBox::RemoveScene(void)
      {
#ifndef USE_XY_SKYBOX_SYSTEM
        m_pRentalPtrSet->pScene->RemoveSceneNode( m_pSkyModel );
#endif
      }

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG

// EOF
