#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CProcGame.h
 * @brief  VlCQ[vbN
 * @author junya ikuta
 * @date   2012/05/18() 09:52
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once



// Sys
#include <fs/gfl_FileReadManager.h>

// appSys

// app
#include "../test_ikuta_CBase.h"

#if 1
#include <gflib.h>
#include <math/gfl_MathRandom.h>
#include <gfl_UI.h>
#include <gfl_Base.h>
#include <gfl_Heap.h>
#include <gfl_UI.h>
#include <ui/gfl_UI_DeviceManager.h>
#include <gamesystem/GameProc.h>
#include <str/gfl_MsgData.h>
#include <math/gfl_MathRandom.h>
#include <poke_tool/poke_model_sys.h>
// appSys
#include "app/util/app_util_heap.h"
#include "app/util/app_util_3d.h"

#endif

namespace test {
  namespace ikuta {
    namespace game {

      class CText;
      class CPokemon;
      class CResourceObjectBase;
      class CSkyBox;
      class CPlayer;
      class CGameCamera;
      class CLostChildManager;
      class CTitleCamera;
      class CTree;
      class CPlayCamera;

      class CProcGame : public CBase
      {
        public:
          enum CHILD_PROC {
            CHILD_PROC_TITLE = 0, // ^Cg
            CHILD_PROC_PLAY,      // ʏvC
            
            CHILD_PROC_MAX
          };

          enum STATE {
            STATE_NULL = 0,  // 
            STATE_LOAD,
            STATE_UPDATE_TITLE,    // ^CgXV
            STATE_UPDATE_PLAY,     // vCʍXV
            
            STATE_MAX
          };

          CProcGame(
              app::util::Heap*                pHeap,          
              gfl::ui::DeviceManager*         pUiDeviceManager,
              gfl::grp::GraphicsSystem*       pGraphicsSystem, 
              app::util::G3DUtil*             pG3dUtil,		     
              gfl::grp::g2d::LytSys*           pLayOutSystem, 
              gfl::math::Random*              pRandom,
              gamesystem::FrameMode*          pFrameMode
              );
          virtual ~CProcGame( void );


        protected:
          b32 CreateChild( CHILD_PROC type );

          // ʏϐ
          STATE                           m_State;            // ԕϐ
          CBase*                          m_pChild;             // qV[

          // IuWFNg
          gfl::grp::g2d::LytResID         m_ResID;              // CAEgVXeID
          gfl::grp::g2d::LytWk*           m_pLayOutWork;        // CAEg1
          gfl::grp::g2d::Env*             m_pUpperLayoutEnv;
          gfl::grp::g2d::Env*             m_pLowerLayoutEnv;
          CSkyBox*                        m_pSkyBox;  
          CPlayer*                        m_pPlayer;          
          CGameCamera*                    m_pGameCamera;
          CPlayCamera*                    m_pPlayCamera;
          CLostChildManager*              m_pLostChildManager;


          // ^Cg֘A
          CTitleCamera*                   m_pTitleCamera;
          CTree*                          m_pTree;

          // VXe
          gfl::fs::FileReadManager*       m_pFileReadManager;

          CResourceObjectBase**           m_ppLoadObject;             // \[Xǂݍݑ҂IuWFNg̃Xg

        private:
          virtual u32 UpdateImpl( void ); 
          virtual void DrawImpl( void );
      };

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG
