#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CProcGame.cpp
 * @brief  VlCQ[vbN
 * @author junya ikuta
 * @date   2012/05/18() 09:52
 */
/////////////////////////////////////////////////////////////////////////////////////// 

// Sys
#include <gflib.h>
#include <base/gfl_ProcManager.h>

// appSys
#include <system/main.h>
#include "gamesystem/GameProc.h"
#include "gamesystem/GameProcManager.h"
#include "gamesystem/GameManager.h"

#include "dll/DllProc.h"
#include "arc_def.h"
#include "resource\test_ikuta_game_resource_Resource.h"

// app
#include "test_ikuta_game_CResourceObjectBase.h"
#include "test_ikuta_game_CSkyBox.h"
#include "test_ikuta_game_CPlayer.h"
#include "test_ikuta_game_CGameCamera.h"
#include "test_ikuta_game_CLostChildManager.h"
#include "test_ikuta_game_CTree.h"

#include "title/test_ikuta_game_CTitleCamera.h"        

#include "play/test_ikuta_game_CPlayCamera.h"

// res
#include "ikuta_game.gaix"

// proc
#include "test_ikuta_game_CProcGame.h"
#include "title/test_ikuta_game_CProcTitle.h"
#include "play/test_ikuta_game_CProcPlay.h"


namespace test {
  namespace ikuta {
    namespace game{

      // 萔`

      // \[Xǂݍݑ҂IuWFNgʎq
      enum LOAD_WAIT_OBJECT{
        LOAD_WAIT_OBJECT_SKYBOX = 0,
        LOAD_WAIT_OBJECT_PLAYER,
        LOAD_WAIT_OBJECT_LOST_CHILD_MANAGER,
        LOAD_WAIT_OBJECT_TREE,
        LOAD_WAIT_OBJECT_TITLE_CAMERA,

        LOAD_WAIT_OBJECT_MAX
      };


      //-------------------------------------------------------------------------------------
      // RXgN^
      //-------------------------------------------------------------------------------------
      CProcGame::CProcGame(
          app::util::Heap*                pHeap,          
          gfl::ui::DeviceManager*         pUiDeviceManager,
          gfl::grp::GraphicsSystem*       pGraphicsSystem, 
          app::util::G3DUtil*             pG3dUtil,		     
          gfl::grp::g2d::LytSys*          pLayOutSystem, 
          gfl::math::Random*              pRandom,  
          gamesystem::FrameMode*          pFrameMode
          ) :
        CBase( pHeap, pUiDeviceManager, pGraphicsSystem, pG3dUtil, pLayOutSystem, pRandom, pFrameMode),

        // ʏϐ
        m_State( STATE_NULL ),
        m_pChild( NULL ),

        // IuWFNg

        // Sys
        m_pFileReadManager(0)

        {

          //-----------------------------------------------------------------------------------------------------
          // VXȅ


          // t[[g̕ύX
          //          GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->RequestFrameMode(gamesystem::FRAMEMODE_30);
          *m_pFrameMode = gamesystem::FRAMEMODE_30;

          // wiF̐ݒ
          m_pGraphicsSystem->SetClearColor(gfl::grp::DISPLAY_LOWER, 1.0f, 1.0f, 1.0f, 1.0f);
          m_pGraphicsSystem->SetClearColor(gfl::grp::DISPLAY_UPPER, 1.0f, 1.0f, 1.0f, 1.0f);

          // WCZTN
          m_pUiDeviceManager->BootGyroscope(m_pHeap->pHeap, 0);

          // 񓯊ǂݍݏ
          //
          //
          // *******IuWF𑝂₵KXV************************
          //
          //
          m_pFileReadManager = GFL_NEW( m_pHeap->pHeap ) gfl::fs::FileReadManager( 
              m_pHeap->pHeap, 
              FILE_READ_MANAGER_NUM_ARC,
              FILE_READ_MANAGER_NUM_REQUEST,
              FILE_READ_MANAGER_NUM_THREAD,
              gfl::fs::FileReadManager::REQUEST_PRIORITY_NORMAL
              ); 
          m_pFileReadManager->AppendManageFile( m_pHeap->pDevHeap , ARCID_IKUTA_GAME);

#if 1
          // Cgp
          gfl::grp::g3d::Resource* pLightRes = GFL_NEW( m_pHeap->pHeap ) gfl::grp::g3d::Resource();
          //            pLightRes->Load( m_pHeap->pDevHeapAllocator, pArcFile, GARC_ikuta_game_fragmentlight_BCENV);
          pLightRes->Load(m_pHeap->pDevHeapAllocator, "rom:/ikuta/FragmentLight.bcenv");


          // ǂݍ񂾃\[X, CgIuWFNg𐶐
          gfl::grp::g3d::Light* pLight = GFL_NEW( m_pHeap->pHeap ) gfl::grp::g3d::Light();
          pLight->Create( m_pHeap->pHeapAllocator, m_pHeap->pDevHeapAllocator, pLightRes, 0 );
          m_pG3dUtil->GetScene()->AddSceneNode(pLight);
#endif

#if 0
          // JvOō쐬
          app::util::G3DUtil::CAMERA_CREATE_DATA dat[] =
          {
            {
              kCAMERA_DISTANCE,
              //   gfl::math::VEC3(0.0f,0.0f,-1.0f),
              gfl::math::VEC3(0.0f,0.0f,0.0f),
              80.0f,
              20000.0f,
              gfl::grp::g3d::StereoCamera::FOVY_RADIAN_DEFAULT,
              0.0f,
              gfl::grp::g3d::StereoCamera::DEPTH_LEVEL_DEFAULT,
              gfl::grp::g3d::StereoCamera::DEPTH_RANGE_DEFAULT,
              gfl::grp::g3d::StereoCamera::REAL_SWITCH_DEFAULT
            },
          };
          //  m_pG3dUtil->CreateG3dCamera( m_pHeap, app::util::G3DUtil::SETUP_CAMERA_LOWER, &dat[0], NULL );
          //      m_pG3dUtil->CreateG3dCamera( m_pHeap, app::util::G3DUtil::SETUP_CAMERA_UPPER, &dat[0], NULL);
          //      m_pG3dUtil->CalculateG3dScene();
#endif

          //-----------------------------------------------------------------------------------------------------
          // IuWFNg̏

          // ^CgJ(Aj[V)
          {
            m_pTitleCamera = GFL_NEW( m_pHeap->pHeap ) CTitleCamera;

            CTitleCamera::RENTAL_PTR_SET titleCameraRentalPtrSet;
            CTitleCamera::SETUP_PARAM    titleCameraSetUpParam;
            titleCameraRentalPtrSet.pUtil = m_pG3dUtil;
            titleCameraRentalPtrSet.pScene = m_pG3dUtil->GetScene();
            titleCameraRentalPtrSet.pHeap = m_pHeap;
            titleCameraRentalPtrSet.pFileReadManager = m_pFileReadManager;
            titleCameraSetUpParam.arcId = ARCID_IKUTA_GAME;

            m_pTitleCamera->Initialize(titleCameraRentalPtrSet, titleCameraSetUpParam);
          }


          // ^CgŎg؂ƊŔ̐
          m_pTree = GFL_NEW(m_pHeap->pHeap) CTree;
          CTree::RENTAL_PTR_SET treeRentalPtrSet;
          CTree::SETUP_PARAM    treeSetUpParam;
          treeRentalPtrSet.pScene = m_pG3dUtil->GetScene();
          treeRentalPtrSet.pHeap = m_pHeap;
          treeRentalPtrSet.pFileReadManager = m_pFileReadManager;
          treeSetUpParam.arcId = ARCID_IKUTA_GAME;

          m_pTree->Initialize(treeRentalPtrSet, treeSetUpParam);


          // vC[̐
          m_pPlayer = GFL_NEW(m_pHeap->pHeap) CPlayer;
          CPlayer::RENTAL_PTR_SET playerRentalPtrSet;
          CPlayer::SETUP_PARAM    playerSetUpParam;
          playerRentalPtrSet.pScene = m_pG3dUtil->GetScene();
          playerRentalPtrSet.pHeap = m_pHeap;
          playerRentalPtrSet.pFileReadManager = m_pFileReadManager;
          playerRentalPtrSet.pStick = m_pStick;
          playerRentalPtrSet.pGyroscope = m_pUiDeviceManager->GetGyroscope( 0 );
          playerSetUpParam.arcId = ARCID_IKUTA_GAME;

          m_pPlayer->Initialize(playerRentalPtrSet, playerSetUpParam);


          // J̐(vC[̌ɂ)
          m_pGameCamera = GFL_NEW(m_pHeap->pHeap) CGameCamera;
          CGameCamera::RENTAL_PTR_SET gameCameraRentalPtrSet;
          CGameCamera::SETUP_PARAM    gameCameraSetUpParam;
          gameCameraRentalPtrSet.pScene = m_pG3dUtil->GetScene();
          gameCameraRentalPtrSet.pCamera = m_pG3dUtil->GetUpperCamera();
          gameCameraRentalPtrSet.pHeap = m_pHeap;
          gameCameraRentalPtrSet.pTargetObject = m_pPlayer;
          //  gameCameraRentalPtrSet.pFileReadManager = m_pFileReadManager;
          // gameCameraSetUpParam.arcId = ARCID_IKUTA_GAME;

          m_pGameCamera->Initialize(gameCameraRentalPtrSet, gameCameraSetUpParam);


          // XJC{bNX̐(J̌ɂ)
          m_pSkyBox = GFL_NEW(m_pHeap->pHeap) CSkyBox;
          CSkyBox::RENTAL_PTR_SET skyBoxRentalPtrSet;
          CSkyBox::SETUP_PARAM    skyBoxSetUpParam;
          skyBoxRentalPtrSet.pScene = m_pG3dUtil->GetScene();
          skyBoxRentalPtrSet.pHeap = m_pHeap;
          skyBoxRentalPtrSet.pFileReadManager = m_pFileReadManager;
          skyBoxRentalPtrSet.pGameCamera = m_pGameCamera;
          skyBoxSetUpParam.arcId = ARCID_IKUTA_GAME;

          m_pSkyBox->Initialize(skyBoxRentalPtrSet, skyBoxSetUpParam);


          // qǗ̐(vC[̌ɂ)
          m_pLostChildManager = GFL_NEW(m_pHeap->pHeap) CLostChildManager;
          CLostChildManager::RENTAL_PTR_SET lostChildManagerRentalPtrSet;
          CLostChildManager::SETUP_PARAM    lostChildManagerSetUpParam;
          lostChildManagerRentalPtrSet.pScene = m_pG3dUtil->GetScene();
          lostChildManagerRentalPtrSet.pHeap = m_pHeap;
          lostChildManagerRentalPtrSet.pFileReadManager = m_pFileReadManager;
          lostChildManagerRentalPtrSet.pPlayer = m_pPlayer;
          lostChildManagerSetUpParam.arcId = ARCID_IKUTA_GAME;

          m_pLostChildManager->Initialize(lostChildManagerRentalPtrSet, lostChildManagerSetUpParam);

          // Q[vC̃J
          {
            m_pPlayCamera = GFL_NEW( m_pHeap->pHeap ) CPlayCamera;

            CPlayCamera::RENTAL_PTR_SET playCameraRentalPtrSet;
            CPlayCamera::SETUP_PARAM    playCameraSetUpParam;
            playCameraRentalPtrSet.pUtil = m_pG3dUtil;
            playCameraRentalPtrSet.pScene = m_pG3dUtil->GetScene();
            playCameraRentalPtrSet.pHeap = m_pHeap;
            playCameraRentalPtrSet.pTitleCamera = m_pTitleCamera;         // ɎgȂ̂Ń[hIĂȂĂǂ

            m_pPlayCamera->Initialize(playCameraRentalPtrSet, playCameraSetUpParam);
          }


          //-----------------------------------------------------------------------------------------------------
          // ̑@

          // \[Xǂݍݑ҂IuWFNg̓o^
          m_ppLoadObject = GFL_NEW_ARRAY( m_pHeap->pHeap ) CResourceObjectBase* [LOAD_WAIT_OBJECT_MAX];
          m_ppLoadObject[LOAD_WAIT_OBJECT_SKYBOX] = m_pSkyBox;
          m_ppLoadObject[LOAD_WAIT_OBJECT_PLAYER] = m_pPlayer;
          m_ppLoadObject[LOAD_WAIT_OBJECT_LOST_CHILD_MANAGER] = m_pLostChildManager; 
          m_ppLoadObject[LOAD_WAIT_OBJECT_TREE] = m_pTree; 
          m_ppLoadObject[LOAD_WAIT_OBJECT_TITLE_CAMERA] = m_pTitleCamera;

          // 
          m_pG3dUtil->GetScene()->Initialize();
          // V[ݒ
          m_pG3dUtil->GetScene()->SetSceneEnvironmentUsingOwnObject();
          // Jʒu𐢊EWɂ邽߂ɈxXVĂ
          m_pG3dUtil->GetScene()->Calculate();

          //--------------------------------------------------------------------------------
          // ̑p[^
          m_State = STATE_LOAD;

        }

      //-------------------------------------------------------------------------------------
      // fXgN^
      //-------------------------------------------------------------------------------------
      CProcGame::~CProcGame( void )
      {
        // ō쐬̂j

        //       if( m_pG3dUtil )
        //       m_pG3dUtil->DeleteG3dCamera();


#if 0 
        // ʏϐ
        m_State = kSTATE_NULL;

        // ؂蕨null邾
        m_pUiDeviceManager = 0;

        // ō쐬̂j
        GFL_SAFE_DELETE( m_pText );
        GFL_SAFE_DELETE_ARRAY( m_pPokeArray );

        //	pPokeModel->RemoveScene( m_pG3dUtil->GetScene() );  // BoxPokeModel::RemoveScene(void)

        // VXe͏ԂɒӂȂ΂ȂH
        GFL_SAFE_DELETE( m_pPokeModelSystem );   
        GFL_SAFE_DELETE( m_pLayOutSystem );

        // Util̃fXgN^͋󔒂Ȃ̂Ŏŏ
        if( m_pG3dUtil )
        {
          // null`FbNĂȂ̂m_pG3dUtilĂ鎞AL̕CreateĂ鎖ۏႳĂȂƂȂB
          m_pG3dUtil->DeleteEdgeSystem();
          //  m_pG3dUtil->DeleteG3dLight();
          m_pG3dUtil->DeleteG3dCamera();
          m_pG3dUtil->DeleteG3dScene();
          m_pG3dUtil->DeleteG3dSystem();
          GFL_SAFE_DELETE( m_pG3dUtil );
        }

        // OtBbNVXe͎؂蕨AAP[^[蓖ĂĂ̂ŏ
        if( m_pGraphicsSystem )
        {
          m_pGraphicsSystem->FinalizeApplicationMemory();
          m_pGraphicsSystem = 0;
        }

        // q[vUtil̓fXgN^Ŗ薳
        GFL_SAFE_DELETE( m_pHeap );
#endif
      }

      // protected
      b32 CProcGame::CreateChild( CHILD_PROC type )
      {
        switch( type )
        {
          // ^CgV[̍쐬
        case CHILD_PROC_TITLE:
          {
            CProcTitle::RENTAL_OBJ_PTR_SET titleSetUp;
            titleSetUp.pTitleCamera = m_pTitleCamera;
            titleSetUp.pTree = m_pTree;
            titleSetUp.pSkyBox = m_pSkyBox;
            titleSetUp.pPlayer = m_pPlayer;

            m_pChild = GFL_NEW( m_pHeap->pHeap ) CProcTitle(
                m_pHeap,
                m_pUiDeviceManager,
                m_pGraphicsSystem, 
                m_pG3dUtil,
                m_pLayOutSystem,
                m_pRandom,
                m_pFrameMode,
                titleSetUp
                );
            m_State = STATE_UPDATE_TITLE;
            return true;
          }

          // ʏvCV[̍쐬
        case CHILD_PROC_PLAY:
          {
            CProcPlay::RENTAL_OBJ_PTR_SET playSetUp;
            playSetUp.pPlayCamera = m_pPlayCamera;
            playSetUp.pSkyBox = m_pSkyBox;
            playSetUp.pPlayer = m_pPlayer;
            playSetUp.pLostChildManager = m_pLostChildManager;

            m_pChild = GFL_NEW( m_pHeap->pHeap ) CProcPlay(
                m_pHeap,
                m_pUiDeviceManager,
                m_pGraphicsSystem, 
                m_pG3dUtil,
                m_pLayOutSystem,
                m_pRandom,
                m_pFrameMode,
                playSetUp
                );
            m_State = STATE_UPDATE_PLAY;
            return true;
          }


          break;
        }

        return false;
      }


      // private

      //-------------------------------------------------------------------------------------
      // XV
      //-------------------------------------------------------------------------------------
      u32 CProcGame::UpdateImpl( void )
      {
#if 1
        switch(m_State)
        {
          // [hʂ͓Ȃ̂ŏwŊǗ
        case STATE_LOAD:
          {
            m_pFileReadManager->UpdateFileRead(); 

            b32 roadEnd(true);

            // IuWFNg̃\[Xǂݍ݂s
            for(u32 i = 0; i < LOAD_WAIT_OBJECT_MAX; i++)
            { 
              if( m_ppLoadObject[i]->LoadUpdate() ) 
                roadEnd = false;
            }

            // SẴIuWFNgǂݍ݊^CgV[ɑJ
            if(roadEnd)
            {
              //      m_State = kSTATE_UPDATE;
              CreateChild( CHILD_PROC_TITLE );
            }

          }
          break;

#if 0 // ݌v~Xɂ肱͖̕Ȃ
          // ʏXV͎qɓ
        case kSTATE_UPDATE:
          {
            // qV[
            CBase* pNext = m_pChild->Update();

            // V[Jڂ
            if( pNext != m_pChild)
            {
              GFL_DELETE( m_pChild );
              m_pChild = pNext;
            }
#endif
#if 0
            // A{^ŃvC[̑؂ւ
            if( m_pButton->IsTrigger( gfl::ui::BUTTON_A ) ) 
            {
              m_pPlayer->EnableGyro( !m_pPlayer->IsGyro() );
            }

            // B{^ŃvC[̑؂ւ
            if( m_pButton->IsTrigger( gfl::ui::BUTTON_B ) ) 
            {
              m_pSkyBox->DrawEnable( !m_pSkyBox->IsDraw() );
            }


            m_pPlayer->Update();
            m_pLostChildManager->Update();
            //      m_pGameCamera->Update();
            //     m_pSkyBox->Update();

            m_pLostChildManager->PlayerHitFunc();

            m_pPlayer->Draw();
            m_pLostChildManager->Draw();
          }
#endif

          // ^Cg̍XV
        case STATE_UPDATE_TITLE:
          {
            switch( m_pChild->Update() )
            {
              // ʏvCɈڍs
            case CProcTitle::UPDATE_RESULT_ENTER_PLAY:
              GFL_SAFE_DELETE( m_pChild );
              CreateChild( CHILD_PROC_PLAY );
              break;
            }

            break;    
          }


          // ʏvC̍XV
        case STATE_UPDATE_PLAY:
          {
            switch( m_pChild->Update() )
            {
              // ^CgɈڍs
            case CProcPlay::UPDATE_RESULT_RETURN_TITLE:
              GFL_SAFE_DELETE( m_pChild );
              CreateChild( CHILD_PROC_TITLE );
              break;
            }

            break;    
          }
        }
#endif


#if 0 // qɈړ
        // vĊmF
        m_pG3dUtil->CalculateG3dScene();
        m_pG3dUtil->Update3D( false );

        // CAEg̍XV
        m_pLayOutSystem->UpdateAll();
#endif
        return 0;
      }


      //-------------------------------------------------------------------------------------
      // `揈
      //-------------------------------------------------------------------------------------
      void CProcGame::DrawImpl( void )
      {

        switch(m_State)
        {
        case STATE_NULL:
          break;

        case STATE_LOAD:
          break;

        default :
          m_pChild->Draw();
          break;
        }

#if 0  // qɈړ 
        gfl::grp::RenderTarget* upperFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER);
        gfl::grp::RenderTarget* rightFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER_RIGHT);
        gfl::grp::RenderTarget* lowerFrameBuffer = m_pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_LOWER);

        //     m_pLayOutSystem->DrawAll( m_pGraphicsSystem, gfl::grp::DISPLAY_UPPER, upperFrameBuffer, rightFrameBuffer );
        //    m_pLayOutSystem->DrawAll( m_pGraphicsSystem, gfl::grp::DISPLAY_LOWER, lowerFrameBuffer );

        m_pG3dUtil->Draw3D( m_pGraphicsSystem );
#endif
      }

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG
