

#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CPlayer.h
 * @brief  [VlC~jQ[]vC[
            sWbgƏ̎q
 * @author junya ikuta
 * @date   2012/05/23() 17:21
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// sys
#include <gfl_Math.h>

// appSys

// app
#include "test_ikuta_game_CObjectBase.h"
#include "test_ikuta_game_CResourceObjectBase.h"        

namespace test {
  namespace ikuta {
    namespace game {


      class CPlayer : public CObjectBase, public CResourceObjectBase
      {
        GFL_FORBID_COPY_AND_ASSIGN( CPlayer );                // ֎~

        typedef CObjectBase         base;
        typedef CResourceObjectBase resBase;

        public:

        enum STATE {
          STATE_NULL = 0,  // 
          STATE_LOAD,      // [h(LOAD_STATEƏdӁAKƂ)
          STATE_UPDATE,    // ʏXV
          STATE_TITLE,
          NUM_STATE
        };

        enum MESSAGE {
          MESSAGE_SETUP_TITLE_ENTER = 0,  // ^CgŌ{^ꂽԂɃZbgAbv
          MESSAGE_SETUP_PLAY_START,       // Q[Jn(Jn)  
          MESSAGE_MAX
        };

        // e̎؂蕨
        struct RENTAL_PTR_SET{

          gfl::grp::g3d::Scene*         pScene;               // V[
          app::util::Heap*              pHeap;                // gpq[v        
          gfl::fs::FileReadManager*     pFileReadManager;     // 񓯊t@Cǂݍ
          gfl::ui::VectorDevice*        pStick;               // XeBbN͎擾
          gfl::ui::Gyroscope*           pGyroscope;           // WC͎擾

          RENTAL_PTR_SET() :
            pScene( NULL ),
            pHeap( NULL ),
            pFileReadManager( NULL )
          {
          }

        };


        // p\
        struct SETUP_PARAM{

          gfl::math::VEC3               pos;                  // ʒu
          f32                           dir;                  // 
          u32                           arcId;                // gpA[Nt@CID

          SETUP_PARAM() : 
            pos(0.0f, 0.0f, 0.0f), 
            dir(0.0f), 
            arcId( 0 )
          {
          }

        };

        //------------------------------------------------------------------
        /**
         * @name      CPlayer[RXgN^]
         * @brief     ϐ̏s
         */
        //------------------------------------------------------------------
        CPlayer( void );

        //------------------------------------------------------------------
        /**
         * @name      ~CPlayer[fXgN^]
         * @brief     Finalize()ĂяoB
         */
        //------------------------------------------------------------------
        virtual ~CPlayer( void );

        //------------------------------------------------------------------
        /**
         * @name      Initialize
         * @brief     A[hI܂ŊĂ܂B 
         * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
         * @pram      rSetUp      [const]
         * @return    true : [hԂɓ
         */
        //------------------------------------------------------------------
        bool Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp);

        //------------------------------------------------------------------
        /**
         * @name     Reset
         * @brief    p[^AInitializeɐ퓮AInitializȅԂɂȂ
         */
        //------------------------------------------------------------------
        void Reset( void );

        //------------------------------------------------------------------
        /**
         * @name     Finalize
         * @brief    I
         */
        //------------------------------------------------------------------
        void Finalize( void );

        //------------------------------------------------------------------
        /**
         * @name      Update
         * @brief     XVA[hLoadUpdate𐄏
         * @return    ݂̏
         */
        //------------------------------------------------------------------
        STATE Update( void );

        //------------------------------------------------------------------
        /**
         * @name     LoadUpdate[virtual]
         * @brief    [hǂݐi߂鏃z֐A[hIŕKSetUpLoadAndSetupEnd()ĂԁB
         * @return   true : [hs
         */
        //------------------------------------------------------------------
        bool LoadUpdate(void);      

        //------------------------------------------------------------------
        /**
         * @name      Draw
         * @brief     `揈Aʂfɔf
         */
        //------------------------------------------------------------------
        void Draw( void );

        //------------------------------------------------------------------
        /**
         * @name      IsGyro
         * @brief     WC삩mF
         * @return    true : WC@false : XeBbN
         */
        //------------------------------------------------------------------
        b32 IsGyro( void ) const;

        //------------------------------------------------------------------
        /**
         * @name      EnableGyro
         * @brief     WC̐؂ւ 
         * @pram      flag        true : WC@false : XeBbN[default]
         */
        //------------------------------------------------------------------
        void EnableGyro( b32 flag = true);

        //------------------------------------------------------------------
        /**
         * @name      AddScene
         * @brief     V[Ɏgǉ
         */
        //------------------------------------------------------------------
        void AddScene(void);      
      
        //------------------------------------------------------------------
        /**
         * @name      RemoveScene
         * @brief     V[玩g菜
         */
        //------------------------------------------------------------------
        void RemoveScene(void);      

        //------------------------------------------------------------------
        /**
         * @name      Message
         * @brief     ÕbZ[W
         * @param     message     bZ[Wʎq
         * @return    true : K؂ɏꂽ
         */
        //------------------------------------------------------------------
        b32 Message(MESSAGE message);     


        b32 IsStateEnd( void ) const
        {
          return m_StateEndFlag;
        } 

        protected:

        //------------------------------------------------------------------
        /**
         * @name      ChangeAnimation
         * @brief     Aj[V̕ύX
         * @param     index       Aj[Vԍ
         * @param     loop        true [v[= false]
         * @param     changeCnt   OAj[VƂ̕ԃt[[= 0]
         */
        //------------------------------------------------------------------
        void ChangeAnimation( u32 index, b32 loop = false, u32 changeCnt = 0 );


        // ʏϐ
        STATE                           m_State;          // ԕϐ
        b32                             m_StateEndFlag;       // true L̏Ԃłׂ͏IĂ
        b32                             m_GyroscopeFlag;  // true : WC@false : XeBbN
        gfl::math::VEC3                 m_RotGeta;        // ]px̃Q^Aۂ̕\͂̊pxɌ

        // \[X֘A
        gfl::grp::g3d::Model*           m_pModel;          // f
        gfl::grp::g3d::Resource*        m_pModelRes;       // f\[X
        void*                           m_pBuf;            // 񓯊ǂݍݗpobt@|C^ 

        gfl::grp::g3d::Resource*        m_pResAnimationArray;    // Aj[V\[X(z)
        void**                          m_ppBufAnimationArray;   // 񓯊ǂݍݗpobt@|C^(z)
        gfl::grp::g3d::ResAnim**        m_ppAnimationArray;      // Aj[VzAς݂nullŔfׂɃ^u|C^

        // VXe
        RENTAL_PTR_SET*                 m_pRentalPtrSet;    // w؂Ă|C^ 

        private:
      };

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG

// EOF
