

#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CPlayer.cpp
 * @brief  [VlC~jQ[]vC[
 sWbgƏ̎q
 * @author junya ikuta
 * @date   2012/05/23() 17:21
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// sys
#include <gfl_Math.h>
#include <debug/gfl_DebugPrint.h>

// appSys
#include "test_ikuta_game_Common.h"
#include "resource/test_ikuta_game_resource_Player.h"

// app
#include "test_ikuta_game_CPlayer.h"

// res
#include "arc_def.h"
#include "ikuta_game.gaix"

namespace test {
  namespace ikuta {
    namespace game {

      const f32 PLAYER_MOVE_SPEED(2.0f);
      const f32 PLAYER_ROT_X_MAX(1.2f);                    // O[oc]̐ (-PLAYER_ROT_Z_MAX ` PLAYER_ROT_Z_MAX)
      const f32 PLAYER_ROT_LOCAL_Z_MAX(0.3f);              // [J]̐ (-PLAYER_ROT_Z_MAX ` PLAYER_ROT_Z_MAX)
      const f32 PLAYER_ROT_LOCAL_X_MAX(0.3f);              // [J]̐ (-PLAYER_ROT_X_MAX ` PLAYER_ROT_X_MAX) 
      const f32 PLAYER_ROT_LOCAL_Y_MAX(0.3f);              // [J]̐ (-PLAYER_ROT_Y_MAX ` PLAYER_ROT_Y_MAX)
      const f32 PLAYER_ROT_COEFFICIENT(0.1f);             // pxωɎgW
      const f32 PLAYER_ROT_LOCAL_COEFFICIENT(2.0f);             // pxωɎgW

      const f32 PLAYER_HIT_SIZE(100.0f);                  // vC[̂蔻TCY(a)

      // isApx̐̃
      // WCZp@@fYp(`̂Zp)
      // WCXp@@fXp
      // `px         m_RotGeta(WCp)
      // O[opx   m_Rot + m_RotGeta
      // ispx@@     m_Rot
      // ispx̍XV   m_Rot + m_RotGeta * PLAYER_ROT_COEFFICIENT 

      // f֘A




      //------------------------------------------------------------------
      /**
       * @name      CPlayer[RXgN^]
       * @brief     ϐ̏s
       */
      //------------------------------------------------------------------
      CPlayer::CPlayer( void ) : 
        m_State( STATE_NULL ),
        m_StateEndFlag( false ),
        m_GyroscopeFlag(false),
        m_RotGeta(0.0f, 0.0f, 0.0f),
        m_pModel( 0 ),
        m_pModelRes( 0 ),
        m_pBuf( 0 ),
        m_pRentalPtrSet( NULL )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name      ~CPlayer[fXgN^]
       * @brief     Finalize()Ăяo
       */
      //------------------------------------------------------------------
      CPlayer::~CPlayer( void )
      {
        Finalize();
      }   

      //------------------------------------------------------------------
      /**
       * @name      Initialize
       * @brief     A[hI܂ŊĂ܂B 
       * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
       * @pram      rSetUp      [const,default]
       * @return    true : [hԂɓ
       */
      //------------------------------------------------------------------
      bool CPlayer::Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp)
      {  
        // `FbN
        //   GFL_ASSERT
        //  rRentalPtr.

        // ܂؂蕨[
        m_pRentalPtrSet = GFL_NEW( rRentalPtr.pHeap->pHeap )RENTAL_PTR_SET;
        *m_pRentalPtrSet = rRentalPtr;

        // f̐(̎_ł̓[hĂȂ)
        m_pModel = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Model();
        //     m_pModelRes = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Resource();

        // 񓯊\[X̓ǂݍ
        m_pRentalPtrSet->pFileReadManager->AddReadRequest(
            &m_pBuf,
            NULL,
            m_pRentalPtrSet->pHeap->pDevHeap,
            128,
            rSetUp.arcId,
            PLAYER_ARCID_MODEL,
            true
            );

        // Aj[V\[X̍쐬
        m_pResAnimationArray = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Resource[PLAYER_ANIMATION_MAX];
        m_ppBufAnimationArray = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) void* [PLAYER_ANIMATION_MAX];
        m_ppAnimationArray = GFL_NEW_ARRAY( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::ResAnim* [PLAYER_ANIMATION_MAX];

        //        gfl::grp::g3d::Resource* pSelect( m_pResAnimationArray );
        for( u32 i = 0; i < PLAYER_ANIMATION_MAX; i++)
        {
          m_ppAnimationArray[i] = NULL;

          m_pRentalPtrSet->pFileReadManager->AddReadRequest(
              &m_ppBufAnimationArray[i],
              NULL,
              m_pRentalPtrSet->pHeap->pDevHeap,
              128,
              rSetUp.arcId,
              A_PLAYER_ARCID_ANIMATION[i],
              true
              );
        }


        // [hԂɈڍs
        resBase::LoadStart();
        m_State = STATE_LOAD;
        m_StateEndFlag = false;
        m_GyroscopeFlag = false;

        m_HitRad = PLAYER_HIT_SIZE;

        return true;
      }

      //------------------------------------------------------------------
      /**
       * @name     Reset
       * @brief    p[^AInitializeɐ퓮AInitializȅԂɂȂ
       */
      //------------------------------------------------------------------
      void CPlayer::Reset( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name     Finalize
       * @brief    I
       */
      //------------------------------------------------------------------
      void CPlayer::Finalize( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name      Update
       * @brief     XVA[hLoadUpdate𐄏
       * @return    ݂̏
       */
      //------------------------------------------------------------------
      CPlayer::STATE CPlayer::Update( void )
      {
        if( m_StateEndFlag )
          return m_State;
       
       switch( m_State )
        {
        case STATE_LOAD:
          LoadUpdate();
          break;
        case STATE_UPDATE:             
          // ^

          // ͂ɂύX
          gfl::math::VEC3 rot(0.0f, 0.0f, 0.0f);
          if(m_GyroscopeFlag)
          {
            if( m_pRentalPtrSet->pGyroscope->IsValid() )
            {
#if 0
              rot = m_pRentalPtrSet->pGyroscope->GetAngle();

              GFL_PRINT("gyro x:%f y:%f z:%f\n", rot.x, rot.y, rot.z);

              if( rot.y )

                // \px̐
                m_RotGeta.y = gfl::math::Clamp(rot.z, - PLAYER_ROT_LOCAL_Y_MAX, PLAYER_ROT_LOCAL_Y_MAX);
              m_RotGeta.x = gfl::math::Clamp(rot.x, - PLAYER_ROT_LOCAL_X_MAX, PLAYER_ROT_LOCAL_X_MAX);
              // m_RotGeta.z = m_RotGeta.x;

              m_RotGeta *= PLAYER_ROT_LOCAL_COEFFICIENT;

              m_Rot.y += m_RotGeta.y * PLAYER_ROT_COEFFICIENT;
              m_Rot.x += m_RotGeta.x * PLAYER_ROT_COEFFICIENT;

              // px̐
              m_Rot.x = gfl::math::Clamp(m_Rot.x, - PLAYER_ROT_X_MAX, PLAYER_ROT_X_MAX);
#endif
            }
          }
          else
          {
            rot.x = m_pRentalPtrSet->pStick->GetY();
            rot.y = - m_pRentalPtrSet->pStick->GetX();
            rot.z = 0.0f;
            m_Rot += rot * 0.05f;
          }

          // Ɉړ͂쐬
          gfl::math::VEC3 move(0.0f, 0.0f, PLAYER_MOVE_SPEED);

          gfl::math::MTX34 mat;
          gfl::math::MTX34RotXYZRad( &mat, m_Rot.x, m_Rot.y, m_Rot.z );

          gfl::math::VEC3Transform( &move, &mat, &move);

          m_Pos += move;


          break;

        case STATE_TITLE:
          if( m_pModel->IsAnimationFrameEndFrame() )
          {
            m_StateEndFlag = true;
          }
          break;
      
        }

        return m_State;
      }

      //------------------------------------------------------------------
      /**
       * @name     LoadUpdate[virtual]
       * @brief    [hǂݐi߂鏃z֐A[hIŕKSetUpLoadAndSetupEnd()ĂԁB
       * @return   true : [hs
       */
      //------------------------------------------------------------------
      bool CPlayer::LoadUpdate(void)
      {
        if(m_State != STATE_LOAD)
          return false;

        bool endFlag(true);

        // Aj[V̓ǂݍ
        for( u32 i = 0; i < PLAYER_ANIMATION_MAX; i++)
        {
          // ς
          if(m_ppAnimationArray[i])
            continue;

          // ǂݍݑ҂
          if( m_pRentalPtrSet->pFileReadManager->IsReadFinished(&m_ppBufAnimationArray[i]) )
          {
            gfl::grp::g3d::Resource::Description resource_description;
            // ǂݍ񂾂̂\[XɃA^b`
            m_pResAnimationArray[i].AttachBuffer( 
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                m_ppBufAnimationArray[i], 
                &resource_description, 
                true                      // buf̌n
                );
            m_ppBufAnimationArray[i] = NULL;

            // Aj[VIuWFNg̐
            m_ppAnimationArray[i] = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::ResAnim();
            m_ppAnimationArray[i]->Create( 
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                &m_pResAnimationArray[i],
                0,
                gfl::grp::g3d::ResAnim::TYPE_SKELETAL
                );
          }
          else 
          {
            endFlag = false;
          }
        }


        // f̓ǂݍ
        if( !m_pModelRes )
        {
          // ǂݍ݂҂
          if( m_pRentalPtrSet->pFileReadManager->IsReadFinished(&m_pBuf) )
          {

            m_pModelRes = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::Resource();

            // ftHgVF[_[gp            
            gfl::grp::g3d::Resource::Description resource_description;
            u32 common_resource_flag = gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE;
            common_resource_flag |= gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT;

            // ǂݍ񂾂̂\[XɃA^b`
            m_pModelRes->AttachBuffer( 
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                m_pBuf, 
                &resource_description, 
                true                      // buf̌n
                );
            m_pModelRes->Setup( m_pRentalPtrSet->pHeap->pDevHeapAllocator , NULL, common_resource_flag);
            m_pBuf = NULL;

            // f
            gfl::grp::g3d::Model::Description desc;
            desc.animation_slot_num = 1;                               // Aj[VXbgKvmۂ

            m_pModel->Create( 
                m_pRentalPtrSet->pHeap->pHeapAllocator, 
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                m_pModelRes, 
                0,
                &desc
                );


            m_pModel->SetModelLayerId( MODEL_LAYER_ID_PLAYER );         // ɕ`
       //     m_pRentalPtrSet->pScene->AddSceneNode( m_pModel );

          }
          else
          {
            endFlag = false;
          }
        }

        if( endFlag )
        {
          m_State = STATE_UPDATE;
          resBase::LoadAndSetupEnd();

          ChangeAnimation(PLAYER_ANIMATION_GLIDE, true, 0);
          return false;
        }


        return true;
      }

      //------------------------------------------------------------------
      /**
       * @name      Draw
       * @brief     `揈Aʂfɔf
       */
      //------------------------------------------------------------------
      void CPlayer::Draw( void )
      {
        m_pModel->SetTranslate( m_Pos );
        m_pModel->SetRotateXYZ( m_Rot + m_RotGeta );
      }

      //------------------------------------------------------------------
      /**
       * @name      IsGyro
       * @brief     WC삩mF
       * @return    true : WC@false : XeBbN
       */
      //------------------------------------------------------------------
      b32 CPlayer::IsGyro( void ) const
      {
        return m_GyroscopeFlag;
      }

      //------------------------------------------------------------------
      /**
       * @name      EnableGyro
       * @brief     WC̐؂ւ 
       * @pram      flag        true : WC@false : XeBbN[default]
       */
      //------------------------------------------------------------------
      void CPlayer::EnableGyro( b32 flag)
      {
        m_GyroscopeFlag = flag;
      }

      //------------------------------------------------------------------
      /**
       * @name      AddScene
       * @brief     V[Ɏgǉ
       */
      //------------------------------------------------------------------
      void CPlayer::AddScene(void)
      {
        m_pRentalPtrSet->pScene->AddSceneNode( m_pModel );
      }

      //------------------------------------------------------------------
      /**
       * @name      RemoveScene
       * @brief     V[玩g菜
       */
      //------------------------------------------------------------------
      void CPlayer::RemoveScene(void)
      {
        m_pRentalPtrSet->pScene->RemoveSceneNode( m_pModel );
      }

        //------------------------------------------------------------------
        /**
         * @name      Message
         * @brief     ÕbZ[W
         * @param     message     bZ[Wʎq
         * @return    true : K؂ɏꂽ
         */
        //------------------------------------------------------------------
        b32 CPlayer::Message(MESSAGE message)
        {
          switch( message )
          {
            case MESSAGE_SETUP_TITLE_ENTER :  // ^CgŌ{^ꂽԂɃZbgAbv
            {
              m_State = STATE_TITLE;
              ChangeAnimation(PLAYER_ANIMATION_TITLE, false, 0);
              m_StateEndFlag = false;
              return true;
            }
            case MESSAGE_SETUP_PLAY_START :       // Q[Jn(Jn)  
            {
              m_State = STATE_UPDATE;
              ChangeAnimation(PLAYER_ANIMATION_GLIDE, true, 0);
              m_StateEndFlag = false;
              return true;
            }
          }

          return false;
        }



      //------------------------------------------------------------------
      /**
       * @name      ChangeAnimation
       * @brief     Aj[V̕ύX
       * @param     index       Aj[Vԍ
       * @param     loop        true [v[= false]
       * @param     changeCnt   OAj[VƂ̕ԃt[[= 0]
       */
      //------------------------------------------------------------------
      void CPlayer::ChangeAnimation( u32 index, b32 loop, u32 changeCnt)
      {
        m_pModel->ChangeAnimation( 
            m_pRentalPtrSet->pHeap->pHeapAllocator, 
            m_ppAnimationArray[index], 
            changeCnt, 
            0 
            );

        m_pModel->SetAnimationFrame(0, 0);
        m_pModel->SetAnimationLoop(loop, 0);
      }


    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG

// EOF
