

#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CObjectBase.cpp
 * @brief  [VlC~jQ[]IuWFNg̃x[XNX
 `A蔻pp[^
 * @author junya ikuta
 * @date   2012/05/23() 17:21
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// sys
#include <gfl_Math.h>

// appSys

// app

namespace test {
  namespace ikuta {
    namespace game {


      //------------------------------------------------------------------
      /**
       * @name      CObjectBase[RXgN^]
       * @brief     ϐ̏s
       */
      //------------------------------------------------------------------
      CObjectBase::CObjectBase( void ) : 
        m_Pos( 0.0f, 0.0f, 0.0f ), 
        m_Move( 0.0f, 0.0f, 0.0f ),
        m_Rot( 0.0f, 0.0f, 0.0f ),
        m_HitRad( 0.0f )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name      ~CObjectBase[fXgN^]
       * @brief     ܂
       */
      //------------------------------------------------------------------
      CObjectBase::~CObjectBase( void )
      {
      }

      //------------------------------------------------------------------
      /**
       * @name     Reset
       * @brief    p[^
       */
      //------------------------------------------------------------------
      void CObjectBase::Reset( void )
      {
        m_Pos = gfl::math::VEC3::Zero();
        m_Rot =  gfl::math::VEC3::Zero();
        m_Move =  gfl::math::VEC3::Zero();
        m_HitRad = 0.0f;
      }

      //------------------------------------------------------------------
      /**
       * @name      IsHit
       * @brief     蔻s(oEfBOXtBA)
       * @return    true : Ă
       */
      //------------------------------------------------------------------
      b32 CObjectBase::IsHit( const CObjectBase& rObj ) const
      {
        u32 xx = m_Pos.x - rObj.m_Pos.x;
        xx = xx * xx;
        u32 yy = m_Pos.y - rObj.m_Pos.y;
        yy = yy * yy;
        u32 zz = m_Pos.z - rObj.m_Pos.z;
        zz = zz * zz;
        
        u32 rad(m_HitRad + rObj.m_HitRad);
        rad = rad * rad;

        if( xx + yy + zz <= rad)
          return true;

        return false;
      }

      //------------------------------------------------------------------
      /**
       * @name      GetPosition[const]
       * @brief     W̎擾
       */
      //------------------------------------------------------------------
      void CObjectBase::GetPosition( gfl::math::VEC3* pOutPos) const
      {
        *pOutPos = m_Pos;
      }
      const gfl::math::VEC3& CObjectBase::GetPosition( void ) const
      {
        return m_Pos;
      }

      //------------------------------------------------------------------
      /**
       * @name      GetRotation[const]
       * @brief     ]̎擾
       */
      //------------------------------------------------------------------
      void CObjectBase::GetRotation( gfl::math::VEC3* pOutRot) const
      {
        *pOutRot = m_Rot;
      }
      const gfl::math::VEC3& CObjectBase::GetRotation( void ) const
      {
        return m_Rot;
      }

      //------------------------------------------------------------------
      /**
       * @name      GetMove[const]
       * @brief     ړ͂̎擾
       */
      //------------------------------------------------------------------
      void CObjectBase::GetMove( gfl::math::VEC3* pOutMove) const
      {
        *pOutMove = m_Move;
      }
      const gfl::math::VEC3& CObjectBase::GetMove( void ) const
      {
        return m_Move;
      }


    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG

// EOF
