

#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CLostChildManager.h
 * @brief  [VlC~jQ[]qNXǗ
            \[X̊ǗsB
 * @author junya ikuta
 * @date   2012/05/23() 17:21
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// sys
#include <gfl_Math.h>

// appSys

// app
#include "test_ikuta_game_CResourceObjectBase.h"

namespace test {
  namespace ikuta {
    namespace game {

      class CLostChild;
      class CPlayer;

      class CLostChildManager : public CObjectBase, public CResourceObjectBase
      {
        GFL_FORBID_COPY_AND_ASSIGN( CLostChildManager );    // ֎~

        typedef CResourceObjectBase         base;

        public:

        enum STATE {
          STATE_NULL = 0,  // 
          STATE_LOAD,      // \[X[h
          STATE_UPDATE,    // ʏXV
          NUM_STATE
        };

        // e̎؂蕨
        struct RENTAL_PTR_SET{
  
          gfl::grp::g3d::Scene*         pScene;               // V[
          app::util::Heap*              pHeap;                // gpq[v        
          gfl::fs::FileReadManager*     pFileReadManager;     // 񓯊t@Cǂݍ
          CPlayer*                      pPlayer;              // vC[NXւ̃|C^

          RENTAL_PTR_SET() :
            pScene( NULL ),
            pHeap( NULL ),
            pFileReadManager( NULL ),
            pPlayer( NULL )
          {
          }

        };


        // p\
        struct SETUP_PARAM{

          gfl::math::VEC3               pos;                  // ʒu
          f32                           dir;                  // 
          u32                           arcId;                // gpA[Nt@CID

          SETUP_PARAM() : 
            pos(0.0f, 0.0f, 0.0f), 
            dir(0.0f), 
            arcId( 0 )
          {
          }

        };

        //------------------------------------------------------------------
        /**
         * @name      CLostChildManager[RXgN^]
         * @brief     ϐ̏s
         */
        //------------------------------------------------------------------
        CLostChildManager( void );

        //------------------------------------------------------------------
        /**
         * @name      ~CLostChildManager[fXgN^]
         * @brief     Finalize()ĂяoB
         */
        //------------------------------------------------------------------
        virtual ~CLostChildManager( void );

        //------------------------------------------------------------------
        /**
         * @name      Initialize
         * @brief     A[hI܂ŊĂ܂B 
         * @param     rRentalPtr  ؂蕨̃|C^Zbg[const]
         * @param     rSetUp      [const,default]
         * @return    true : [hԂɓ
         */
        //------------------------------------------------------------------
        bool Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp);

        //------------------------------------------------------------------
        /**
         * @name     Reset
         * @brief    p[^AInitializeɐ퓮AInitializȅԂɂȂ
         */
        //------------------------------------------------------------------
        void Reset( void );

        //------------------------------------------------------------------
        /**
         * @name     Finalize
         * @brief    I
         */
        //------------------------------------------------------------------
        void Finalize( void );

        //------------------------------------------------------------------
        /**
         * @name      Update
         * @brief     XV
         * @return    ݂̏
         */
        //------------------------------------------------------------------
        STATE Update( void );

        //------------------------------------------------------------------
        /**
         * @name     LoadUpdate[virtual]
         * @brief    [hǂݐi߂鏃z֐A[hIŕKSetUpLoadAndSetupEnd()ĂԁB
         * @return   true : [hs
         */
        //------------------------------------------------------------------
        bool LoadUpdate(void);      

        //------------------------------------------------------------------
        /**
         * @name      Draw
         * @brief     `揈Aʂfɔf
         */
        //------------------------------------------------------------------
        void Draw( void );

        //------------------------------------------------------------------
        /**
         * @name      PlayerHitFunc
         * @brief     vC[Ƃ̂蔻菈
         */
        //------------------------------------------------------------------
        void PlayerHitFunc( void );

        //------------------------------------------------------------------
        /**
         * @name     GetNumHoldChild[const]
         * @brief    ߂܂ꂽq̐擾
         * @return   ߂܂ꂽq̐
         */
        //------------------------------------------------------------------
        u32 GetNumHoldChild( void ) const ;

        //------------------------------------------------------------------
        /**
         * @name      AddScene
         * @brief     V[Ɏgǉ
         */
        //------------------------------------------------------------------
        void AddScene(void);      
      
        //------------------------------------------------------------------
        /**
         * @name      RemoveScene
         * @brief     V[玩g菜
         */
        //------------------------------------------------------------------
        void RemoveScene(void);      

        protected:

        //------------------------------------------------------------------
        /**
         * @name     HoldChild
         * @brief    wIndex(m_ppLostChildField)̖qߊlςݔz(m_ppLostChildHold)Ɉړ
         * @param    index      ړq̔zvfԍ 
         */
        //------------------------------------------------------------------
        void HoldChild( u32 index );



        // ʏϐ
        STATE                           m_State;           // ԕϐ
        
        // IuWFNg
        CLostChild*                     m_pLostChildArray;  // qB̎ 

        CLostChild**                    m_ppLostChildField; // tB[hɂq
        CLostChild**                    m_ppLostChildHold;  // vC[߂܂q 
        u32                             m_NumHoldChild;     // ߂܂ꂽq̐

        CObjectBase*                    m_pLastHold;        // ŌɂqAŏ̓vC[Ă

        // \[X֘A
        gfl::grp::g3d::Resource*        m_pModelRes;       // f\[X
        void*                           m_pBuf;            // 񓯊ǂݍݗpobt@|C^

        gfl::grp::g3d::Resource*        m_pResAnimationArray;    // Aj[V\[X(z)
        void**                          m_ppBufAnimationArray;   // 񓯊ǂݍݗpobt@|C^(z)
        gfl::grp::g3d::ResAnim**        m_ppAnimationArray;      // Aj[VzAς݂nullŔfׂɃ^u|C^
       
        // VXe
        RENTAL_PTR_SET*                 m_pRentalPtrSet;    // w؂Ă|C^ 

        private:
      };

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG

// EOF


