
#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CGameCameraBase.h
 * @brief  [VlC~jQ[]J̃x[X
            Ĵւ̃ANZX3DUtilNXւ̏oSBJEj͔hōs
 * @author junya ikuta
 * @date  2012/05/25() 09:34 
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// sys
#include <grp/g3d/gfl_G3dStereoCamera.h>

// appSys
#include "app/util/app_util_3d.h"

// app


namespace test {
  namespace ikuta {
    namespace game {

      class CGameCameraBase
      {
        GFL_FORBID_COPY_AND_ASSIGN( CGameCameraBase );                // ֎~
        
        public:

        //------------------------------------------------------------------
        /**
         * @name     CGameCameraBase[RXgN^]
         * @brief    ϐ̏s
         */
        //------------------------------------------------------------------
        CGameCameraBase( void );

        //------------------------------------------------------------------
        /**
         * @name     ~CGameCameraBase[fXgN^]
         * @brief    FinalizeĂяo
         */
        //------------------------------------------------------------------
        virtual ~CGameCameraBase();

        //------------------------------------------------------------------
        /**
         * @name      Initialize
         * @brief     
         * @param      pUtil       gZbgUtilNX̃|C^
         * @param      pCamera     hŐJNX̃|C^
         * @return    true : 
         */
        //------------------------------------------------------------------
        bool Initialize( app::util::G3DUtil* pUtil, gfl::grp::g3d::StereoCamera* pCamera);


        //------------------------------------------------------------------
        /**
         * @name     Finalize
         * @brief    I
         */
        //------------------------------------------------------------------
        void Finalize( void );

        //------------------------------------------------------------------
        /**
         * @name      GetCameraAndTargetPosition[const]
         * @brief     JWƃ^[QbgW̎擾
         * @param     pOutPos       JW|C^
         * @param     pOutTarget    ^[QbgW|C^
         */
        //------------------------------------------------------------------
        void GetCameraAndTargetPosition( gfl::math::VEC3* pOutPos, gfl::math::VEC3* pOutTarget ) const;

        //------------------------------------------------------------------
        /**
         * @name      GetCameraPosition[const]
         * @brief     W̎擾
         * @param     pOutPos       JW|C^
         */
        //------------------------------------------------------------------
        void GetCameraPosition( gfl::math::VEC3* pOutPos) const;

        //------------------------------------------------------------------
        /**
         * @name      GetTargetPosition[const]
         * @brief     ^[QbgW̎擾
         * @param     pOutPos       ^[QbgW|C^
         */
        //------------------------------------------------------------------
        void GetTargetPosition( gfl::math::VEC3* pOutPos) const;

        //------------------------------------------------------------------
        /**
         * @name      SetMyself
         * @brief     gUtilNXɃZbg
         */
        //------------------------------------------------------------------
        void SetMyself( void );

        //------------------------------------------------------------------
        /**
         * @name      RemoveMyself
         * @brief     gUtilNXO
         */
        //------------------------------------------------------------------
        void RemoveMyself( void );

        private:

        app::util::G3DUtil*             m_pUtil;                  // JZbgȈՃNX
        gfl::grp::g3d::StereoCamera*    m_pCamera;                // J(؂蕨)

      };

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG


// EOF
