

#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CGameCameraBase.cpp
 * @brief  [VlC~jQ[]J̃x[X
            Ĵւ̃ANZX3DUtilNXւ̏oSBJEj͔hōs
 * @author junya ikuta
 * @date  2012/05/25() 09:34 
 */
///////////////////////////////////////////////////////////////////////////////////////

// appSys

// app
#include "test_ikuta_game_CGameCameraBase.h"

namespace test {
  namespace ikuta {
    namespace game {

        //------------------------------------------------------------------
        /**
         * @name     CGameCameraBase[RXgN^]
         * @brief    ϐ̏s
         */
        //------------------------------------------------------------------
        CGameCameraBase::CGameCameraBase( void ) : 
          m_pUtil( NULL ),
          m_pCamera( NULL )
        {

        }

        //------------------------------------------------------------------
        /**
         * @name     ~CGameCameraBase[fXgN^]
         * @brief    FinalizeĂяo
         */
        //------------------------------------------------------------------
        CGameCameraBase::~CGameCameraBase()
        {
          Finalize();
        }

        //------------------------------------------------------------------
        /**
         * @name      Initialize
         * @brief     
         * @param      pUtil       gZbgUtilNX̃|C^
         * @param      pCamera     hŐJNX̃|C^
         * @return    true : 
         */
        //------------------------------------------------------------------
        bool CGameCameraBase::Initialize( app::util::G3DUtil* pUtil, gfl::grp::g3d::StereoCamera* pCamera)
        {
          m_pUtil = pUtil;
          m_pCamera = pCamera;
          return true;
        }


        //------------------------------------------------------------------
        /**
         * @name     Finalize
         * @brief    I
         */
        //------------------------------------------------------------------
        void CGameCameraBase::Finalize( void )
        {
          m_pUtil = NULL;
          m_pCamera = NULL;
        }

        //------------------------------------------------------------------
        /**
         * @name      GetCameraAndTargetPosition[const]
         * @brief     JWƃ^[QbgW̎擾
         * @param     pOutPos       JW|C^
         * @param     pOutTarget    ^[QbgW|C^
         */
        //------------------------------------------------------------------
        void CGameCameraBase::GetCameraAndTargetPosition( gfl::math::VEC3* pOutPos, gfl::math::VEC3* pOutTarget ) const
        {
          m_pCamera->GetCameraAndTargetPosition(*pOutPos, *pOutTarget);
        }

        //------------------------------------------------------------------
        /**
         * @name      GetCameraPosition[const]
         * @brief     W̎擾
         * @param     pOutPos       JW|C^
         */
        //------------------------------------------------------------------
        void CGameCameraBase::GetCameraPosition( gfl::math::VEC3* pOutPos) const
        {
          m_pCamera->GetCameraPosition(*pOutPos);
        }


        //------------------------------------------------------------------
        /**
         * @name      GetTargetPosition[const]
         * @brief     ^[QbgW̎擾
         * @param     pOutPos       ^[QbgW|C^
         */
        //------------------------------------------------------------------
        void CGameCameraBase::GetTargetPosition( gfl::math::VEC3* pOutPos) const
        {
          m_pCamera->GetTargetPosition(*pOutPos);
        }

        //------------------------------------------------------------------
        /**
         * @name      SetMyself
         * @brief     gUtilNXɃZbg
         */
        //------------------------------------------------------------------
        void CGameCameraBase::SetMyself( void )
        {
          m_pUtil->SetUpperCamera(m_pCamera);
        }

        //------------------------------------------------------------------
        /**
         * @name      RemoveMyself
         * @brief     gUtilNXO
         */
        //------------------------------------------------------------------
        void CGameCameraBase::RemoveMyself( void )
        {
          m_pUtil->RemoveUpperCamera(m_pCamera);
        }

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG


// EOF
