

#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CGameCamera.cpp
 * @brief  [VlC~jQ[]J
 vC[̃|C^ێAǏ]
 J̎̂3DUtilNXĂ܂ÃNXUtil̃JɃANZXĐs܂B
 * @author junya ikuta
 * @date  2012/05/25() 09:34 
 */
///////////////////////////////////////////////////////////////////////////////////////

// appSys

// app
#include "test_ikuta_game_CGameCamera.h"

namespace test {
  namespace ikuta {
    namespace game {

      const gfl::math::VEC3 CAMERA_TARGET_OFFSET(0.0f, 250.0f, -1100.0f);      // ^[Qbg Jʒu 
      const gfl::math::VEC3 CAMERA_OBJECT_TARGET_OFFSET(0.0f, 0.0f, 600.0f);   // ^[QbgIuWF _

      //------------------------------------------------------------------
      /**
       * @name     CGameCamera[RXgN^]
       * @brief    ϐ̏s
       */
      //------------------------------------------------------------------
      CGameCamera::CGameCamera( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name     ~CGameCamera[fXgN^]
       * @brief    FinalizeĂяo
       */
      //------------------------------------------------------------------
      CGameCamera::~CGameCamera()
      {
        Finalize();
      }

      //------------------------------------------------------------------
      /**
       * @name      Initialize
       * @brief     
       * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
       * @pram      rSetUp      [const,default]
       * @return    true : 
       */
      //------------------------------------------------------------------
      bool CGameCamera::Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp)
      {
        // `FbN


        // ܂
        Finalize();

        // ܂؂蕨[
        m_pRentalPtrSet = GFL_NEW( rRentalPtr.pHeap->pHeap )RENTAL_PTR_SET;
        *m_pRentalPtrSet = rRentalPtr;

        // ̑ϐ̏
        m_State = STATE_SLAVE_PLAYER;
        Reset();

        return true;
      }

      //------------------------------------------------------------------
      /**
       * @name     Finalize
       * @brief    I
       */
      //------------------------------------------------------------------
      void CGameCamera::Finalize( void )
      {
        // ϐNA
        m_State = STATE_NULL;
        m_CameraOffset = gfl::math::VEC3::Zero();

        GFL_SAFE_DELETE( m_pRentalPtrSet ); 
      }

      //------------------------------------------------------------------
      /**
       * @name      Update
       * @brief     XV
       * @return    ݂̏
       */
      //------------------------------------------------------------------
      CGameCamera::STATE CGameCamera::Update( void )
      {
        switch( m_State )
        {
        case STATE_SLAVE_PLAYER:

          // vC[ɒǏ
          gfl::math::VEC3 targetPos(0.0f, 0.0f, 0.0f);
          m_pRentalPtrSet->pTargetObject->GetPosition( &targetPos );

          // eItZbg^[Qbǧɍ킹]
          gfl::math::VEC3 targetOffset(CAMERA_TARGET_OFFSET);
          gfl::math::VEC3 objectTargetOffset(CAMERA_OBJECT_TARGET_OFFSET); 
          gfl::math::VEC3 objectRot(m_pRentalPtrSet->pTargetObject->GetRotation());

          gfl::math::MTX34 mat;
          gfl::math::MTX34RotXYZRad( &mat, objectRot.x, objectRot.y, objectRot.z );

          gfl::math::VEC3Transform( &targetOffset, &mat, &targetOffset);
          gfl::math::VEC3Transform( &objectTargetOffset, &mat, &objectTargetOffset);


          m_pRentalPtrSet->pCamera->SetCameraAndTargetPosition(targetPos + targetOffset + objectTargetOffset, targetPos + objectTargetOffset);

          break;
        }
        return m_State;
      }

      //------------------------------------------------------------------
      /**
       * @name     Reset
       * @brief    ϐ̏sAI|C^͂̂܂
       */
      //------------------------------------------------------------------
      void CGameCamera::Reset(void)
      {
        if( m_State != STATE_NULL )
          m_State = STATE_SLAVE_PLAYER;

   //     m_CameraOffset = CAMERA_DEFAULT_OFFSET;
      }

      //------------------------------------------------------------------
      /**
       * @name      GetCameraPosition[const]
       * @brief     W̎擾
       */
      //------------------------------------------------------------------
      void CGameCamera::GetCameraPosition( gfl::math::VEC3* pOutPos) const
      {
        m_pRentalPtrSet->pCamera->GetCameraPosition(*pOutPos);
      }
    #if 0  
      const gfl::math::VEC3& CGameCamera::GetCameraPosition( void ) const
      {
        return m_Pos;
      }
#endif


    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG

// EOF
