#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CProcPlay.cpp
 * @brief  [VlC~jQ[]^CgV[
 ̎dlƂāA\[Xׂ͂čŏɗpӂׁAIuWFNg͑Sďw̎؂蕨łB
 * @author junya ikuta
 * @date   2012/05/18() 09:52
 */
/////////////////////////////////////////////////////////////////////////////////////// 

// Sys

// appSys

// app
#include "test_ikuta_game_CProcPlay.h"
#include "../test_ikuta_game_CSkyBox.h"
#include "../test_ikuta_game_CPlayer.h"
#include "../test_ikuta_game_CLostChildManager.h"
#include "../test_ikuta_game_CGameCamera.h"

// res


namespace test {
  namespace ikuta {
    namespace game{

      // 萔`

      //-------------------------------------------------------------------------------------
      // RXgN^
      //-------------------------------------------------------------------------------------
      CProcPlay::CProcPlay(
          app::util::Heap*                pHeap,          
          gfl::ui::DeviceManager*         pUiDeviceManager,
          gfl::grp::GraphicsSystem*       pGraphicsSystem, 
          app::util::G3DUtil*             pG3dUtil,		     
          gfl::grp::g2d::LytSys*          pLayOutSystem, 
          gfl::math::Random*              pRandom,  
          gamesystem::FrameMode*          pFrameMode,
          const RENTAL_OBJ_PTR_SET&       rRentalObjPtrSet
          ) :
        // NX
        CBase( pHeap, pUiDeviceManager, pGraphicsSystem, pG3dUtil, pLayOutSystem, pRandom, pFrameMode),

        // ʏϐ
        m_State( STATE_NULL ),

        // IuWFNg
        m_pRentalObjPtrSet( NULL )
        {  

          // ܂؂蕨[
          m_pRentalObjPtrSet = GFL_NEW( m_pHeap->pHeap )RENTAL_OBJ_PTR_SET;
          *m_pRentalObjPtrSet = rRentalObjPtrSet;

          // eIuWFNgZbgAbv
          m_pRentalObjPtrSet->pPlayCamera->Message( CPlayCamera::MESSAGE_SETUP_PLAY_START );
          m_pRentalObjPtrSet->pPlayer->Message( CPlayer::MESSAGE_SETUP_PLAY_START );

          // eIuWFNgV[ɒǉ
          m_pRentalObjPtrSet->pPlayCamera->SetMyself();
          m_pRentalObjPtrSet->pPlayer->AddScene();
          m_pRentalObjPtrSet->pSkyBox->AddScene();
          m_pRentalObjPtrSet->pLostChildManager->AddScene();

          // ̑p[^
          m_State = STATE_START;

          m_State = STATE_PLAY;
        }

      //-------------------------------------------------------------------------------------
      // fXgN^
      //-------------------------------------------------------------------------------------
      CProcPlay::~CProcPlay( void )
      {
          m_pRentalObjPtrSet->pPlayCamera->RemoveMyself();
          m_pRentalObjPtrSet->pPlayer->RemoveScene();
          m_pRentalObjPtrSet->pSkyBox->RemoveScene();
          m_pRentalObjPtrSet->pLostChildManager->RemoveScene();
      }

      //-------------------------------------------------------------------------------------
      // XV
      //-------------------------------------------------------------------------------------
      u32 CProcPlay::UpdateImpl( void )
      {
        // A{^ꂽ^Cgɖ߂
        if( m_pButton->IsTrigger( gfl::ui::BUTTON_A ) ) 
        {
          return UPDATE_RESULT_RETURN_TITLE;
        }

        switch(m_State)
        {
        case STATE_START:
          {

            break;
          }
        case STATE_PLAY:
          {
            m_pRentalObjPtrSet->pPlayCamera->Update();
            m_pRentalObjPtrSet->pPlayer->Update();
            m_pRentalObjPtrSet->pLostChildManager->Update();

            break;
          }

        case STATE_END:
          {

            break;
          }
        }

        // 3DV[̍XV
        m_pG3dUtil->CalculateG3dScene();
        m_pG3dUtil->Update3D( false );

        return UPDATE_RESULT_CONTINUE;
      }


      //-------------------------------------------------------------------------------------
      // `揈
      //-------------------------------------------------------------------------------------
      void CProcPlay::DrawImpl( void )
      {
        //  m_pRentalObjPtrSet->pTree->Draw();
        // m_pRentalObjPtrSet->pSkyBox->Draw();
        //   m_pRentalObjPtrSet->pPlayCamera->Draw();


        m_pG3dUtil->Draw3D( m_pGraphicsSystem );
      }

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG
