
#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CPlayCamera.cpp
 * @brief  [VlC~jQ[]Q[J
            ŏɃ^CgJႤ
 * @author junya ikuta
 * @date  2012/05/25() 09:34 
 */
///////////////////////////////////////////////////////////////////////////////////////

// appSys

// app
#include "test_ikuta_game_CPlayCamera.h"        
#include "../resource/test_ikuta_game_resource_Camera.h"



namespace test {
  namespace ikuta {
    namespace game {


      //------------------------------------------------------------------
      /**
       * @name     CPlayCamera[RXgN^]
       * @brief    ϐ̏s
       */
      //------------------------------------------------------------------
      CPlayCamera::CPlayCamera( void ) : 
        m_State(STATE_NULL),
        m_StateEndFlag( false ),
        m_pRentalPtrSet( NULL ),
        m_pCamera( NULL )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name     ~CPlayCamera[fXgN^]
       * @brief    FinalizeĂяo
       */
      //------------------------------------------------------------------
      CPlayCamera::~CPlayCamera()
      {
        Finalize();
      }


      //------------------------------------------------------------------
      /**
       * @name      Initialize
       * @brief     A[hI܂ŊĂ܂B 
       * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
       * @pram      rSetUp      [const]
       * @return    true : 
       */
      //------------------------------------------------------------------
      bool CPlayCamera::Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp)
      {
        // `FbN


        // ܂؂蕨[
        m_pRentalPtrSet = GFL_NEW( rRentalPtr.pHeap->pHeap )RENTAL_PTR_SET;
        *m_pRentalPtrSet = rRentalPtr;

        // JAŃ^CgJɃZbgAbv̂ŉԂł悢
		    m_pCamera = GFL_NEW( m_pRentalPtrSet->pHeap->pHeap ) gfl::grp::g3d::StereoCamera();
			  m_pCamera->Create( m_pRentalPtrSet->pHeap->pDevHeapAllocator, gfl::grp::g3d::Camera::CAMERA_POSITION_DEFAULT );

        // NXɃ|C^
        CGameCameraBase::Initialize(m_pRentalPtrSet->pUtil, m_pCamera);

        m_State = STATE_WAIT;
        m_StateEndFlag = false;
        return true;
      }

      //------------------------------------------------------------------
      /**
       * @name     Reset
       * @brief    p[^AInitializeɐ퓮AInitializȅԂɂȂ
       */
      //------------------------------------------------------------------
      void CPlayCamera::Reset( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name     Finalize
       * @brief    I
       */
      //------------------------------------------------------------------
      void CPlayCamera::Finalize( void )
      {
    
      }

      //------------------------------------------------------------------
      /**
       * @name      Update
       * @brief     XVA[hLoadUpdate𐄏
       * @return    ݂̏
       */
      //------------------------------------------------------------------
      CPlayCamera::STATE CPlayCamera::Update( void )
      {
        if( m_StateEndFlag )
          return m_State;

        switch( m_State )
        {
        case STATE_WAIT:
          break;

        case STATE_PLAY:    
              // Ƃ肠ړ
              gfl::math::VEC3 pos, target;
              m_pCamera->GetCameraAndTargetPosition(pos, target);
              pos.z += 10.0f;
              target.z += 10.0f;
              m_pCamera->SetCameraAndTargetPosition(pos, target);
          break;
        }

        return m_State;
      }

        //------------------------------------------------------------------
        /**
         * @name      Message
         * @brief     ÕbZ[W
         * @param     message     bZ[Wʎq
         * @return    true : K؂ɏꂽ
         */
        //------------------------------------------------------------------
        b32 CPlayCamera::Message(MESSAGE message)
        {
          switch( message )
          {
            case MESSAGE_SETUP_PLAY_START :        // ʏvCJnԂɃZbgAbv
            {
              m_State = STATE_PLAY;
              m_StateEndFlag = false;

              // ^CgJ̏Ԃɍ킹
              gfl::math::VEC3 pos, target;
              m_pRentalPtrSet->pTitleCamera->GetCameraAndTargetPosition(&pos, &target);

              m_pCamera->SetCameraAndTargetPosition(pos, target);

              return true;
            }
          }

          return false;
        }

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG


// EOF
