//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		debug_zukan.cpp
 *	@brief  }ӑpfobO
 *	@author	Toru=Nagihashi
 *	@date		2012.05.29
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <debug/debug_zukan.h>
#include <debug/debug_ui.h>
#include <system/gfl_use.h>

GFL_NAMESPACE_BEGIN(xy_debug)

void DebugZukan::Initialize( gfl::heap::HeapBase *heap, savedata::ZukanData *zukan_save )
{
  m_cursor = 0;

  m_zukan_save  = zukan_save;
  
  if( m_msg_data == NULL )
  {
    //m_msg_data  = GFL_NEW( heap ) gfl::str::MsgData(  );
  }
  
  if( m_poke_number == NULL )
  {
    m_poke_number = GFL_NEW( heap) poke_tool::PokeNumber( heap );
  }
  
  if( m_core_param == NULL )
  {
    m_core_param = GFL_NEW(heap) pml::pokepara::CoreParam( heap );
  }
}

void DebugZukan::Finalize( void )
{
  GFL_SAFE_DELETE( m_core_param );

  GFL_SAFE_DELETE( m_poke_number );

  //GFL_SAFE_DELETE( m_msg_data );
}
  
//S}ӁEn}
void DebugZukan::Update_ZukanMode( void* userWork, gfl::debug::DebugWinItem* item )
{
  if( DebugButton::IsTrigger( gfl::ui::BUTTON_A ) )
  {
    savedata::ZukanData::Mode mode = m_zukan_save->GetZukanMode();
    mode = mode == savedata::ZukanData::MODE_LOCAL ? savedata::ZukanData::MODE_ZENKOKU: savedata::ZukanData::MODE_LOCAL;
    m_zukan_save->SetZukanMode( mode );
  }
}

wchar_t* DebugZukan::Draw_ZukanMode( void* userWork, gfl::debug::DebugWinItem* item )
{
  wchar_t* workStr = GFL_SINGLETON_INSTANCE(gfl::debug::DebugWin)->GetWorkStr();
  swprintf( workStr, gfl::debug::DEBUGWIN_NAME_LEN, L"%ls[%d]",item->GetName(), m_zukan_save->GetZukanMode() );
  return workStr;
}

//}Ӗ߁@EŁ@ߊlEE_
void DebugZukan::Update_Register( void* userWork, gfl::debug::DebugWinItem* item )
{
  enum
  {
    LOCAL_CAPTURE_COMPLETE,
    LOCAL_SEE_COMPLETE,
    LOCAL_RANDOM,
    ZENKOKU_CAPTURE_COMPLETE,
    ZENKOKU_SEE_COMPLETE,
    ZENKOKU_RANDOM,
    
    MAX
  };
  
  if( DebugButton::IsTrigger( gfl::ui::BUTTON_LEFT ) )
  {
    m_cursor--;
    if( m_cursor < 0 )
    {
      m_cursor  = MAX-1;
    }
  }
  if( DebugButton::IsTrigger( gfl::ui::BUTTON_RIGHT ) )
  {
    m_cursor++;
    m_cursor  %= MAX;
  }
  

  if( DebugButton::IsTrigger( gfl::ui::BUTTON_A ) )
  {
    switch( m_cursor )
    {
    case LOCAL_CAPTURE_COMPLETE:
      for( int i = 1; i < MONSNO_END; ++i )
      {
        if( m_poke_number->IsLocalZukan( static_cast<MonsNo>(i) ) )
        {
          m_core_param->ChangeMonsNo( static_cast<MonsNo>(i), 0 );
          m_zukan_save->SetPokeGet( *m_core_param );
        }
      }
      break;
    case LOCAL_SEE_COMPLETE:
      for( int i = 1; i < MONSNO_END; ++i )
      {
        if( m_poke_number->IsLocalZukan( static_cast<MonsNo>(i) ) )
        {
          m_core_param->ChangeMonsNo( static_cast<MonsNo>(i), 0 );
          m_zukan_save->SetPokeSee( *m_core_param );
        }
      }
      break;
    case LOCAL_RANDOM:
      for( int i = 1; i < MONSNO_END; ++i )
      {
        if( m_poke_number->IsLocalZukan( static_cast<MonsNo>(i) ) )
        {
          m_core_param->ChangeMonsNo( static_cast<MonsNo>(i), 0 );
          switch( xy_system::GflUse::GetPublicRand( 3 ) )
          {
          case 0:
            m_zukan_save->SetPokeSee( *m_core_param );
            break;
          case 1:
            m_zukan_save->SetPokeGet( *m_core_param );
            break;
          }
        }
      }
      break;
    case ZENKOKU_CAPTURE_COMPLETE:
      for( int i = 1; i < MONSNO_END; ++i )
      {
        m_core_param->ChangeMonsNo( static_cast<MonsNo>(i), 0 );
        m_zukan_save->SetPokeGet( *m_core_param );
      }
      break;
    case ZENKOKU_SEE_COMPLETE:
      for( int i = 1; i < MONSNO_END; ++i )
      {
        m_core_param->ChangeMonsNo( static_cast<MonsNo>(i), 0 );
        m_zukan_save->SetPokeSee( *m_core_param );
      }
      break;
    case ZENKOKU_RANDOM:
      for( int i = 1; i < MONSNO_END; ++i )
      {
        m_core_param->ChangeMonsNo( static_cast<MonsNo>(i), 0 );
        switch( xy_system::GflUse::GetPublicRand( 3 ) )
        {
        case 0:
          m_zukan_save->SetPokeSee( *m_core_param );
          break;
        case 1:
          m_zukan_save->SetPokeGet( *m_core_param );
          break;
        }
      }
      break;
    }
  }
}
wchar_t* DebugZukan::Draw_Register( void* userWork, gfl::debug::DebugWinItem* item )
{
  wchar_t* workStr = GFL_SINGLETON_INSTANCE(gfl::debug::DebugWin)->GetWorkStr();
  
  static const wchar_t* label[] =
  {
    L"nߊlRv",
    L"nRv",
    L"n_",
    L"SߊlRv",
    L"SRv",
    L"S_",
  };

  swprintf( workStr, gfl::debug::DEBUGWIN_NAME_LEN, L"%ls[%ls]",item->GetName(), label[m_cursor] );
  return workStr;
}

//tH
void DebugZukan::Update_Form( void* userWork, gfl::debug::DebugWinItem* item )
{ 
  if( DebugButton::IsTrigger( gfl::ui::BUTTON_A ) )
  {
    for( int i = 1; i < MONSNO_END; ++i )
    {
      for( int j = 0; j < m_zukan_save->GetFormMax( static_cast<MonsNo>(i) ); ++j )
      {
        m_core_param->ChangeMonsNo( static_cast<MonsNo>(i), j );
        m_zukan_save->SetPokeGet( *m_core_param );
      }
    }
  }
}

wchar_t* DebugZukan::Draw_Form( void* userWork, gfl::debug::DebugWinItem* item )
{
  wchar_t* workStr = GFL_SINGLETON_INSTANCE(gfl::debug::DebugWin)->GetWorkStr();
  swprintf( workStr, gfl::debug::DEBUGWIN_NAME_LEN, L"%ls",item->GetName() );
  return workStr;
}

//Rv
void DebugZukan::Update_Language( void* userWork, gfl::debug::DebugWinItem* item )
{
  static const u32 language[] =
  {
    LANG_JAPAN,
    LANG_ENGLISH,
    LANG_FRANCE,
    LANG_ITALY,  
    LANG_GERMANY,
    LANG_SPAIN,  
    LANG_KOREA,  
  };

  if( DebugButton::IsTrigger( gfl::ui::BUTTON_A ) )
  {
    for( int i = 1; i < MONSNO_END; ++i )
    {
      for( int j = 0; j < GFL_NELEMS(language); ++j )
      {
        m_core_param->ChangeMonsNo( static_cast<MonsNo>(i), 0 );
        m_core_param->SetCountryCode( language[j] );
        m_zukan_save->SetPokeGet( *m_core_param );
      }
    }
  }
}

wchar_t* DebugZukan::Draw_Language( void* userWork, gfl::debug::DebugWinItem* item )
{
  wchar_t* workStr = GFL_SINGLETON_INSTANCE(gfl::debug::DebugWin)->GetWorkStr();
  swprintf( workStr, gfl::debug::DEBUGWIN_NAME_LEN, L"%ls",item->GetName() );
  return workStr;
}

gfl::str::MsgData * DebugZukan::GetMsgData( void )
{
  return m_msg_data;
}

savedata::ZukanData *DebugZukan::m_zukan_save  = NULL;
gfl::str::MsgData *DebugZukan::m_msg_data  = NULL;
int DebugZukan::m_cursor = 0;
poke_tool::PokeNumber *DebugZukan::m_poke_number = NULL;
pml::pokepara::CoreParam *DebugZukan::m_core_param = NULL;

GFL_NAMESPACE_END(xy_debug)
