
//=============================================================================
/**
 * @file   CameraDebug.h
 * @brief  fobOJNXwb_
 * @author rc N
 * @date   2012.05.28
 */
//=============================================================================

#ifndef __CAMERA_DEBUG_H__
#define __CAMERA_DEBUG_H__

namespace field
{
  //-----------------------------------------------------------------------------
  /**
   * @brief fobOJ̐sNX
   */
  //-----------------------------------------------------------------------------
  class CCameraDebug
  {
  public:
    /**
     * @brief ^Cv񋓌^
     */
    enum EType
    {
      TYPE_NONE   = 0 , ///< 䂵Ȃ
      TYPE_GLOBAL     , ///< O[o^Cv
      TYPE_TARGET     , ///< ^[Qbg^Cv
    };

  private:
    EType m_eType; ///< ^Cv

    gfl::math::VEC3 m_inPosi; ///< ʒu
    float m_fYaw;   ///< [p
    float m_fPitch; ///< ҂p

    ///< _ItZbg(^[Qbg^CvŎgp)
    gfl::math::VEC3 m_inLookAtOfst;

  public:
    CCameraDebug(); ///< RXgN^

    //-----------------------------------------------------------------------------
    /**
     * @brief fobOJJn
     *
     * @param eType        ^Cv
     * @param inPosi       JñJʒu
     * @param inLookAtPosi Jn̒_ʒu
     * @param inPlayerPosi vC̈ʒu
     */
    //-----------------------------------------------------------------------------
    void Begin(const EType eType, const gfl::math::VEC3& inPosi, const gfl::math::VEC3& inLookAtPosi, const gfl::math::VEC3& inPlayerPosi);

    /// fobOJI
    void End() { m_eType = TYPE_NONE; }

    //-----------------------------------------------------------------------------
    /**
     * @brief t[
     *
     * @param pPosi o̓Jʒu
     * @param pDir  o̓J
     * @param pUIDeviceManager ̓foCXǗNX
     * @param inPlayerPosi     vC̈ʒu
     * @param fDiffTime        oߎ(b)
     *
     * @retval true  JXVꂽ
     * @retval false JXVȂ
     */
    //-----------------------------------------------------------------------------
    bool Update(gfl::math::VEC3* pPosi, gfl::math::VEC3* pDir, const gfl::ui::DeviceManager* pUIDeviceManager, const gfl::math::VEC3& inPlayerPosi, const float fDiffTime);

    //-----------------------------------------------------------------------------
    /**
     * @brief @\
     *
     * @param pGraphicsSystem OtBbNXVXe
     * @param inPlayerPosi    vC̈ʒu
     */
    //-----------------------------------------------------------------------------
    void DispText(gfl::grp::GraphicsSystem* pGraphicsSystem, const gfl::math::VEC3& inPlayerPosi) const ;

    // fobOJ`FbN
    bool IsAct() const { return (m_eType != TYPE_NONE); }
  };

} // namespace field

#endif // __CAMERA_DEBUG_H__

/*  EOF  */





