
//=============================================================================
/**
 * @file   CameraDebug.cpp
 * @brief  fobOJNX
 * @author rc N
 * @date   2012.05.28
 */
//=============================================================================

#include "CameraDebug.h"
#include "CameraSpace.h"
#include "CameraUtility.h"

namespace field
{
  //-----------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------
  CCameraDebug::CCameraDebug() :
  m_eType(TYPE_NONE) ,
  m_inPosi(gfl::math::VEC3_ZERO) ,
  m_fYaw(0.0f) ,
  m_fPitch(0.0f) ,
  m_inLookAtOfst(gfl::math::VEC3_ZERO)
  {
  }

  //-----------------------------------------------------------------------------
  // fobOJJn
  //-----------------------------------------------------------------------------
  void CCameraDebug::Begin(const EType eType, const gfl::math::VEC3& inPosi, const gfl::math::VEC3& inLookAtPosi, const gfl::math::VEC3& inPlayerPosi)
  {
    m_eType  = eType;
    m_inPosi = inPosi;

    gfl::math::VEC3 inDir = inLookAtPosi - inPosi;
    gfl::math::VEC3Normalize(&inDir, &inDir);
    CSpace::GetYawPitchByDirection(&m_fYaw, &m_fPitch, inDir);

    if( eType == TYPE_TARGET )
    {
      gfl::math::MTX33 inLocalMat;
      CSpace::CreateMTX33ByFrontUpDirection(&inLocalMat, inDir, gfl::math::VEC3_UNIT_Y);
      gfl::math::MTX33Transpose(&inLocalMat, &inLocalMat);
      m_inLookAtOfst = inPlayerPosi - inPosi;
      gfl::math::VEC3Transform(&m_inLookAtOfst, &inLocalMat, &m_inLookAtOfst); // JԊ̃ItZbgɕϊ
    }
    else
      m_inLookAtOfst = gfl::math::VEC3_ZERO;
  }

  //-----------------------------------------------------------------------------
  // t[
  //-----------------------------------------------------------------------------
  bool CCameraDebug::Update(gfl::math::VEC3* pPosi, gfl::math::VEC3* pDir, const gfl::ui::DeviceManager* pUIDeviceManager, const gfl::math::VEC3& inPlayerPosi, const float fDiffTime)
  {
    if( IsAct() == true )
    {
      const float PITCH_MAX = GFL_MATH_DEG_TO_RAD(85.0f);
      const gfl::ui::Button*       pButton = pUIDeviceManager->GetButton(gfl::ui::CTR_DeviceManager::BUTTON_STANDARD);
      const gfl::ui::VectorDevice* pStick  = pUIDeviceManager->GetStick (gfl::ui::CTR_DeviceManager::STICK_STANDARD);
      const float fInputX   = pStick->GetX();
      const float fInputY   = pStick->GetY();
      const bool  bIsMoveXY = pButton->IsHold(gfl::ui::BUTTON_A);
      const bool  bIsMoveXZ = pButton->IsHold(gfl::ui::BUTTON_Y);
      float fMulCoe = fDiffTime; if( pButton->IsHold(gfl::ui::BUTTON_R) ) fMulCoe *= 2.0f;

      switch( m_eType )
      {
      case TYPE_GLOBAL: {
        const float fRotParam  =   2.0f;
        const float fMoveParam = 150.0f;

        if( bIsMoveXY || bIsMoveXZ )
        {
          fMulCoe *= fMoveParam;
          gfl::math::MTX33 inMat; CSpace::GetYawPitchBankRotMatrix(&inMat, gfl::math::VEC3(m_fYaw, m_fPitch, 0.0f));
          gfl::math::MTX33GetAxisZ(pDir, inMat);

          gfl::math::VEC3 inAxisX; gfl::math::MTX33GetAxisX(&inAxisX, inMat);
          m_inPosi += inAxisX*(-fMulCoe*fInputX); // E

          if( bIsMoveXY == true )
          {
            gfl::math::VEC3 inAxisY; gfl::math::MTX33GetAxisY(&inAxisY, inMat);
            m_inPosi += inAxisY*(fMulCoe*fInputY); // ㉺
          }
          else
            m_inPosi += (*pDir)*(fMulCoe*fInputY); // s
        }
        else
        {
          fMulCoe *= fRotParam;
          m_fYaw    = CUtil::AddRadian(m_fYaw, -fInputX*fMulCoe);
          m_fPitch -= fInputY*fMulCoe; CUtil::MaxMinClip(&m_fPitch, PITCH_MAX, -PITCH_MAX);
          CSpace::GetDirectionByYawPitch(pDir, m_fYaw, m_fPitch);
        }

        break; }

      case TYPE_TARGET: {
        const float fRotParam  =   2.8f;
        const float fMoveParam = 150.0f;
        fMulCoe *= -1.0f;

        if( bIsMoveXY || bIsMoveXZ )
        {
          fMulCoe *= fMoveParam;
          m_inLookAtOfst.x += -fMulCoe*fInputX;

          if( bIsMoveXY ) m_inLookAtOfst.y += fMulCoe*fInputY;
          else            m_inLookAtOfst.z += fMulCoe*fInputY;
        }
        else
        {
          fMulCoe *= fRotParam;
          m_fYaw    = CUtil::AddRadian(m_fYaw, -fInputX*fMulCoe);
          m_fPitch -= fInputY*fMulCoe; CUtil::MaxMinClip(&m_fPitch, PITCH_MAX, -PITCH_MAX);
        }

        gfl::math::MTX33 inMat;  CSpace::GetYawPitchBankRotMatrix(&inMat, gfl::math::VEC3(m_fYaw, m_fPitch, 0.0f));
        gfl::math::VEC3  inOfst; gfl::math::VEC3Transform(&inOfst, &inMat, &m_inLookAtOfst); // _ItZbg[hԊɕϊ

        gfl::math::MTX33GetAxisZ(pDir, inMat);
        m_inPosi = inPlayerPosi - inOfst;

        break; }
      }

      (*pPosi) = m_inPosi;
      return true;
    }
    else
      return false;
  }

  //-----------------------------------------------------------------------------
  // @\
  //-----------------------------------------------------------------------------
  void CCameraDebug::DispText(gfl::grp::GraphicsSystem* pGraphicsSystem, const gfl::math::VEC3& inPlayerPosi) const
  {
    if( IsAct() == true )
    {
      gfl::math::VEC3 inDir; CSpace::GetDirectionByYawPitch(&inDir, m_fYaw, m_fPitch);
      float fDist = CUtil::GetAxisLength(inPlayerPosi - m_inPosi, inDir); CUtil::MinClip(&fDist, CONVERT_TO_METER(0.01f));
      const gfl::math::VEC3 inOfst = m_inPosi + inDir*fDist - inPlayerPosi;

      gfl::grp::RenderTarget* pLowerBuf = pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_LOWER);
      pGraphicsSystem->BindCurrentCommandList(pLowerBuf);
      gfl::grp::util::DrawUtil::BeginRender(pLowerBuf);
      gfl::grp::util::DrawUtil::SetTextScale(0.5f, 0.5f);

      const int x = 15;
      int y = 32, offset_y = 15;
      gfl::grp::util::DrawUtil::SetTextColor(VEC4_COLOR_WHITE);
      gfl::grp::util::DrawUtil::DrawText(x, y, L"AiÔ݁F㉺E]"); y += offset_y;
      gfl::grp::util::DrawUtil::DrawText(x, y, L"`{AiOF㉺Eړ"); y += offset_y;
      gfl::grp::util::DrawUtil::DrawText(x, y, L"x{AiOFsEړ"); y += offset_y;
      gfl::grp::util::DrawUtil::DrawText(x, y, L"qƔ{");       y += offset_y;

      y += 10;
      gfl::grp::util::DrawUtil::SetTextColor(VEC4_COLOR_THIN_GREEN);
      gfl::grp::util::DrawUtil::DrawText(x, y, L"㉺pxF%.2f", GFL_MATH_RAD_TO_DEG(-m_fPitch)); y += offset_y;
      gfl::grp::util::DrawUtil::DrawText(x, y, L"EpxF%.2f", GFL_MATH_RAD_TO_DEG(-CUtil::AddRadian(m_fYaw, gfl::math::F_PI))); y += offset_y;
      gfl::grp::util::DrawUtil::DrawText(x, y, L"ΏۋF%.2f", fDist);    y += offset_y;
      gfl::grp::util::DrawUtil::DrawText(x, y, L"ItZwF%.2f", inOfst.x); y += offset_y;
      gfl::grp::util::DrawUtil::DrawText(x, y, L"ItZxF%.2f", inOfst.y); y += offset_y;
      gfl::grp::util::DrawUtil::DrawText(x, y, L"ItZyF%.2f", inOfst.z); y += offset_y;

      gfl::grp::util::DrawUtil::EndRender();
    }
  }

} // namespace field

/*  EOF  */





