#ifndef __FIXICON_H__
#define __FIXICON_H__

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   FixIcon.h
 *  @brief  vC[ACŘŒACR
 *  @author Koji Kawada
 *  @date   2012.05.29
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <gflib.h>

// player_icon
#include "system/player_icon/PlayerFixIconID.h"
#include "system/player_icon/PlayerIconManager.h"
#include "PlayerIcon.h"


namespace xy_system {
namespace player_icon {


//-----------------------------------------------------------------------------
/**
 *          NX錾
 */
//-----------------------------------------------------------------------------

//-------------------------------------
/// vC[ACŘŒACR
//=====================================
class FixIcon : public PlayerIcon
{
  GFL_FORBID_COPY_AND_ASSIGN(FixIcon);

  friend class PlayerIconManager;

  
  ///////////////////////////////////////////////////////////
  //
  // NX̊֐
  //
  ///////////////////////////////////////////////////////////
protected:
  // RXgN^
  FixIcon(void);

  // fXgN^
  virtual ~FixIcon();
 
  virtual void RequestCreate(
    PlayerIconManager* manager,
    s32 req_id,
    gfl::heap::HeapBase* heap_memory,
    gfl::heap::HeapBase* device_memory,
    void* image,
    const PlayerFixIconID fix_id
  );

  virtual void Update(void);

protected:
  virtual void startCreate(void);
  virtual void destroy(void);


  ///////////////////////////////////////////////////////////
  //
  // ̃NX̊֐
  //
  ///////////////////////////////////////////////////////////
protected:
  // ǂݍރt@C߂āAǂݍ݊Jn
  virtual void startFileRead(void);

  // t@C̓ǂݍ݊`FbN
  virtual b32 isFileReadFinished(void);

  // ǂݍ݃obt@
  virtual void clearBuffer(void);


  ///////////////////////////////////////////////////////////
  //
  // hNXŎė~z֐
  //
  ///////////////////////////////////////////////////////////
protected:
  // ǂݍރt@Carcdatid𓾂
  virtual s32 getFixIconArcdatidFromFixID(s32 fix_id) = 0; 


  ///////////////////////////////////////////////////////////
  //
  // ̃NX̕ϐ
  //
  ///////////////////////////////////////////////////////////
private:
  // 萔 
  enum
  {
    ICONFIXID_NONE = -1  // PlayerFixIconIDȂƂ
  };

private:
  s32 m_fix_id;  // PlayerFixIconID  or  ICONFIXID_NONE

  s32 m_arcdatid;  // gfl::fs::ArcFile::ARCDATID  or  ICONARCDATID_NONE
  void* m_buffer;
  u32   m_buffer_size;
};


} // namespace player_icon
} // namespace xy_system

#endif  // __FIXICON_H__

