//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   FixIcon.cpp
 *  @brief  vC[ACŘŒACR
 *  @author Koji Kawada
 *  @date   2012.05.29
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <gflib.h>

// color
#include "../../color/MulColor.h"
// app
#include "app/tool/app_tool_PaletteTextureExport.h"

// player_icon
#include "system/player_icon/PlayerFixIconID.h"
#include "system/player_icon/PlayerIconManager.h"
#include "PlayerIcon.h"
#include "FixIcon.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 
#include "arc/player_icon.gaix"


namespace xy_system {
namespace player_icon {


FixIcon::FixIcon(void)
  : PlayerIcon(),
    m_fix_id(ICONFIXID_NONE),
    m_arcdatid(ICONARCDATID_NONE),
    m_buffer(NULL),
    m_buffer_size(0)
{
  // Ȃ
}

FixIcon::~FixIcon()
{
  destroy();
}

void FixIcon::RequestCreate(
    PlayerIconManager* manager,
    s32 req_id,
    gfl::heap::HeapBase* heap_memory,
    gfl::heap::HeapBase* device_memory,
    void* image,
    const PlayerFixIconID fix_id
)   
{
  // NX
  {
    PlayerIcon::RequestCreate(
        manager,
        req_id,
        heap_memory,
        device_memory,
        image
    );
  }

  // ̃NX
  {
    m_fix_id = fix_id;
  
    // ł
    m_state = STATE_WAIT_TO_CREATE;  // m_stateύX
  }
}

void FixIcon::Update(void)
{
  // NGXg̏
  {
    switch(m_req)
    {
    case REQ_DESTROY:
      switch( m_state )
      {
      case STATE_WAIT_TO_CREATE:
        // Jn҂ĂԂȂ̂łłjł
      case STATE_CREATED:
        // ς݂Ȃ̂łłjł
        {
          destroy();
          // destroyŏꂽԂAK؂ȏԂɕύX
          m_state = STATE_NEED_TO_BE_DESTROYED;  // m_stateύX
          break;
        }
      case STATE_CREATING:
        {
          // Ȃ̂ŁAjɕύX
          m_state = STATE_DESTROYING;  // m_stateύX
          break;
        }
      }
      break;
    }
    m_req = REQ_NONE;
  }

  // 
  {
    switch(m_state)
    {
    case STATE_WAIT_TO_CREATE:
      {
        if( m_manager->GetPlayerIconData() )
        {
          startCreate();
          //breakȂ
        }
        else
        {
          break;
        }
      }
    case STATE_CREATING:
      {
        if( isFileReadFinished() )
        {
          // ǂݍݒ̂̂ǂݍݏÎŁA摜I
          if( m_buffer && m_buffer_size > 0 )  // ُ픭ɉɏIł悤ɂĂ
          {
            // t@C𓀂
            {
              void* tmp = m_buffer;
              gfl::cx::StreamingUncomp uncomp;
              uncomp.InitUncompPackage(m_device_memory, tmp, m_buffer_size, &(m_buffer));
              u32 ret = uncomp.SecureUncomp();
              GFL_ASSERT_STOP_MSG(ret==0, "StreamingUncomp SecureUncomp Error %d\n", ret);
              m_buffer_size = nn::cx::GetUncompressedSize(tmp);
              // pbg`ʏ
              app::tool::PaletteTexture::Export(m_buffer, m_buffer_size, m_device_memory);
              GflHeapFreeMemory(tmp);
            } 
            
            alphaBlendTexture(m_image, m_buffer, m_buffer_size);
          }
          clearBuffer();
          // Ԃ𐶐ς݂ɕύX
          m_state = STATE_CREATED;   // m_stateύX
        }
        break;
      }
    case STATE_DESTROYING:
      {
        if( isFileReadFinished() )
        {
          // IsAbleToDestroyʂ悤ɁAԂύX
          m_state = STATE_WAIT_TO_DESTROY;  // m_stateύX
          // ǂݍݒ̂̂ǂݍݏÎŁAj
          destroy();
          // destroyŏꂽԂAK؂ȏԂɕύX
          m_state = STATE_NEED_TO_BE_DESTROYED;  // m_stateύX
        }
        break;
      }
    }
  }
}

void FixIcon::startCreate(void)
{
  // NX
  PlayerIcon::startCreate();
 
  // ̃NX  
  // ŏ̓ǂݍ݂Jn
  startFileRead();
  // Jnł
  m_state = STATE_CREATING;  // m_stateύX
}

void FixIcon::destroy(void)
{
  // ͔jłȂ̂ŏłȂƂɌĂԂƁB
  if( !IsAbleToDestroy()  ) 
  {
    GFL_ASSERT_STOP_MSG(0, "m_req_id=%d͏̂ߔjł܂B\n", m_req_id);  // @todo t@C[h}l[W̏܂fłȂ̂ŁASTOP邱Ƃɂ܂Bfł悤ɂȂSTOPȂ悤ɂ܂B

    while( !isFileReadFinished() )
    {
      nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(1) );
    }
  }

  // ̃NX
  if( m_buffer )
  {
    GflHeapFreeMemory(m_buffer);
  }

  // RXgN^Ɠ
  m_fix_id = ICONFIXID_NONE;
  m_arcdatid = ICONARCDATID_NONE;
  m_buffer = NULL;
  m_buffer_size = 0;
  
  // NX
  PlayerIcon::destroy();
}

void FixIcon::startFileRead(void)
{
  const PlayerIconData* data = m_manager->GetPlayerIconData();
  
  b32 ret = false;

  // ǂݍރt@Carcdatid𓾂
  s32 arcdatid = getFixIconArcdatidFromFixID(m_fix_id);
  //GFL_ASSERT_MSG(arcdatid>=0, "m_fix_id=%dُłB\n", m_fix_id);  // @todo m_fix_idُ̂ƂAǂΉ邩H

  m_arcdatid = arcdatid;
  
  if( m_arcdatid >= 0 )
  {
    // ǂݍ݂Jn
    m_manager->GetFileReadManager()->AddReadRequest(
        &(m_buffer), 
        &(m_buffer_size),
        m_device_memory,
        128, 
        ARCID_PLAYER_ICON,
        m_arcdatid,
        false,
        gfl::fs::FileReadManager::REQUEST_PRIORITY_NORMAL
    );
  }
  // elseƂȂꍇ́ÂȂďIB
}

b32 FixIcon::isFileReadFinished(void)
{
  if( m_arcdatid >= 0 )
  {
    return m_manager->GetFileReadManager()->IsReadFinished(&(m_buffer));
  }
  else
  {
    // ǂݍłȂƂtrueԂ
    return true;
  }
}

void FixIcon::clearBuffer(void)
{
  if( m_buffer )
  {
    GflHeapFreeMemory(m_buffer);
  }
  m_arcdatid = ICONARCDATID_NONE;
  m_buffer = NULL;
  m_buffer_size = 0;
}


} // namespace player_icon
} // namespace xy_system

