//============================================================================================
/**
 * @brief WifiڑssNX
 */
//============================================================================================
#include <netapp/wifi/WifiConnectRunner.h>
#include <net/net_define.h>

namespace netapp {
namespace wifi {



//------------------------------------------------------------------
/**
 * @brief   RXgN^
 */
//------------------------------------------------------------------
WifiConnectRunner::WifiConnectRunner() :
    gflnet::friends::FriendLoginListener(),
    gflnet::nex::NexGameServerListener(),
    gflnet::nex::NexErrorListener(),
    m_isError(false),
    m_isFinish(false),
    m_isFriendLoginFinish(false),
    m_isGameServerLoginFinish(false),
    m_isGameServerLogoutFinish(false),
    m_step(0),
    m_counter(0)
{
  m_friendMgr      = GFL_SINGLETON_INSTANCE(gflnet::friends::FriendManager);
  m_nexMgr         = GFL_SINGLETON_INSTANCE(gflnet::nex::NexManager);
  m_subscrptionMgr = GFL_SINGLETON_INSTANCE(netapp::subscription::SubscriptionManager);

  m_nexMgr->SetGameServerListener( this );
  m_nexMgr->SetNexErrorListener( this );
}

//------------------------------------------------------------------
/**
 * @brief   fXgN^
 */
//------------------------------------------------------------------
WifiConnectRunner::~WifiConnectRunner()
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   XV
 *
 * @param   none
 *
 * @return  Xe[^XR[h
 */
//--------------------------------------------------------------------------------------------
WifiConnectRunner::E_RET_CODE WifiConnectRunner::Update( void )
{
  Connect();

  if( m_isError )
  {
    return E_RET_FAILED;
  }
  else if( IsFinished() )
  {
    return E_RET_SUCCESS;
  }

  return E_RET_CONTINUE;
}


//------------------------------------------------------------------
/**
 * @brief G[ʂւ̑J
 * @param result G[Ugl
 */
//------------------------------------------------------------------
void WifiConnectRunner::GotoErrorView( nn::Result &result )
{
  /*
  if( result == nn::ac::ResultNotFoundAccessPoint() )
  {
    //mmo::ui::ErrorView::SetErrorCode( mmo::ui::E_ERR_NOT_FOUND_AP );
  }
  else if( result == nn::ac::ResultWifiOff() )
  {
    //mmo::ui::ErrorView::SetErrorCode( mmo::ui::E_ERR_WIFI_OFF );
  }
  else if( result == nn::ac::ResultCanceled() )
  {
    NN_LOG("nn::ac::Connect() failed  / ResultCanceled! \n"  );
  }
  else if( result == nn::ac::ResultAlreadyExists() )
  {
    NN_LOG("nn::ac::Connect() failed  / ResultAlreadyExists! \n"  );
  }
  else if( result == nn::ac::ResultFailedScan() )
  {
    NN_LOG("nn::ac::Connect() failed  / ResultFailedScan! \n"  );
  }
  else if( result == nn::ac::ResultConflictIpAddress() )
  {
    NN_LOG("nn::ac::Connect() failed  / ResultConflictIpAddress! \n"  );
  }
  else if( result == nn::ac::ResultFailedDhcp() )
  {
    NN_LOG("nn::ac::Connect() failed  / ResultFailedDhcp! \n"  );
  }
  else if( result == nn::ac::ResultInvalidDns() )
  {
    NN_LOG("nn::ac::Connect() failed  / ResultInvalidDns! \n"  );
  }
  else if( result == nn::ac::ResultInvalidProxy() )
  {
    NN_LOG("nn::ac::Connect() failed  / ResultInvalidProxy! \n"  );
  }
  else if( result == nn::ac::ResultUnsupportPlace() )
  {
    mmo::ui::ErrorView::SetErrorCode( mmo::ui::E_ERR_NOT_SUPPORT_AP );
  }
  else if( result == nn::ac::ResultFailedHotspotAuthentication() )
  {
    mmo::ui::ErrorView::SetErrorCode( mmo::ui::E_ERR_AUTH_AP );
  }
  else if( result == nn::ac::ResultOutOfMemory() )
  {
    mmo::ui::ErrorView::SetErrorCode( mmo::ui::E_ERR_OUT_OF_MEMORY );
  }
  else if( result == nn::ac::ResultAlreadyConnectUnsupportAp() )
  {
    mmo::ui::ErrorView::SetErrorCode( mmo::ui::E_ERR_NOT_SUPPORT_AP );
  }
  else if( result == nn::ac::ResultNotAgreeEula() )
  {
    mmo::ui::ErrorView::SetErrorCode( mmo::ui::E_ERR_NOT_AGREE_EULA );
  }
  else
  {
    mmo::ui::ErrorView::SetErrorCode( mmo::ui::E_ERR_WIFI_ERROR );
  }
  gflnet::wifi::WifiSystem::PrintError( result );
  */
}

//------------------------------------------------------------------
/**
 * @brief   vANZX|Cg̊Jn
 * @return  G[Ȃtrueԋp
 */
//------------------------------------------------------------------
bool WifiConnectRunner::StartupWifiSystem( void )
{
  nn::Result result = gflnet::wifi::WifiSystem::Initialize();

  if( result.IsFailure() )
  {
    GotoErrorView( result );
    return true;
  }

  result = gflnet::wifi::WifiSystem::Connect();

  if( result.IsFailure() )
  {
    GotoErrorView( result );
    return true;
  }
  GFL_PRINT( "StartupWifiSystem success\n" );

  return false;
}

//------------------------------------------------------------------
/**
 * @brief   vANZX|Cg̏I
 * @return  G[Ȃtrueԋp
 */
//------------------------------------------------------------------
bool WifiConnectRunner::EndWifiSystem( void )
{
  nn::Result result = gflnet::wifi::WifiSystem::Close();

  if( result.IsFailure() )
  {
    GotoErrorView( result );
    return true;
  }

  result = gflnet::wifi::WifiSystem::Finalize();

  if( result.IsFailure() )
  {
    GotoErrorView( result );
    return true;
  }
  GFL_PRINT( "EndWifiSystem success\n" );

  return false;
}

//------------------------------------------------------------------
/**
 * @brief   rVXe̊Jn
 * @return  G[Ȃtrueԋp
 */
//------------------------------------------------------------------
bool WifiConnectRunner::StartupSocketSystem( void )
{
  gfl::heap::HeapBase* heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_NETWORK );
  nn::Result result = gflnet::socket::SocketSystem::Initialize( heap );

  if( result.IsFailure() )
  {
    GotoErrorView( result );
    return true;
  }

  gflnet::socket::SocketSystem::DumpInfo();

  GFL_PRINT( "StartupSocketSystem success\n" );

  return false;
}


//------------------------------------------------------------------
/**
 * @brief   rVXȅI
 * @return  G[Ȃtrueԋp
 */
//------------------------------------------------------------------
bool WifiConnectRunner::EndSocketSystem( void )
{
  nn::Result result = gflnet::socket::SocketSystem::Finalize();

  if( result.IsFailure() )
  {
    GotoErrorView( result );
    return true;
  }
  GFL_PRINT( "EndSocketSystem success\n" );

  return false;
}


//------------------------------------------------------------------
/**
 * @brief   thv[X̊Jn
 * @return  G[Ȃtrueԋp
 */
//------------------------------------------------------------------
bool WifiConnectRunner::StartupFriendService( void )
{
  if( m_friendMgr->Login( this, nn::fnd::TimeSpan::FromSeconds(30), gfl::base::Thread::DefaultPriority) == nn::ResultSuccess() )
  {
    return false;
  }
  else
  {
    GFL_PRINT( "StartupFriendService failed\n" );
    return true;
  }
}


//------------------------------------------------------------------
/**
 * @brief   thv[X̏I
 */
//------------------------------------------------------------------
void WifiConnectRunner::EndFriendService( void )
{
  m_friendMgr->Logout();
  GFL_PRINT( "Friend Server Logout\n" );
}



//------------------------------------------------------------------
/**
 * @brief   NEX̊Jn
 * @return  G[Ȃtrueԋp
 */
//------------------------------------------------------------------
bool WifiConnectRunner::StartupNexService( void )
{
  gfl::heap::HeapBase* heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_NETWORK );

  if( m_nexMgr->Initialize( heap, FOR_NEX_LIB_HEAP_SIZE, FOR_NEX_LIB_SPARE_HEAP_SIZE ) == nn::ResultSuccess() )
  {
    GFL_PRINT( "NexManager::Initialize() Success\n" );
    return false;
  }
  else
  {
    GFL_PRINT( "StartupNexService failed\n" );
    return true;
  }
}


//------------------------------------------------------------------
/**
 * @brief   NEX̏I
 */
//------------------------------------------------------------------
void WifiConnectRunner::EndNexService( void )
{
  m_nexMgr->Finalize();
  GFL_PRINT( "NexManager::Finalize()\n" );
}


//------------------------------------------------------------------
/**
 * @brief   Q[T[o[ւ̃OC
 */
//------------------------------------------------------------------
bool WifiConnectRunner::LoginGameServer( void )
{
  if( !m_nexMgr->LoginGameServerAsync( NEX_GAME_ID, NEX_ACCESS_KEY, D_LOGIN_TIMEOUT) )
  {
    GFL_PRINT( "LoginGameServer failed\n" );
    return true;
  }
  return false;
}


//------------------------------------------------------------------
/**
 * @brief   Q[T[o[̃OAEg
 */
//------------------------------------------------------------------
bool WifiConnectRunner::LogoutGameServer( void )
{
  if( !m_nexMgr->LogoutGameServer() )
  {
    GFL_PRINT( "LogoutGameServer failed\n" );
    return true;
  }
  return false;
}


//------------------------------------------------------------------
/**
 * @brief   Subscription̊Jn
 */
//------------------------------------------------------------------
void WifiConnectRunner::StartSubscription( void )
{
  if( !m_subscrptionMgr->Initialize( m_nexMgr ) )
  {
    GFL_PRINT( "StartSubscription failed\n" );
  }
}


//------------------------------------------------------------------
/**
 * @brief   Subscription̏I
 */
//------------------------------------------------------------------
void WifiConnectRunner::EndSubscription( void )
{
  m_subscrptionMgr->Finalize();
}



//------------------------------------------------------------------
/**
 * @brief   ڑ
 */
//------------------------------------------------------------------
void WifiConnectRunner::Connect()
{
  m_counter++;

  switch( m_step )
  {
    case 0:
      m_isError = StartupWifiSystem();
      break;

    case 1:
      m_isError = StartupSocketSystem();
      break;

    // thT[oOC
    case 2:
      m_isError = StartupFriendService();
      break;
    case 3:
      if( !m_isFriendLoginFinish ){
        return;
      }
      break;

    // NEXJn
    case 4:
      m_isError = StartupNexService();
      break;

    // Q[T[oOC
    case 5:
      m_isError = LoginGameServer();
      break;
    case 6:
      nn::nex::Platform::Sleep( WifiConnectRunner::D_DISPATCH_PERIOD );
      nn::nex::Scheduler::GetInstance()->Dispatch( WifiConnectRunner::D_DISPATCH_TIMEOUT );
      if( !m_isGameServerLoginFinish ){
        return;
      }
      break;

    // Subscription
    case 7:
      StartSubscription();
      break;

/*
    case 8:
      EndSubscription();
      break;

    // Q[T[oOAEg
    case 9:
      m_isError = LogoutGameServer();
       break;
    case 10:
      nn::nex::Platform::Sleep(WifiConnectRunner::D_DISPATCH_PERIOD);
      nn::nex::Scheduler::GetInstance()->Dispatch(WifiConnectRunner::D_DISPATCH_TIMEOUT);
      if( !m_isGameServerLogoutFinish ){
        return;
      }
      break;

    // NEXI
    case 11:
      EndNexService();
      break;

    // thT[oOAEg
    case 12:
      EndFriendService();
      break;

    case 13:
      m_isError = EndSocketSystem();
      break;

    case 14:
      m_isError = EndWifiSystem();
      break;
*/

    default:
      m_isFinish = true;
      break;
  }
  m_step++;
}



//------------------------------------------------------------------
/**
 * @brief   I
 * @return  ZNVIȂtrueԋp
 */
//------------------------------------------------------------------
bool WifiConnectRunner::IsFinished( void ) const
{
  return m_isFinish;
}


//------------------------------------------------------------------
 /**
  * @brief   thT[oւ̃OCʒmnh
  */
 //------------------------------------------------------------------
void WifiConnectRunner::OnFriendServerLoginFinish( const nn::Result &result )
{
  if( result.IsFailure() )
  {
    GFL_PRINT( "Friend Server Login Failed[%d]\n", result.GetDescription() );
    m_isError  = true;
  }
  else
  {
    gflnet::friends::FriendKey keyList[10];
    size_t                     keyNum;

    gflnet::friends::PrincipalId pid = m_friendMgr->GetMyPrincipalId();
    nn::Result                   ret = m_friendMgr->GetFriendKeyList( keyList, &keyNum, 0, 10 );

    m_isFriendLoginFinish = true;

    GFL_PRINT( "Friend Server Login Success\n" );
    GFL_PRINT( "pid = [%u]\n", pid );
    GFL_PRINT( "friend num = [%u]\n", keyNum );
  }
}


//------------------------------------------------------------------
/**
* @brief Q[T[õOCʒm
*
* @param credential OCɔsꂽF؏
*/
//------------------------------------------------------------------
void WifiConnectRunner::OnGameServerLoginSuccess( nn::nex::Credentials* credential )
{
  GFL_PRINT( "OnGameServerLoginSuccess()\n" );
  m_isGameServerLoginFinish = true;
}


//------------------------------------------------------------------
/**
* @brief Q[T[õOCsʒm
*
* @param loginFuncResult nn::nex::NgsFacade::Login()̎s
* @param lastLoginErrorCode nn::nex::NgsFacade::GetLastLoginErrorCode()̒l
*/
//------------------------------------------------------------------
void WifiConnectRunner::OnGameServerLoginFailed( nn::nex::qResult loginFuncResult, qInt32 lastLoginErrorCode )
{
  GFL_PRINT( "OnGameServerLoginFailed()\n" );
  m_isError = true;
}


//------------------------------------------------------------------
/**
* @brief Q[T[õOAEgʒm
*/
//------------------------------------------------------------------
void WifiConnectRunner::OnGameServerLogoutSuccess( void )
{
  GFL_PRINT( "OnGameServerLogoutSuccess()\n" );
  m_isGameServerLogoutFinish = true;
}


//------------------------------------------------------------------
/**
* @brief Q[T[õOAEgsʒm
*
* @param logoutFuncResult nn::nex::NgsFacade::Logout()̎s
*/
//------------------------------------------------------------------
void WifiConnectRunner::OnGameServerLogoutFailed( nn::nex::qResult logoutFuncResult )
{
  GFL_PRINT( "OnGameServerLogoutFailed()\n" );
  m_isError = true;
}


//------------------------------------------------------------------
/**
 * @brief NEXŊmۂꂽq[v͊
 */
//------------------------------------------------------------------
void WifiConnectRunner::OnNexErrorOutOfMemory( void )
{
  GFL_PRINT( "OnNexErrorOutOfMemory()\n" );
  m_isError = true;
}


//------------------------------------------------------------------
/**
 * @brief NEX̃[jOʒm
 *
 * @param result     G[l
 * @param szFilename 肪t@C
 * @param uiLineNo   肪t@C̍s
 */
//------------------------------------------------------------------
void WifiConnectRunner::OnNexWarningHandling( nn::Result result, const qChar *szFilename, qUnsignedInt uiLineNo )
{
  GFL_PRINT( "OnNexWarningHandling()\n" );
}


//------------------------------------------------------------------
/**
 * @brief NEX̃G[ʒm
 *
 * @param result     G[l
 * @param szFilename 肪t@C
 * @param uiLineNo   肪t@C̍s   */
//------------------------------------------------------------------
void WifiConnectRunner::OnNexErrorHandling( nn::Result result, const qChar *szFilename, qUnsignedInt uiLineNo )
{
  GFL_PRINT( "OnNexErrorHandling()\n" );
  m_isError = true;
}


//------------------------------------------------------------------
/**
 * @brief CTRʂ̃G[ʒm
 *
 * @param result G[l
 * @param extra  gG[R[h
 */
//------------------------------------------------------------------
void WifiConnectRunner::OnNexErrorCommonCTR( const nn::nex::qResult &result, nn::nex::qInt32 extra )
{
  GFL_PRINT( "OnNexErrorCommonCTR()\n" );
  m_isError = true;
}


} // namespace wifi
} // namespace netapp
