//============================================================================================
/**
 * @brief WifiڑssNX
 */
//============================================================================================
#ifndef __WIFI_CONNECT_RUNNNER_
#define __WIFI_CONNECT_RUNNNER_


#include <gflib.h>
#include <gflnet.h>
#include <gamesystem/GameProc.h>
#include <gamesystem/GameManager.h>
#include <wifi/gflnet_WifiSystem.h>
#include <nex/gflnet_NexManager.h>
#include <friends/gflnet_FriendManager.h>
#include <nex/gflnet_NexManager.h>
#include <netapp/subscription/SubscriptionManager.h>

namespace netapp {
namespace wifi {

  class WifiConnectRunner : public gflnet::friends::FriendLoginListener,
                            public gflnet::nex::NexGameServerListener,
                            public gflnet::nex::NexErrorListener

  {
    public:
      typedef enum
      {
        E_RET_CONTINUE,
        E_RET_SUCCESS,
        E_RET_FAILED,
      }E_RET_CODE;

    private:
      // X[v鎞
      static const u32 D_DISPATCH_PERIOD = 100;
      // fBXpb`̑҂
      static const u32 D_DISPATCH_TIMEOUT = 100;
      // OC^CAEg
      static const u32 D_LOGIN_TIMEOUT  = 40000;

    public:
                   WifiConnectRunner( void );
      virtual      ~WifiConnectRunner();

    public:
      E_RET_CODE   Update( void );

    public:
      virtual void OnFriendServerLoginFinish( const nn::Result &result );
      //
      virtual void OnGameServerLoginSuccess( nn::nex::Credentials* credential );
      virtual void OnGameServerLoginFailed( nn::nex::qResult loginFuncResult, qInt32 lastLoginErrorCode );
      virtual void OnGameServerLogoutSuccess( void );
      virtual void OnGameServerLogoutFailed( nn::nex::qResult logoutFuncResult );
      //
      virtual void OnNexErrorOutOfMemory( void );
      virtual void OnNexWarningHandling( nn::Result result, const qChar *szFilename, qUnsignedInt uiLineNo );
      virtual void OnNexErrorHandling( nn::Result result, const qChar *szFilename, qUnsignedInt uiLineNo );
      virtual void OnNexErrorCommonCTR( const nn::nex::qResult &result, nn::nex::qInt32 extra );

    private:
      bool         IsFinished( void ) const;
      bool         StartupWifiSystem( void );
      bool         StartupSocketSystem( void );
      bool         StartupFriendService( void );
      bool         StartupNexService( void );
      bool         EndWifiSystem( void );
      bool         EndSocketSystem( void );
      void         EndFriendService( void );
      void         EndNexService( void );
      bool         LoginGameServer( void );
      bool         LogoutGameServer( void );
      void         GotoErrorView( nn::Result &result );
      void         StartSubscription( void );
      void         EndSubscription( void );
      void         Connect( void );

    private:
      bool                        m_isError;
      bool                        m_isFinish;
      bool                        m_isFriendLoginFinish;
      bool                        m_isGameServerLoginFinish;
      bool                        m_isGameServerLogoutFinish;
      u32                         m_step;
      u32                         m_counter;

      gflnet::friends::FriendManager*            m_friendMgr;
      gflnet::nex::NexManager*                   m_nexMgr;
      netapp::subscription::SubscriptionManager* m_subscrptionMgr;
  };


} // namespace wifi
} // namespace netapp

#endif // __WIFI_CONNECT_RUNNNER_

