//============================================================================================
/**
 * @file		app_tool_MenuCursor.cpp
 * @brief		ėpj[J[\
 * @author	Hiroyuki Nakamura
 * @date		12.05.29
 *
 * namespace	app::tool::
 */
//============================================================================================
#include "app/tool/app_tool_MenuCursor.h"
#include "menu_cursor_res.h"
#include "menu_cursor_res_pane.h"


namespace app {
namespace tool {

//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		lytsys		CAEgVXe
 */
//--------------------------------------------------------------------------------------------
MenuCursor::MenuCursor( gfl::grp::g2d::LytSys * lytsys ) :
	pUncomp( NULL ),
	pLytSys( lytsys ),
	pLytWk( NULL ),
	lytResID( RES_ID_NONE )
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
MenuCursor::~MenuCursor()
{
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuCursor::Update(void)
{
	if( pLytWk != NULL ){
		pLytWk->Update();
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		`
 *
 * @param		gra			OtBbNVXe
 * @param		disp		`fBXvC
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuCursor::Draw( gfl::grp::GraphicsSystem * gra, gfl::grp::DisplayType disp )
{
	if( pLytWk != NULL ){
		gfl::grp::RenderTarget * frame = gra->GetCurrentFrameBuffer( disp );
		pLytWk->Draw( gra, disp, frame );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Xbh𓀏
 *
 * @param		heap			q[v
 * @param		dev_heap	foCXq[vA
 * @param		priority	XbhvCIeB@ftHg=gfl::base::Thread::DefaultPriority
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuCursor::InitLayoutUncomp( gfl::heap::HeapBase * heap, gfl::heap::HeapBase * dev_heap, int priority )
{
	pUncomp = GFL_NEW_LOW( heap ) gfl::cx::StreamingUncomp();
	pUncomp->InitThreadUncomp( ARCID_COMMON_MENUCURSOR, 0, heap, dev_heap, &resBuff, priority );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Xbh𓀏
 *
 * @param		none
 *
 * @retval	"true = 𓀒"
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool MenuCursor::CheckLayoutUncomp(void)
{
	if( pUncomp != NULL ){
		if( pUncomp->ReadThreadUncomp() == true ){
			return true;
		}
		GFL_DELETE pUncomp;
		pUncomp = NULL;
	}
	return false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg\[Xǂݍ
 *
 * @param		heap						q[v
 * @param		dev_allocator		foCXq[vAP[^
 * @param		trans						eNX`]tO true = ]@ftHg = true
 *
 * @return	\[XID
 */
//--------------------------------------------------------------------------------------------
gfl::grp::g2d::LytResID MenuCursor::LoadLayoutResource(
													gfl::heap::HeapBase * heap, gfl::heap::NwAllocator * dev_allocator, bool trans )
{
	gfl::fs::ArcFile * af = GFL_NEW_LOW( heap ) gfl::fs::ArcFile( heap, ARCID_COMMON_MENUCURSOR, gfl::fs::ArcFile::OPEN );
	lytResID = pLytSys->LoadLytResComp( dev_allocator, af, 0 );
	GFL_DELETE af;

	if( trans == true ){
		pLytSys->TransferAllTexture( lytResID, gfl::grp::MEMORY_AREA_FCRAM );
	}

	return lytResID;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg\[Xǂݍ
 *
 * @param		dev_allocator		foCXq[vAP[^
 * @param		trans						eNX`]tO true = ]@ftHg = true
 *
 * @return	\[XID
 *
 * @li	InitLayoutUncomp()gpꍇ͂
 */
//--------------------------------------------------------------------------------------------
gfl::grp::g2d::LytResID MenuCursor::LoadLayoutResource( gfl::heap::NwAllocator * dev_allocator, bool trans )
{
	lytResID = pLytSys->LoadLytRes( dev_allocator, resBuff );
	if( trans == true ){
		pLytSys->TransferAllTexture( lytResID, gfl::grp::MEMORY_AREA_FCRAM );
	}
	return lytResID;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg\[X폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuCursor::ReleaseLayoutResource(void)
{
	if( lytResID != RES_ID_NONE ){
		pLytSys->ReleaseLytRes( lytResID );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg[N쐬
 *
 * @param		id					\[XID
 * @param		setup				CAEg[ÑZbgAbvf[^
 * @param		auto_draw		I[g`tO@ftHg = true
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuCursor::CreateLayoutWork( gfl::grp::g2d::LytResID id, const gfl::grp::g2d::LytWkSetUp * setup, bool auto_draw )
{
	static const gfl::grp::g2d::LytArcIndex tbl[] = {
		LYTRES_MENU_CURSOR_RES_CURSOR_BCLAN,
	};
	pLytWk = pLytSys->CreateLytWk(
						id, LYTRES_MENU_CURSOR_RES_CURSOR_BCLYT, tbl, GFL_NELEMS(tbl), GFL_NELEMS(tbl), setup, true );
	pLytWk->SetAutoDrawFlag( auto_draw );
	SetVisible( false );

	pLytWk->SetAutoAnime( 0, true );
	pLytWk->SetAnimeFrame( 0, 0 );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg[N쐬
 *
 * @param		setup				CAEg[ÑZbgAbvf[^
 * @param		auto_draw		I[g`tO@ftHg = true
 *
 * @return	none
 *
 * @li	LoadLayoutResource()gpꍇ͂
 */
//--------------------------------------------------------------------------------------------
void MenuCursor::CreateLayoutWork( const gfl::grp::g2d::LytWkSetUp * setup, bool auto_draw )
{
	CreateLayoutWork( lytResID, setup, auto_draw );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg[N폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuCursor::DeleteLayoutWork(void)
{
	if( pLytWk != NULL ){
		pLytSys->RemoveLytWk( pLytWk );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Wݒ
 *
 * @param		pos		W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuCursor::SetPos( gfl::math::VEC3 * pos )
{
  gfl::grp::g2d::LytWindow * win = pLytWk->GetWindowPane( PANENAME_CURSOR_PANE_WINDOW_02 );
	win->SetTranslate( *pos );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		WݒiyCwj
 *
 * @param		pane	ƂȂyC
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuCursor::SetPos( gfl::grp::g2d::LytPane * pane )
{
	gfl::math::VEC3	pos = pane->GetTranslate();
	SetPos( &pos );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		TCYݒ
 *
 * @param		w		
 * @param		h		
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuCursor::SetSize( f32 w, f32 h )
{
	gfl::grp::g2d::LytWindow * win = pLytWk->GetWindowPane( PANENAME_CURSOR_PANE_WINDOW_02 );
	nw::lyt::Size	size( w, h );
//	size.width += DEFAULT_WINDOW_FRAME_SIZE_X;
//	size.height += DEFAULT_WINDOW_FRAME_SIZE_Y;
	win->SetSize( size );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		TCYݒiyCwj
 *
 * @param		pane	ƂȂyC
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuCursor::SetSize( gfl::grp::g2d::LytPane * pane )
{
	nw::lyt::Size	size = pane->GetSize();
	SetSize( size.width, size.height );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		\؂ւ
 *
 * @param		flg		true = \, false = \
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuCursor::SetVisible( bool flg )
{
  gfl::grp::g2d::LytPane * pane = pLytWk->GetPane( PANENAME_CURSOR_PANE_WINDOW_02 );
	pane->SetVisible( flg );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		EBhEzu
 *
 * @param		lytwk		yC̃CAEg[N
 * @param		index		yC̃CfbNX
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void MenuCursor::Put( gfl::grp::g2d::LytWk * lytwk, gfl::grp::g2d::LytPaneIndex index )
{
  gfl::grp::g2d::LytPane * basePane = lytwk->GetPane( index );
	gfl::grp::g2d::LytPane * rootPane = lytwk->GetLayoutCore()->GetRootPane();
	gfl::math::VEC3	pos = basePane->GetTranslate();

	SetSize( basePane );

	while( 1 ){
	  gfl::grp::g2d::LytPane * parentPane = basePane->GetParent();
		// eȂ or e[gyC
		if( parentPane == NULL || parentPane == rootPane ){
			break;
		}
		pos += parentPane->GetTranslate();
		basePane = parentPane;
	}

	SetPos( &pos );

	SetVisible( true );
}


}	// tool
}	// app
