//============================================================================================
/**
 * @file		app_tool_MenuCursor.h
 * @brief		ėpj[J[\
 * @author	Hiroyuki Nakamura
 * @date		12.05.29
 *
 * namespace	app::tool::
 */
//============================================================================================
#if !defined( __APP_TOOL_MENUCURSOR_H__ )
#define __APP_TOOL_MENUCURSOR_H__

#include <gflib.h>


namespace app {
namespace tool {

class MenuCursor {
public:
/*
	static const f32 DEFAULT_WINDOW_FRAME_SIZE_X = 8.0f * 2.0f;		// E̘gTCY
	static const f32 DEFAULT_WINDOW_FRAME_SIZE_Y = 8.0f * 2.0f;		// ㉺̘gTCY
*/

	static const u32 RES_ID_NONE = 0xffffffff;		// \[XIDȂ


	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		lytsys		CAEgVXe
	 */
	//--------------------------------------------------------------------------------------------
	MenuCursor( gfl::grp::g2d::LytSys * lytsys );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	virtual ~MenuCursor();

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Abvf[g
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Update(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		`
	 *
	 * @param		gra			OtBbNVXe
	 * @param		disp		`fBXvC
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Draw( gfl::grp::GraphicsSystem * gra, gfl::grp::DisplayType disp );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Xbh𓀏
	 *
	 * @param		heap			q[v
	 * @param		dev_heap	foCXq[vA
	 * @param		priority	XbhvCIeB@ftHg=gfl::base::Thread::DefaultPriority
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void InitLayoutUncomp( gfl::heap::HeapBase * heap, gfl::heap::HeapBase * dev_heap, int priority=gfl::base::Thread::DefaultPriority );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Xbh𓀏
	 *
	 * @param		none
	 *
	 * @retval	"true = 𓀒"
	 * @retval	"false = ȊO"
	 */
	//--------------------------------------------------------------------------------------------
	bool CheckLayoutUncomp(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg\[Xǂݍ
	 *
	 * @param		heap						q[v
	 * @param		dev_allocator		foCXq[vAP[^
	 * @param		trans						eNX`]tO true = ]@ftHg = true
	 *
	 * @return	\[XID
	 */
	//--------------------------------------------------------------------------------------------
	gfl::grp::g2d::LytResID LoadLayoutResource(
														gfl::heap::HeapBase * heap, gfl::heap::NwAllocator * dev_allocator, bool trans=true );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg\[Xǂݍ
	 *
	 * @param		dev_allocator		foCXq[vAP[^
	 * @param		trans						eNX`]tO true = ]@ftHg = true
	 *
	 * @return	\[XID
	 *
	 * @li	InitLayoutUncomp()gpꍇ͂
	 */
	//--------------------------------------------------------------------------------------------
	gfl::grp::g2d::LytResID LoadLayoutResource( gfl::heap::NwAllocator * dev_allocator, bool trans=true );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg\[X폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void ReleaseLayoutResource(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg[N쐬
	 *
	 * @param		id					\[XID
	 * @param		setup				CAEg[ÑZbgAbvf[^
	 * @param		auto_draw		I[g`tO@ftHg = true
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateLayoutWork( gfl::grp::g2d::LytResID id, const gfl::grp::g2d::LytWkSetUp * setup, bool auto_draw=true );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg[N쐬
	 *
	 * @param		setup				CAEg[ÑZbgAbvf[^
	 * @param		auto_draw		I[g`tO@ftHg = true
	 *
	 * @return	none
	 *
	 * @li	LoadLayoutResource()gpꍇ͂
	 */
	//--------------------------------------------------------------------------------------------
	void CreateLayoutWork( const gfl::grp::g2d::LytWkSetUp * setup, bool auto_draw );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg[N폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteLayoutWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Wݒ
	 *
	 * @param		pos		W
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetPos( gfl::math::VEC3 * pos );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		WݒiyCwj
	 *
	 * @param		pane	ƂȂyC
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetPos( gfl::grp::g2d::LytPane * pane );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		TCYݒ
	 *
	 * @param		w		
	 * @param		h		
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetSize( f32 w, f32 h );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		TCYݒiyCwj
	 *
	 * @param		pane	ƂȂyC
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetSize( gfl::grp::g2d::LytPane * pane );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		\؂ւ
	 *
	 * @param		flg		true = \, false = \
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetVisible( bool flg );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		EBhEzu
	 *
	 * @param		lytwk		yC̃CAEg[N
	 * @param		index		yC̃CfbNX
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Put( gfl::grp::g2d::LytWk * lytwk, gfl::grp::g2d::LytPaneIndex index );


private:
	gfl::cx::StreamingUncomp * pUncomp;			// Xg[~O𓀏
	void * resBuff;

	gfl::grp::g2d::LytSys * pLytSys;
	gfl::grp::g2d::LytWk * pLytWk;
	gfl::grp::g2d::LytResID	lytResID;

};


}		// tool
}		// app

#endif // __APP_TOOL_MENUCURSOR_H__
