//==============================================================================
/**
 * @file	p2p_connection_manager.cpp
 * @brief	
 * @author	ichiraku_katsuhiko
 * @data	2012/05/23, 20:30
 */
// =============================================================================

#include <netapp/p2p_matching/p2p_connection_manager.h>


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(p2p_matching )


// RXgN^
P2P_ConnectionManager::P2P_ConnectionManager( void )
{
  m_pSysHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_NETWORK );
  m_pDevHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_RESIDENT_DEVICE );

	//-------------------------------------
  ///	
  //=====================================
	m_pP2pManager = NULL;
	m_pNetGame		= NULL;
	m_pNetPlayer	= NULL;

	m_TransferedID	= 0;
	m_MyTransferedID	= netapp::cfg::GetTransferableId();

	m_seq					= 0;
	m_isConnect		= false;
	m_isEnd				= false;
	m_reqDisconnect= false;

	//-------------------------------------
	/// ʐMݒ
  //=====================================
	gflnet::p2p::NETWORK_CONFIG cfg = {
    0,//  u32 maxSilenceTime;
    0,//  u32 keepAliveTimeout;
    0,//  u32 maxWindowMapSize;
    false,//  bool useUserDO;   //IuWFNg Duplicated Object̂
    // lbg[Ng|W֘AB
    nn::nex::NetworkTopology::Peer2Peer,
    false, // bool testRouting;

    // bZ[Woh֘A
    false, //  bool enableMessageBundle;
    0,//  u16  messageBundleFlushDelay;
    0,//  u16  messageBundleFlushCheckPeriod;

    // pPbgoh֘A
    false,//  bool enablePacketBundle;
    0,//  u32  packetBundleFlushDelay;

  };

	//-------------------------------------
	/// ʐMp[^iAvƂɈႤj
  //=====================================
  gflnet::InitParameter netInitParam = {
    0,
    m_pSysHeap,
    m_pDevHeap,
    NULL,
    gflnet::TYPE_WIRELESS_INIT,
    true,
    DEBUG_GAMENO_MATCH,  //debug
    2, //ڑl
    BEACON_MAX, 
  };
  netInitParam.TransferedID = m_MyTransferedID;

	//-------------------------------------
	/// ʐMp[^iAvłقڋʁj
  //=====================================
  gflnet::InitParameterFixed netInitParamFix = {
    XY_PRODUCT_CODE,  //
    0,  //܂̓}WbN @todo
    0, //܂̓}WbN @todo
    XY_NET_VERSION, //
  };	


	// P2PʐMǗNX쐬
  m_pP2pManager = GFL_NEW(m_pSysHeap) gflnet::p2p::P2pManager( m_pSysHeap, m_pDevHeap, m_pSysHeap );
  m_pP2pManager->Initialize( &cfg, &netInitParam, &netInitParamFix,
                            GFL_SINGLETON_INSTANCE(xynet::XyNetManager)->GetBeaconManager());

  m_pP2pManager->SetBeaconManager( GFL_SINGLETON_INSTANCE(xynet::XyNetManager)->GetBeaconManager() );

	// ʐM̑MNX쐬
  gflnet::p2p::GameInitialize init;
  init.max = 2;   //ڑMAX
  init.pHeapSystem = m_pSysHeap;  //ʐMŎgHEAPID

	m_pNetGame = GFL_NEW(m_pSysHeap) gflnet::p2p::NetGame(&init,m_pP2pManager->GetInitParam());

	ICHI_PRINT("P2P_ConnectionManager::P2P_ConnectionManager()\n");
}

// fXgN^

P2P_ConnectionManager::~P2P_ConnectionManager( void )
{
	GFL_SAFE_DELETE( m_pNetPlayer );
	GFL_SAFE_DELETE( m_pNetGame );
	GFL_SAFE_DELETE( m_pP2pManager );
	ICHI_PRINT("P2P_ConnectionManager::~P2P_ConnectionManager()\n");
}

// r[Rf[^Zbg
void P2P_ConnectionManager::SetBeaconData( const u8* beaconData, const u32 size )
{
  memcpy( m_SendBeacon, beaconData, size );
	m_SendBeaconSize = size;
	ICHI_PRINT("P2P_ConnectionManager::SetBeaconData\n");
}

// ڑJn
void P2P_ConnectionManager::Connect( bool isParent, const bit64 transferedID )
{
	// p[^Zbg
	m_isParent			= isParent;
	m_TransferedID	= transferedID ;

	GFL_PRINT("transferdID %llu \n", m_TransferedID );
	GFL_PRINT("MytransferdID %llu \n", m_MyTransferedID );
}

// XV
void P2P_ConnectionManager::Update( void )
{
	if( m_isParent == true )	{ Update_Parent();	}
	else											{ Update_Child();		}
}

// e̍XV
void P2P_ConnectionManager::Update_Parent( void )
{
	gfl::proc::MainStatus ms = m_pP2pManager->NetMain();

	switch( m_seq ){
	case 0:
		m_pP2pManager->Connect();
		m_seq++;
		ICHI_PRINT("UpdateParent 0\n");
		break;
	case 1:
		if( m_pP2pManager->IsConnectEnd() && (ms == gfl::proc::MAINSTATUS_NULL) )
		{
			m_pNetPlayer = GFL_NEW( m_pSysHeap ) gflnet::p2p::NetPlayer();
			m_pNetPlayer->SetTransferedID( m_TransferedID );// TransferdID
			m_pNetGame->Initialize();
			m_pP2pManager->CreateMaster( m_pNetPlayer );
			//m_pP2pManager->CreateMaster();

			m_seq++;
			ICHI_PRINT("UpdateParent 1\n");
		}
		break;
	case 2:
		if( m_pP2pManager->GetBeaconManager()->SetBeacon( m_SendBeacon, m_SendBeaconSize ) )
		{
			m_seq++;
			ICHI_PRINT("UpdateParent 2\n");
		}
		break;
	case 3:
		if( !m_pNetGame->IsInitialize() )
		{
			break;
		}
		if( m_pP2pManager->GetConnectionCount() == 2 )
		{
      if( m_pP2pManager->GameStart() ) 
			{
				m_seq++;
				ICHI_PRINT("UpdateParent 3\n");
			}
		}
		break;
	case 4:

		/*
		 * ʐMڑ
		 */
		m_isConnect = true;
		
		if( m_reqDisconnect == true )
		{
			m_seq++;
			ICHI_PRINT("UpdateParent 4\n");
		}
		break;
	case 5:
		m_pP2pManager->Disconnect();
		m_pP2pManager->Shutdown();
		m_pNetGame->Finalize();
		m_seq++;
		ICHI_PRINT("UpdateParent 5\n");
		break;
	case 6:
		if( m_pP2pManager->IsShutdownEnd() ){
			m_pP2pManager->Exit();
			m_seq++;
			ICHI_PRINT("UpdateParent 6\n");
		}
		break;
	case 7:
		if( m_pP2pManager->IsExitEnd() )
		{
			m_isEnd = true;
			ICHI_PRINT("UpdateParent 7\n");
		}
		break;
	}
}

// q̍XV
void P2P_ConnectionManager::Update_Child( void )
{
	gfl::proc::MainStatus ms = m_pP2pManager->NetMain();

	switch( m_seq ){
	case 0:
		m_pP2pManager->Connect();
		m_seq++;
		ICHI_PRINT("Update_Child 0\n");
		break;
	case 1:
		if( m_pP2pManager->IsConnectEnd() && (ms == gfl::proc::MAINSTATUS_NULL) )
		{
			m_seq++;
			ICHI_PRINT("Update_Child 1\n");
		}
		break;
	case 2:
		m_pNetPlayer = GFL_NEW( m_pSysHeap ) gflnet::p2p::NetPlayer();
		m_pNetPlayer->SetTransferedID( m_TransferedID );// TransferdID
		m_pNetGame->Initialize();
		m_pP2pManager->Matching( m_pNetPlayer );
		m_seq++;
		ICHI_PRINT("Update_Child 2\n");
		break;
	case 3:
		if( m_pP2pManager->IsMatchingEnd() )
		{
			m_seq++;
			ICHI_PRINT("Update_Child 3\n");
		}
		break;
	case 4:

		/*
		 * 󃋁[v
		 */
		m_isConnect = true;

		if( m_reqDisconnect == true )
		{
			m_seq++;
			ICHI_PRINT("Update_Child 4\n");
		}
		break;
	case 5:
		m_pP2pManager->Disconnect();
		m_pP2pManager->Shutdown();
		m_pNetGame->Finalize();
		m_seq++;
		ICHI_PRINT("Update_Child 5\n");
		break;
	case 6:
		if( m_pP2pManager->IsShutdownEnd() ){
			m_pP2pManager->Exit();
			m_seq++;
			ICHI_PRINT("Update_Child 6\n");
		}
		break;
	case 7:
		if( m_pP2pManager->IsExitEnd() )
		{
			m_isEnd = true;
			ICHI_PRINT("Update_Child 7\n");
		}
		break;
	}
}
				
GFL_NAMESPACE_END(p2p_matching )
GFL_NAMESPACE_END(netapp)
