//==============================================================================
/**
 * @file	p2p_connection_manager.h
 * @brief		p2pʐMڑ}l[W[
 * @author	ichiraku_katsuhiko
 * @data	2012/05/23, 20:28
 * 
 * @note	̓CX̂Ƃlč쐬Ă邪A
 *				CXwifip2pʐMʂłȂȂꍇ
 *				̃NX𒊏ۃNXƂČpĕʁXō
 */
// =============================================================================

#if !defined( __P2P_CONNECTION_MANAGER_H__ )
#define	__P2P_CONNECTION_MANAGER_H__

#include <gflib.h>
#include <gflnet.h>
#include <net/XyNetInterface.h>

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(p2p_matching )

class P2P_ConnectionManager : public xynet::XyNetInterface 
{
  GFL_FORBID_COPY_AND_ASSIGN( P2P_ConnectionManager ); // Rs[֎~

private:
	static const int BEACON_MAX = 10;

public:
  // RXgN^
  P2P_ConnectionManager( void );
  // fXgN^
  virtual ~P2P_ConnectionManager( void );

public:

	// r[Rf[^Zbg
	void SetBeaconData( const u8* beaconData, const u32 size );

	// ڑJn
  void Connect( bool isParent, const bit64 transferedID );
	
	// XV
	//@override
  virtual void Update( void );

	// I
	//@override
	//@note gpȂ
  virtual bool Finalize( void ){ return true; };

	// Ił
	//@override
	//@note gpȂ
  virtual bool IsFinalized( void ){ return true; };

	// ڑł
  inline bool IsConnect( void ){ return m_isConnect; }

	// INGXgs
	inline void SetReqDisconnect( void ){ m_reqDisconnect = true; };

	// Ił
	inline bool IsEnd( void ){ return m_isEnd; };

  inline gflnet::p2p::NetGame* GetNetGame( void ){ return m_pNetGame; };

private:

	// e̍XV
	void Update_Parent( void );
	// q̍XV
	void Update_Child( void );

	
private:
  //=====================================
	// ʐM֌W̃o
  gfl::heap::HeapBase*			m_pSysHeap;			///< {HEAP
  gfl::heap::HeapBase*			m_pDevHeap;			///< foCXq[v
	
  gflnet::p2p::P2pManager*	m_pP2pManager;	///< P2PǗNX
  gflnet::p2p::NetGame*			m_pNetGame;			///< MǗNX
  gflnet::p2p::NetPlayer*		m_pNetPlayer;		///< vC[̒ʐMNX

  bit64 m_TransferedID;				///< TransferedID
  bit64 m_MyTransferedID;			///< TransferedID

	u8		m_SendBeacon[ gflnet::base::BEACON_MAXBYTE ];	///< r[R
	u32		m_SendBeaconSize;															///< r[RTCY

  //=====================================
	// ֌W̃o
	int		m_seq;						///< V[PX
	bool	m_isParent;				///< eǂ
	bool	m_isConnect;			///< ڑĂ邩
	bool	m_isEnd;					///< IĂ邩
	bool	m_reqDisconnect;	///< INGXg


};

				
GFL_NAMESPACE_END(p2p_matching )
GFL_NAMESPACE_END(netapp)

#endif	/* __P2P_CONNECTION_MANAGER_H__ */

