
//=============================================================================
/**
 * @file   CameraUtility.cpp
 * @brief  [eBeB}NENX
 * @author ikeda_teppei
 * @date   2012.05.29
 */
//=============================================================================

#include "CameraUtility.h"

namespace field
{
  //-----------------------------------------------------------------------------
  // ̓WAl-΂+΂̊Ԃɕϊ
  //-----------------------------------------------------------------------------
  float CUtil::ConvertFromMinusPiToPlusPi(const float fRadi)
  {
    const float Pi   = gfl::math::F_PI;
    const float Pix2 = gfl::math::F_PIx2;
    if( fRadi >= -Pi && fRadi <= Pi ) return fRadi;
    else
    {
      const float fAngle = fRadi;
      float fOffset;
      *(u32*)&fOffset = (*(u32*)&Pi | (*(u32*)&fAngle & 0x80000000));
      return fAngle - Pix2 * (float)(int)((fAngle + fOffset) / Pix2);
    }
  }

} // namespace field

/*  EOF  */





