
//=============================================================================
/**
 * @file   CameraSpace.h
 * @brief  ԐNXwb_
 * @author rc N
 * @date   2012.05.29
 */
//=============================================================================

#ifndef __CAMERA_SPACE_H__
#define __CAMERA_SPACE_H__

namespace field
{
  /**
   * @brief [E҂E΂񂭊蓖ăCfbNX񋓌^
   */
  enum EAssignIndexYPB
  {
    ASSIGN_INDEX_YAW = 0 ,
    ASSIGN_INDEX_PITCH   ,
    ASSIGN_INDEX_BANK    ,
  };

  /**
   * @brief ԗ񋓌^
   *        eX(҂),Y([),Z(΂)]ǂ̏ԂŉĂ`񋓌^
   */
  enum ESolveAxisOrder
  {
    SOLVE_AXIS_ORDER_YPB = 0 , ///< [E҂E΂񂭂̏ŉ
  };

  /**
   * @brief ԐNX
   *        Ƀ}gNX̐]T|[gNX
   */
  class CSpace
  {
  public:
    //-----------------------------------------------------------------------------
    /**
     * @brief }gNX33𐶐
     *
     * @param pMat    o̓}gNX
     * @param inAxisX X
     * @param inAxisY Y
     * @param inAxisZ Z
     */
    //-----------------------------------------------------------------------------
    static inline void CreateMTX33(gfl::math::MTX33* pMat, const gfl::math::VEC3& inAxisX, const gfl::math::VEC3& inAxisY, const gfl::math::VEC3& inAxisZ)
    {
      pMat->m[0][0] = inAxisX.x, pMat->m[0][1] = inAxisY.x, pMat->m[0][2] = inAxisZ.x;
      pMat->m[1][0] = inAxisX.y, pMat->m[1][1] = inAxisY.y, pMat->m[1][2] = inAxisZ.y;
      pMat->m[2][0] = inAxisX.z, pMat->m[2][1] = inAxisY.z, pMat->m[2][2] = inAxisZ.z;
    }

    //-----------------------------------------------------------------------------
    /**
     * @brief }gNX33𐶐
     *
     * @param pMat       o̓}gNX
     * @param inFrontDir O
     * @param inUpDir    
     */
    //-----------------------------------------------------------------------------
    static void CreateMTX33ByFrontUpDirection(gfl::math::MTX33* pMat, const gfl::math::VEC3& inFrontDir, const gfl::math::VEC3& inUpDir);

    //---------------------------------------------------------------------------------------------------------------------
    // [E҂E΂  }gNX

    //-----------------------------------------------------------------------------
    /**
     * @brief [E҂擾
     *
     * @param pDir   o͕
     * @param fYaw   [(WA)
     * @param fPitch ҂(WA)
     */
    //-----------------------------------------------------------------------------
    static void GetDirectionByYawPitch(gfl::math::VEC3* pDir, const float fYaw, const float fPitch);

    //-----------------------------------------------------------------------------
    /**
     * @brief ̓}gNXɑ΂Ă[]s}gNX擾
     *
     * @param pDestMat       o̓}gNX
     * @param fYaw           [(WA)
     * @param bIsIdentityMat inSrcMatPʍs
     * @param inSrcMat       ̓}gNX
     */
    //-----------------------------------------------------------------------------
    static inline void GetYawRotMatrix(gfl::math::MTX33* pDestMat, const float fYaw, const bool bIsIdentityMat = true, const gfl::math::MTX33& inSrcMat = gfl::math::MTX33_IDENTITY)
    { GetYawPitchBankRotMatrix(pDestMat, gfl::math::VEC3(fYaw, 0.0f, 0.0f), bIsIdentityMat, inSrcMat); }

    //-----------------------------------------------------------------------------
    /**
     * @brief ̓}gNXɑ΂Ă҂]s}gNX擾
     *
     * @param pDestMat       o̓}gNX
     * @param fPitch         ҂(WA)
     * @param bIsIdentityMat inSrcMatPʍs
     * @param inSrcMat       ̓}gNX
     */
    //-----------------------------------------------------------------------------
    static inline void GetPitchRotMatrix(gfl::math::MTX33* pDestMat, const float fPitch, const bool bIsIdentityMat = true, const gfl::math::MTX33& inSrcMat = gfl::math::MTX33_IDENTITY)
    { GetYawPitchBankRotMatrix(pDestMat, gfl::math::VEC3(0.0f, fPitch, 0.0f), bIsIdentityMat, inSrcMat); }

    //-----------------------------------------------------------------------------
    /**
     * @brief ̓}gNXɑ΂Ă΂񂭉]s}gNX擾
     *
     * @param pDestMat       o̓}gNX
     * @param fBank          ΂(WA)
     * @param bIsIdentityMat inSrcMatPʍs
     * @param inSrcMat       ̓}gNX
     */
    //-----------------------------------------------------------------------------
    static inline void GetBankRotMatrix(gfl::math::MTX33* pDestMat, const float fBank, const bool bIsIdentityMat = true, const gfl::math::MTX33& inSrcMat = gfl::math::MTX33_IDENTITY)
    { GetYawPitchBankRotMatrix(pDestMat, gfl::math::VEC3(0.0f, 0.0f, fBank), bIsIdentityMat, inSrcMat); }

    //-----------------------------------------------------------------------------
    /**
     * @brief ̓}gNXɑ΂Ă[E҂E΂񂭉]s}gNX擾
     *
     * @param pDestMat       o̓}gNX
     * @param inYPB          [E҂E΂(WA)
     * @param bIsIdentityMat inSrcMatPʍs
     * @param inSrcMat       ̓}gNX
     */
    //-----------------------------------------------------------------------------
    static inline void GetYawPitchBankRotMatrix(gfl::math::MTX33* pDestMat, const gfl::math::VEC3& inYPB, const bool bIsIdentityMat = true, const gfl::math::MTX33& inSrcMat = gfl::math::MTX33_IDENTITY)
    { return GetYawPitchBankRotMatrixExtend(pDestMat, SOLVE_AXIS_ORDER_YPB, inYPB, bIsIdentityMat, inSrcMat); }

    //-----------------------------------------------------------------------------
    /**
     * @brief ̓}gNXɑ΂Ďw肵Ԃł[E҂E΂񂭉]s}gNX擾
     *
     * @param pDestMat        o̓}gNX
     * @param eSolveAxisOrder 
     * @param inYPB           [E҂E΂(WA)
     * @param bIsIdentityMat  inSrcMatPʍs
     * @param inSrcMat        ̓}gNX
     */
    //-----------------------------------------------------------------------------
    static void GetYawPitchBankRotMatrixExtend(gfl::math::MTX33* pDestMat, const ESolveAxisOrder eSolveAxisOrder, const gfl::math::VEC3& inYPB, bool bIsIdentityMat = true, const gfl::math::MTX33& inSrcMat = gfl::math::MTX33_IDENTITY);

    //---------------------------------------------------------------------------------------------------------------------
    // }gNX  [E҂E΂

    ///< ӂ̂[E҂擾ł邩`FbN
    static bool IsYawPitchGetDirection(const gfl::math::VEC3& inDir);

    //-----------------------------------------------------------------------------
    /**
     * @brief [E҂擾
     *
     * @param pfYaw   [
     * @param pfPitch ҂
     * @param inDir   
     * 
     * @retval true  ӂ̒l擾ł
     * @retval false ӂ̒l擾łȂ
     */
    //-----------------------------------------------------------------------------
    static bool GetYawPitchByDirection(float* pfYaw, float* pfPitch, const gfl::math::VEC3& inDir);

    //-----------------------------------------------------------------------------
    /**
     * @brief }gNX[E҂E΂񂭂擾
     *
     * @param pYPB  o͂[E҂E΂(WA)
     * @param inMat ̓}gNX
     */
    //-----------------------------------------------------------------------------
    static void GetYawPitchBankByMatrix(gfl::math::VEC3* pYPB, const gfl::math::MTX33& inMat);

    //-----------------------------------------------------------------------------
    /**
     * @brief }gNX[E҂E΂񂭂擾̊g
     *
     * @param pYPB            o͂[E҂E΂(WA)
     * @param eSolveAxisOrder 
     * @param inMat           ̓}gNX
     */
    //-----------------------------------------------------------------------------
	static void GetYawPitchBankByMatrixExtend(gfl::math::VEC3* pYPB, const ESolveAxisOrder eSolveAxisOrder, const gfl::math::MTX33& inMat);
  };

} // namespace field

#endif // __CAMERA_SPACE_H__

/*  EOF  */





